/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.uuid.ext;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LockedFile {
    private static final Logger logger = LoggerFactory.getLogger(LockedFile.class);
    static final int DEFAULT_LENGTH = 22;
    static final long READ_ERROR = 0L;
    final File mFile;
    RandomAccessFile mRAFile;
    FileChannel mChannel;
    FileLock mLock;
    ByteBuffer mWriteBuffer;
    boolean mWeirdSize;
    long mLastTimestamp;
    static final String HEX_DIGITS = "0123456789abcdef";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    LockedFile(File f) throws IOException {
        FileLock lock;
        FileChannel channel;
        RandomAccessFile raf;
        block5: {
            this.mWriteBuffer = null;
            this.mLastTimestamp = 0L;
            this.mFile = f;
            raf = null;
            channel = null;
            lock = null;
            boolean ok = false;
            try {
                raf = new RandomAccessFile(f, "rwd");
                channel = raf.getChannel();
                if (channel == null) {
                    throw new IOException("Failed to access channel for '" + f + "'");
                }
                lock = channel.tryLock();
                if (lock == null) {
                    throw new IOException("Failed to lock '" + f + "' (another JVM running UUIDGenerator?)");
                }
                ok = true;
                if (ok) break block5;
            }
            catch (Throwable throwable) {
                if (!ok) {
                    LockedFile.doDeactivate(f, raf, lock);
                }
                throw throwable;
            }
            LockedFile.doDeactivate(f, raf, lock);
        }
        this.mRAFile = raf;
        this.mChannel = channel;
        this.mLock = lock;
    }

    public void deactivate() {
        RandomAccessFile raf = this.mRAFile;
        this.mRAFile = null;
        FileLock lock = this.mLock;
        this.mLock = null;
        LockedFile.doDeactivate(this.mFile, raf, lock);
    }

    public long readStamp() {
        int size;
        try {
            size = (int)this.mChannel.size();
        }
        catch (IOException ioe) {
            logger.error("Failed to read file size", (Throwable)ioe);
            return 0L;
        }
        boolean bl = this.mWeirdSize = size != 22;
        if (size == 0) {
            logger.warn("Missing or empty file, can not read timestamp value");
            return 0L;
        }
        if (size > 100) {
            size = 100;
        }
        byte[] data = new byte[size];
        try {
            this.mRAFile.readFully(data);
        }
        catch (IOException ie) {
            logger.error("(file '{}') Failed to read {} bytes", new Object[]{this.mFile, size, ie});
            return 0L;
        }
        char[] cdata = new char[size];
        for (int i = 0; i < size; ++i) {
            cdata[i] = (char)(data[i] & 0xFF);
        }
        String dataStr = new String(cdata);
        dataStr = dataStr.trim();
        long result = -1L;
        String err = null;
        if (!dataStr.startsWith("[0") || dataStr.length() < 3 || Character.toLowerCase(dataStr.charAt(2)) != 'x') {
            err = "does not start with '[0x' prefix";
        } else {
            int ix = dataStr.indexOf(93, 3);
            if (ix <= 0) {
                err = "does not end with ']' marker";
            } else {
                String hex = dataStr.substring(3, ix);
                if (hex.length() > 16) {
                    err = "length of the (hex) timestamp too long; expected 16, had " + hex.length() + " ('" + hex + "')";
                } else {
                    try {
                        result = Long.parseLong(hex, 16);
                    }
                    catch (NumberFormatException nex) {
                        err = "does not contain a valid hex timestamp; got '" + hex + "' (parse error: " + nex + ")";
                    }
                }
            }
        }
        if (result < 0L) {
            logger.error("(file '{}') Malformed timestamp file contents: {}", (Object)this.mFile, (Object)err);
            return 0L;
        }
        this.mLastTimestamp = result;
        return result;
    }

    public void writeStamp(long stamp) throws IOException {
        if (stamp <= this.mLastTimestamp) {
            if (stamp == this.mLastTimestamp) {
                logger.warn("(file '{}') Trying to re-write existing timestamp ({})", (Object)this.mFile, (Object)stamp);
                return;
            }
            throw new IOException("" + this.mFile + " trying to overwrite existing value (" + this.mLastTimestamp + ") with an earlier timestamp (" + stamp + ")");
        }
        if (this.mWriteBuffer == null) {
            this.mWriteBuffer = ByteBuffer.allocate(22);
            this.mWriteBuffer.put(0, (byte)91);
            this.mWriteBuffer.put(1, (byte)48);
            this.mWriteBuffer.put(2, (byte)120);
            this.mWriteBuffer.put(19, (byte)93);
            this.mWriteBuffer.put(20, (byte)13);
            this.mWriteBuffer.put(21, (byte)10);
        }
        for (int i = 18; i >= 3; --i) {
            int val = (int)stamp & 0xF;
            this.mWriteBuffer.put(i, (byte)HEX_DIGITS.charAt(val));
            stamp >>= 4;
        }
        this.mWriteBuffer.position(0);
        this.mChannel.write(this.mWriteBuffer, 0L);
        if (this.mWeirdSize) {
            this.mRAFile.setLength(22L);
            this.mWeirdSize = false;
        }
        this.mChannel.force(false);
    }

    protected static void doDeactivate(File f, RandomAccessFile raf, FileLock lock) {
        if (lock != null) {
            try {
                lock.release();
            }
            catch (Throwable t) {
                logger.error("Failed to release lock (for file '{}')", (Object)f, (Object)t);
            }
        }
        if (raf != null) {
            try {
                raf.close();
            }
            catch (Throwable t) {
                logger.error("Failed to close file '{}'", (Object)f, (Object)t);
            }
        }
    }
}

