/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.query;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.CosmosException;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.query.IDocumentQueryExecutionComponent;
import com.azure.cosmos.implementation.query.LimitContinuationToken;
import com.azure.cosmos.implementation.query.PipelinedDocumentQueryParams;
import com.azure.cosmos.implementation.query.TopContinuationToken;
import com.azure.cosmos.models.FeedResponse;
import com.azure.cosmos.models.ModelBridgeInternal;
import java.util.HashMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;

public class TakeDocumentQueryExecutionContext<T>
implements IDocumentQueryExecutionComponent<T> {
    private static final Logger logger = LoggerFactory.getLogger(TakeDocumentQueryExecutionContext.class);
    private final IDocumentQueryExecutionComponent<T> component;
    private final int takeCount;
    private final TakeEnum takeEnum;

    public TakeDocumentQueryExecutionContext(IDocumentQueryExecutionComponent<T> component, int take, TakeEnum takeEnum) {
        this.component = component;
        this.takeCount = take;
        this.takeEnum = takeEnum;
    }

    public static <T> Flux<IDocumentQueryExecutionComponent<T>> createAsync(BiFunction<String, PipelinedDocumentQueryParams<T>, Flux<IDocumentQueryExecutionComponent<T>>> createSourceComponentFunction, int takeCount, String takeContinuationTokenString, PipelinedDocumentQueryParams<T> documentQueryParams, TakeEnum takeEnum) {
        switch (takeEnum) {
            case LIMIT: {
                return TakeDocumentQueryExecutionContext.createLimitAsync(createSourceComponentFunction, takeCount, takeContinuationTokenString, documentQueryParams);
            }
            case TOP: {
                return TakeDocumentQueryExecutionContext.createTopAsync(createSourceComponentFunction, takeCount, takeContinuationTokenString, documentQueryParams);
            }
        }
        throw new IllegalArgumentException("Unknown take enum: " + (Object)((Object)takeEnum));
    }

    private static <T> Flux<IDocumentQueryExecutionComponent<T>> createTopAsync(BiFunction<String, PipelinedDocumentQueryParams<T>, Flux<IDocumentQueryExecutionComponent<T>>> createSourceComponentFunction, int topCount, String topContinuationTokenString, PipelinedDocumentQueryParams<T> documentQueryParams) {
        TopContinuationToken topContinuationToken;
        if (topContinuationTokenString == null) {
            topContinuationToken = new TopContinuationToken(topCount, null);
        } else {
            Utils.ValueHolder<TopContinuationToken> outTopContinuationToken = new Utils.ValueHolder<TopContinuationToken>();
            if (!TopContinuationToken.tryParse(topContinuationTokenString, outTopContinuationToken)) {
                String message = String.format("INVALID JSON in continuation token %s for Top~Context", topContinuationTokenString);
                CosmosException dce = BridgeInternal.createCosmosException(400, message);
                return Flux.error((Throwable)((Object)dce));
            }
            topContinuationToken = (TopContinuationToken)outTopContinuationToken.v;
        }
        if (topContinuationToken.getTopCount() > topCount) {
            String message = String.format("top count in continuation token: %d can not be greater than the top count in the query: %d.", topContinuationToken.getTopCount(), topCount);
            CosmosException dce = BridgeInternal.createCosmosException(400, message);
            return Flux.error((Throwable)((Object)dce));
        }
        documentQueryParams.setTop(topCount);
        return createSourceComponentFunction.apply(topContinuationToken.getSourceToken(), documentQueryParams).map(component -> new TakeDocumentQueryExecutionContext(component, topContinuationToken.getTopCount(), TakeEnum.TOP));
    }

    private static <T> Flux<IDocumentQueryExecutionComponent<T>> createLimitAsync(BiFunction<String, PipelinedDocumentQueryParams<T>, Flux<IDocumentQueryExecutionComponent<T>>> createSourceComponentFunction, int limit, String limitContinuationTokenString, PipelinedDocumentQueryParams<T> documentQueryParams) {
        LimitContinuationToken limitContinuationToken;
        if (limitContinuationTokenString == null) {
            limitContinuationToken = new LimitContinuationToken(limit, null);
        } else {
            Utils.ValueHolder<LimitContinuationToken> outLimitContinuationToken = new Utils.ValueHolder<LimitContinuationToken>();
            if (!LimitContinuationToken.tryParse(limitContinuationTokenString, outLimitContinuationToken)) {
                String message = String.format("INVALID JSON in continuation token %s for Limit~Context", limitContinuationTokenString);
                CosmosException dce = BridgeInternal.createCosmosException(400, message);
                return Flux.error((Throwable)((Object)dce));
            }
            limitContinuationToken = (LimitContinuationToken)outLimitContinuationToken.v;
        }
        if (limitContinuationToken.getLimitCount() > limit) {
            String message = String.format("limit count in continuation token: %d can not be greater than the limit count in the query: %d.", limitContinuationToken.getLimitCount(), limit);
            CosmosException dce = BridgeInternal.createCosmosException(400, message);
            return Flux.error((Throwable)((Object)dce));
        }
        return createSourceComponentFunction.apply(limitContinuationToken.getSourceToken(), documentQueryParams).map(component -> new TakeDocumentQueryExecutionContext(component, limitContinuationToken.getLimitCount(), TakeEnum.LIMIT));
    }

    @Override
    public Flux<FeedResponse<T>> drainAsync(int maxPageSize) {
        return this.component.drainAsync(maxPageSize).takeUntil(new Predicate<FeedResponse<T>>(){
            private int fetchedItems = 0;

            @Override
            public boolean test(FeedResponse<T> frp) {
                this.fetchedItems += frp.getResults().size();
                return this.fetchedItems >= TakeDocumentQueryExecutionContext.this.takeCount;
            }
        }).map(new Function<FeedResponse<T>, FeedResponse<T>>(){
            private int collectedItems = 0;
            private boolean lastPage = false;

            @Override
            public FeedResponse<T> apply(FeedResponse<T> t) {
                if (this.collectedItems + t.getResults().size() <= TakeDocumentQueryExecutionContext.this.takeCount) {
                    this.collectedItems += t.getResults().size();
                    HashMap<String, String> headers = new HashMap<String, String>(t.getResponseHeaders());
                    if (TakeDocumentQueryExecutionContext.this.takeCount != this.collectedItems) {
                        String sourceContinuationToken = t.getContinuationToken();
                        if (sourceContinuationToken != null) {
                            String continuationTokenJson = null;
                            switch (TakeDocumentQueryExecutionContext.this.takeEnum) {
                                case LIMIT: {
                                    continuationTokenJson = new LimitContinuationToken(TakeDocumentQueryExecutionContext.this.takeCount - this.collectedItems, sourceContinuationToken).toJson();
                                    break;
                                }
                                case TOP: {
                                    continuationTokenJson = new TopContinuationToken(TakeDocumentQueryExecutionContext.this.takeCount - this.collectedItems, sourceContinuationToken).toJson();
                                }
                            }
                            headers.put("x-ms-continuation", continuationTokenJson);
                        } else {
                            headers.put("x-ms-continuation", null);
                        }
                    } else {
                        headers.put("x-ms-continuation", null);
                    }
                    return BridgeInternal.createFeedResponseWithQueryMetrics(t.getResults(), headers, BridgeInternal.queryMetricsFromFeedResponse(t), ModelBridgeInternal.getQueryPlanDiagnosticsContext(t), false, false, t.getCosmosDiagnostics());
                }
                assert (!this.lastPage);
                this.lastPage = true;
                int lastPageSize = TakeDocumentQueryExecutionContext.this.takeCount - this.collectedItems;
                this.collectedItems += lastPageSize;
                HashMap<String, String> headers = new HashMap<String, String>(t.getResponseHeaders());
                headers.put("x-ms-continuation", null);
                return BridgeInternal.createFeedResponseWithQueryMetrics(t.getResults().subList(0, lastPageSize), headers, BridgeInternal.queryMetricsFromFeedResponse(t), ModelBridgeInternal.getQueryPlanDiagnosticsContext(t), false, false, t.getCosmosDiagnostics());
            }
        });
    }

    static enum TakeEnum {
        LIMIT,
        TOP;

    }
}

