/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.CosmosDiagnostics;
import com.azure.cosmos.implementation.RxDocumentServiceResponse;
import com.azure.cosmos.implementation.Utils;
import com.fasterxml.jackson.databind.JsonNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StoredProcedureResponse {
    private static final Logger logger = LoggerFactory.getLogger(StoredProcedureResponse.class);
    private final RxDocumentServiceResponse response;

    public StoredProcedureResponse(RxDocumentServiceResponse response) {
        this.response = response;
    }

    public String getActivityId() {
        return this.response.getResponseHeaders().get("x-ms-activity-id");
    }

    public String getSessionToken() {
        return this.response.getResponseHeaders().get("x-ms-session-token");
    }

    public int getStatusCode() {
        return this.response.getStatusCode();
    }

    public String getMaxResourceQuota() {
        return this.response.getResponseHeaders().get("x-ms-resource-quota");
    }

    public String getCurrentResourceQuotaUsage() {
        return this.response.getResponseHeaders().get("x-ms-resource-usage");
    }

    public double getRequestCharge() {
        String value = this.response.getResponseHeaders().get("x-ms-request-charge");
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            logger.warn("INVALID x-ms-request-charge value {}.", (Object)value);
            return 0.0;
        }
    }

    public String getResponseAsString() {
        JsonNode json = this.response.getResponseBody();
        return json.toString();
    }

    public String getScriptLog() {
        String scriptLog = this.response.getResponseHeaders().get("x-ms-documentdb-script-log-results");
        return Utils.decodeAsUTF8String(scriptLog);
    }

    public CosmosDiagnostics getCosmosDiagnostics() {
        return this.response.getCosmosDiagnostics();
    }

    public RxDocumentServiceResponse getRxDocumentServiceResponse() {
        return this.response;
    }
}

