/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.type.MapType;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class ObjectNodeMap
implements Map<String, Object> {
    private static final ObjectMapper itemMapper = Utils.getSimpleObjectMapper();
    public static final MapType JACKSON_MAP_TYPE = itemMapper.getTypeFactory().constructMapType(LinkedHashMap.class, String.class, Object.class);
    private final Object thisLock = new Object();
    private final ObjectNode jsonNode;
    private volatile LinkedHashMap<String, Object> jsonNodeAsMap = null;

    public ObjectNodeMap(ObjectNode jsonNode) {
        Preconditions.checkNotNull(jsonNode, "Argument 'jsonNode' must not be null.");
        this.jsonNode = jsonNode;
    }

    public ObjectNode getObjectNode() {
        return this.jsonNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> ensureJsonNodeAsMap() {
        if (this.jsonNodeAsMap != null) {
            return this.jsonNodeAsMap;
        }
        Object object = this.thisLock;
        synchronized (object) {
            if (this.jsonNodeAsMap != null) {
                return this.jsonNodeAsMap;
            }
            this.jsonNodeAsMap = (LinkedHashMap)itemMapper.convertValue((Object)this.jsonNode, (JavaType)JACKSON_MAP_TYPE);
            return this.jsonNodeAsMap;
        }
    }

    @Override
    public int size() {
        return this.ensureJsonNodeAsMap().size();
    }

    @Override
    public boolean isEmpty() {
        return this.ensureJsonNodeAsMap().isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.ensureJsonNodeAsMap().containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.ensureJsonNodeAsMap().containsValue(value);
    }

    @Override
    public Object get(Object key) {
        return this.ensureJsonNodeAsMap().get(key);
    }

    @Override
    public Object put(String key, Object value) {
        return this.ensureJsonNodeAsMap().put(key, value);
    }

    @Override
    public Object remove(Object key) {
        return this.ensureJsonNodeAsMap().remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ?> m) {
        this.ensureJsonNodeAsMap().putAll(m);
    }

    @Override
    public void clear() {
        this.ensureJsonNodeAsMap().clear();
    }

    @Override
    public Set<String> keySet() {
        return this.ensureJsonNodeAsMap().keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.ensureJsonNodeAsMap().values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.ensureJsonNodeAsMap().entrySet();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ObjectNodeMap)) {
            return false;
        }
        ObjectNodeMap other = (ObjectNodeMap)o;
        return this.jsonNode.equals((Object)other.jsonNode);
    }

    @Override
    public int hashCode() {
        return this.jsonNode.hashCode();
    }
}

