/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.implementation.CompositeIndexUtilizationEntity;
import com.azure.cosmos.implementation.SingleIndexUtilizationEntity;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IndexUtilizationInfo {
    private static final Logger logger = LoggerFactory.getLogger((String)IndexUtilizationInfo.class.getSimpleName());
    static final IndexUtilizationInfo ZERO = new IndexUtilizationInfo(new ArrayList<SingleIndexUtilizationEntity>(), new ArrayList<SingleIndexUtilizationEntity>(), new ArrayList<CompositeIndexUtilizationEntity>(), new ArrayList<CompositeIndexUtilizationEntity>());
    @JsonProperty(value="UtilizedSingleIndexes", access=JsonProperty.Access.READ_WRITE)
    private List<SingleIndexUtilizationEntity> utilizedSingleIndexes;
    @JsonProperty(value="PotentialSingleIndexes", access=JsonProperty.Access.READ_WRITE)
    private List<SingleIndexUtilizationEntity> potentialSingleIndexes;
    @JsonProperty(value="UtilizedCompositeIndexes", access=JsonProperty.Access.READ_WRITE)
    private List<CompositeIndexUtilizationEntity> utilizedCompositeIndexes;
    @JsonProperty(value="PotentialCompositeIndexes", access=JsonProperty.Access.READ_WRITE)
    private List<CompositeIndexUtilizationEntity> potentialCompositeIndexes;

    IndexUtilizationInfo() {
    }

    IndexUtilizationInfo(List<SingleIndexUtilizationEntity> utilizedSingleIndexes, List<SingleIndexUtilizationEntity> potentialSingleIndexes, List<CompositeIndexUtilizationEntity> utilizedCompositeIndexes, List<CompositeIndexUtilizationEntity> potentialCompositeIndexes) {
        this.utilizedSingleIndexes = utilizedSingleIndexes;
        this.potentialSingleIndexes = potentialSingleIndexes;
        this.utilizedCompositeIndexes = utilizedCompositeIndexes;
        this.potentialCompositeIndexes = potentialCompositeIndexes;
    }

    public List<SingleIndexUtilizationEntity> getUtilizedSingleIndexes() {
        return this.utilizedSingleIndexes;
    }

    public List<SingleIndexUtilizationEntity> getPotentialSingleIndexes() {
        return this.potentialSingleIndexes;
    }

    public List<CompositeIndexUtilizationEntity> getUtilizedCompositeIndexes() {
        return this.utilizedCompositeIndexes;
    }

    public List<CompositeIndexUtilizationEntity> getPotentialCompositeIndexes() {
        return this.potentialCompositeIndexes;
    }

    public void setUtilizedSingleIndexes(List<SingleIndexUtilizationEntity> utilizedSingleIndexes) {
        this.utilizedSingleIndexes = utilizedSingleIndexes;
    }

    public void setPotentialSingleIndexes(List<SingleIndexUtilizationEntity> potentialSingleIndexes) {
        this.potentialSingleIndexes = potentialSingleIndexes;
    }

    public void setUtilizedCompositeIndexes(List<CompositeIndexUtilizationEntity> utilizedCompositeIndexes) {
        this.utilizedCompositeIndexes = utilizedCompositeIndexes;
    }

    public void setPotentialCompositeIndexes(List<CompositeIndexUtilizationEntity> potentialCompositeIndexes) {
        this.potentialCompositeIndexes = potentialCompositeIndexes;
    }

    static IndexUtilizationInfo createFromCollection(Collection<IndexUtilizationInfo> indexUtilizationInfoCollection) {
        if (indexUtilizationInfoCollection == null) {
            return null;
        }
        ArrayList<SingleIndexUtilizationEntity> utilizedSingleIndexes = new ArrayList<SingleIndexUtilizationEntity>();
        ArrayList<SingleIndexUtilizationEntity> potentialSingleIndexes = new ArrayList<SingleIndexUtilizationEntity>();
        ArrayList<CompositeIndexUtilizationEntity> utilizedCompositeIndexes = new ArrayList<CompositeIndexUtilizationEntity>();
        ArrayList<CompositeIndexUtilizationEntity> potentialCompositeIndexes = new ArrayList<CompositeIndexUtilizationEntity>();
        for (IndexUtilizationInfo indexUtilizationInfo : indexUtilizationInfoCollection) {
            if (indexUtilizationInfo == null) continue;
            utilizedSingleIndexes.addAll(indexUtilizationInfo.utilizedSingleIndexes);
            potentialSingleIndexes.addAll(indexUtilizationInfo.potentialSingleIndexes);
            utilizedCompositeIndexes.addAll(indexUtilizationInfo.utilizedCompositeIndexes);
            potentialCompositeIndexes.addAll(indexUtilizationInfo.potentialCompositeIndexes);
        }
        return new IndexUtilizationInfo(utilizedSingleIndexes, potentialSingleIndexes, utilizedCompositeIndexes, potentialCompositeIndexes);
    }

    static IndexUtilizationInfo createFromJSONString(String jsonString) {
        ObjectMapper indexUtilizationInfoObjectMapper = new ObjectMapper();
        IndexUtilizationInfo indexUtilizationInfo = null;
        try {
            indexUtilizationInfo = (IndexUtilizationInfo)indexUtilizationInfoObjectMapper.readValue(jsonString, IndexUtilizationInfo.class);
        }
        catch (JsonProcessingException e) {
            logger.error("Json not correctly formed ", (Throwable)e);
        }
        return indexUtilizationInfo;
    }
}

