/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.CosmosException;
import com.azure.cosmos.implementation.CosmosError;
import com.azure.cosmos.implementation.directconnectivity.HttpUtils;
import com.azure.cosmos.implementation.http.HttpHeaders;
import java.net.SocketAddress;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;

public class GoneException
extends CosmosException {
    private boolean basedOn410ResponseFromService = false;

    public GoneException(String msg) {
        this(msg, null, 0);
    }

    public GoneException(String msg, int subStatusCode) {
        this(msg, null, subStatusCode);
    }

    public GoneException() {
        this("The requested resource is no longer available at the server.", null, 0);
    }

    public GoneException(CosmosError cosmosError, long lsn, String partitionKeyRangeId, Map<String, String> responseHeaders, int subStatusCode) {
        super(410, cosmosError, responseHeaders);
        BridgeInternal.setLSN(this, lsn);
        BridgeInternal.setPartitionKeyRangeId(this, partitionKeyRangeId);
        this.setSubStatus(subStatusCode);
    }

    public GoneException(String resourceAddress, CosmosError cosmosError, long lsn, String partitionKeyRangeId, Map<String, String> responseHeaders, Throwable cause, int subStatusCode) {
        super(resourceAddress, 410, cosmosError, responseHeaders, cause);
        BridgeInternal.setLSN(this, lsn);
        BridgeInternal.setPartitionKeyRangeId(this, partitionKeyRangeId);
        this.setSubStatus(subStatusCode);
    }

    public GoneException(String message, String requestUri, int subStatusCode) {
        this(message, null, new HashMap<String, String>(), requestUri, subStatusCode);
    }

    public GoneException(String message, URI requestUri, Exception cause, int subStatusCode) {
        this(message, cause, null, requestUri, subStatusCode);
    }

    GoneException(Exception innerException) {
        this("The requested resource is no longer available at the server.", innerException, new HashMap<String, String>(), null, 0);
    }

    GoneException(String message, HttpHeaders headers, String requestUriString) {
        super(message, null, HttpUtils.asMap(headers), 410, requestUriString);
    }

    public GoneException(String message, HttpHeaders headers, URI requestUrl, int subStatusCode) {
        super(message, null, HttpUtils.asMap(headers), 410, requestUrl != null ? requestUrl.toString() : null);
        this.setSubStatus(subStatusCode);
    }

    public GoneException(String message, HttpHeaders headers, SocketAddress remoteAddress, int subStatusCode) {
        super(message, null, HttpUtils.asMap(headers), 410, remoteAddress != null ? remoteAddress.toString() : null);
        this.setSubStatus(subStatusCode);
    }

    public GoneException(String message, Exception innerException, HttpHeaders headers, URI requestUrl, int subStatusCode) {
        super(message, innerException, HttpUtils.asMap(headers), 410, requestUrl != null ? requestUrl.toString() : null);
        this.setSubStatus(subStatusCode);
    }

    public GoneException(String message, Exception innerException, Map<String, String> headers, String requestUriString, int subStatusCode) {
        super(message, innerException, headers, 410, requestUriString);
        this.setSubStatus(subStatusCode);
    }

    public boolean isBasedOn410ResponseFromService() {
        return this.basedOn410ResponseFromService;
    }

    public void setIsBasedOn410ResponseFromService() {
        this.basedOn410ResponseFromService = true;
    }

    private void setSubStatus(int subStatusCode) {
        this.getResponseHeaders().put("x-ms-substatus", Integer.toString(subStatusCode));
    }
}

