/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.changefeed.pkversion;

import com.azure.cosmos.ThroughputControlGroupConfig;
import com.azure.cosmos.implementation.changefeed.ChangeFeedContextClient;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.models.FeedRange;
import java.util.concurrent.atomic.AtomicBoolean;

public class FeedRangeThroughputControlConfigManager {
    private final ThroughputControlGroupConfig throughputControlGroupConfig;
    private final ChangeFeedContextClient documentClient;
    private final AtomicBoolean throughputControlGroupEnabled;

    public FeedRangeThroughputControlConfigManager(ThroughputControlGroupConfig throughputControlGroupConfig, ChangeFeedContextClient documentClient) {
        Preconditions.checkNotNull(throughputControlGroupConfig, "Argument 'throughputControlGroupConfig' can not be null");
        Preconditions.checkNotNull(documentClient, "Argument 'documentClient' can not be null");
        this.throughputControlGroupConfig = throughputControlGroupConfig;
        this.documentClient = documentClient;
        this.throughputControlGroupEnabled = new AtomicBoolean(false);
    }

    public ThroughputControlGroupConfig getThroughputControlConfigForFeedRange(FeedRange feedRange) {
        Preconditions.checkNotNull(feedRange, "Argument 'feedRange' can not be null");
        if (this.throughputControlGroupEnabled.compareAndSet(false, true)) {
            this.documentClient.getContainerClient().enableLocalThroughputControlGroup(this.throughputControlGroupConfig);
        }
        return this.throughputControlGroupConfig;
    }
}

