/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.CosmosException;
import com.azure.cosmos.implementation.BackoffRetryUtility;
import com.azure.cosmos.implementation.CosmosSchedulers;
import com.azure.cosmos.implementation.IRetryPolicy;
import com.azure.cosmos.implementation.Quadruple;
import com.azure.cosmos.implementation.RetryContext;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.ShouldRetryResult;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.apachecommons.lang.time.StopWatch;
import com.azure.cosmos.implementation.directconnectivity.AddressSelector;
import java.time.Duration;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

public class RetryUtils {
    private static final Logger logger = LoggerFactory.getLogger(BackoffRetryUtility.class);

    static Function<Flux<Throwable>, Flux<Long>> toRetryWhenFunc(IRetryPolicy policy) {
        return throwableFlux -> throwableFlux.flatMap(t -> {
            Exception e = Utils.as(t, Exception.class);
            if (e == null) {
                return Flux.error((Throwable)t);
            }
            RetryContext retryContext = policy.getRetryContext();
            if (retryContext != null) {
                retryContext.captureStartTimeIfNotSet();
            }
            Flux shouldRetryResultFlux = policy.shouldRetry(e).flux();
            return shouldRetryResultFlux.flatMap(s -> {
                CosmosException clientException = Utils.as(e, CosmosException.class);
                RetryUtils.addStatusSubStatusCodeOnRetryContext(retryContext, clientException, s.nonRelatedException);
                if (s.backOffTime != null) {
                    return Mono.delay((Duration)Duration.ofMillis(s.backOffTime.toMillis()), (Scheduler)CosmosSchedulers.COSMOS_PARALLEL).flux();
                }
                if (s.exception != null) {
                    return Flux.error((Throwable)s.exception);
                }
                return Flux.error((Throwable)t);
            });
        });
    }

    public static <T> Function<Throwable, Mono<T>> toRetryWithAlternateFunc(Function<Quadruple<Boolean, Boolean, Duration, Integer>, Mono<T>> callbackMethod, IRetryPolicy retryPolicy, Function<Quadruple<Boolean, Boolean, Duration, Integer>, Mono<T>> inBackoffAlternateCallbackMethod, Duration minBackoffForInBackoffCallback, RxDocumentServiceRequest rxDocumentServiceRequest, AddressSelector addressSelector) {
        return throwable -> {
            Exception e;
            RetryContext retryContext = retryPolicy.getRetryContext();
            if (retryContext != null) {
                retryContext.captureStartTimeIfNotSet();
                if (retryContext.getRetryCount() > 0) {
                    retryContext.updateEndTime();
                }
            }
            if ((e = Utils.as(throwable, Exception.class)) == null) {
                return Mono.error((Throwable)throwable);
            }
            Mono<ShouldRetryResult> shouldRetryResultFlux = retryPolicy.shouldRetry(e);
            return shouldRetryResultFlux.flatMap(shouldRetryResult -> {
                if (retryContext != null) {
                    CosmosException clientException = Utils.as(e, CosmosException.class);
                    RetryUtils.addStatusSubStatusCodeOnRetryContext(retryContext, clientException, shouldRetryResult.nonRelatedException);
                    retryContext.updateEndTime();
                }
                if (!shouldRetryResult.shouldRetry) {
                    Boolean forceAddressRefresh;
                    if (retryContext != null) {
                        retryContext.updateEndTime();
                    }
                    Exception errorToReturn = shouldRetryResult.exception != null ? shouldRetryResult.exception : e;
                    Mono failure = Mono.error((Throwable)errorToReturn);
                    if (shouldRetryResult.policyArg != null && (forceAddressRefresh = shouldRetryResult.policyArg.getValue0()) != null && forceAddressRefresh.booleanValue()) {
                        RetryUtils.startBackgroundAddressRefresh(rxDocumentServiceRequest, addressSelector);
                    }
                    return failure;
                }
                if (inBackoffAlternateCallbackMethod != null && shouldRetryResult.backOffTime.compareTo(minBackoffForInBackoffCallback) > 0) {
                    StopWatch stopwatch = new StopWatch();
                    RetryUtils.startStopWatch(stopwatch);
                    return ((Mono)inBackoffAlternateCallbackMethod.apply(shouldRetryResult.policyArg)).onErrorResume(RetryUtils.recursiveWithAlternateFunc(callbackMethod, retryPolicy, inBackoffAlternateCallbackMethod, shouldRetryResult, stopwatch, minBackoffForInBackoffCallback, rxDocumentServiceRequest, addressSelector));
                }
                if (shouldRetryResult.backOffTime == Duration.ZERO) {
                    return RetryUtils.recursiveFunc(callbackMethod, retryPolicy, inBackoffAlternateCallbackMethod, shouldRetryResult, minBackoffForInBackoffCallback, rxDocumentServiceRequest, addressSelector);
                }
                return Mono.defer(() -> RetryUtils.recursiveFunc(callbackMethod, retryPolicy, inBackoffAlternateCallbackMethod, shouldRetryResult, minBackoffForInBackoffCallback, rxDocumentServiceRequest, addressSelector)).delaySubscription(Duration.ofMillis(shouldRetryResult.backOffTime.toMillis()), CosmosSchedulers.COSMOS_PARALLEL);
            });
        };
    }

    private static void startBackgroundAddressRefresh(RxDocumentServiceRequest request, AddressSelector addressSelector) {
        addressSelector.resolveAddressesAsync(request, true).publishOn(Schedulers.boundedElastic()).subscribe(r -> {}, e -> logger.warn("Background refresh of addresses failed with {}", (Object)e.getMessage(), e));
    }

    private static <T> Mono<T> recursiveFunc(Function<Quadruple<Boolean, Boolean, Duration, Integer>, Mono<T>> callbackMethod, IRetryPolicy retryPolicy, Function<Quadruple<Boolean, Boolean, Duration, Integer>, Mono<T>> inBackoffAlternateCallbackMethod, ShouldRetryResult shouldRetryResult, Duration minBackoffForInBackoffCallback, RxDocumentServiceRequest rxDocumentServiceRequest, AddressSelector addressSelector) {
        return callbackMethod.apply(shouldRetryResult.policyArg).onErrorResume(RetryUtils.toRetryWithAlternateFunc(callbackMethod, retryPolicy, inBackoffAlternateCallbackMethod, minBackoffForInBackoffCallback, rxDocumentServiceRequest, addressSelector));
    }

    private static <T> Function<Throwable, Mono<T>> recursiveWithAlternateFunc(Function<Quadruple<Boolean, Boolean, Duration, Integer>, Mono<T>> callbackMethod, IRetryPolicy retryPolicy, Function<Quadruple<Boolean, Boolean, Duration, Integer>, Mono<T>> inBackoffAlternateCallbackMethod, ShouldRetryResult shouldRetryResult, StopWatch stopwatch, Duration minBackoffForInBackoffCallback, RxDocumentServiceRequest rxDocumentServiceRequest, AddressSelector addressSelector) {
        return throwable -> {
            Exception e = Utils.as(throwable, Exception.class);
            if (e == null) {
                return Mono.error((Throwable)throwable);
            }
            RetryUtils.stopStopWatch(stopwatch);
            logger.info("Failed inBackoffAlternateCallback with {}, proceeding with retry. Time taken: {}ms", (Object)e.toString(), (Object)stopwatch.getTime());
            Duration backoffTime = shouldRetryResult.backOffTime.toMillis() > stopwatch.getTime() ? Duration.ofMillis(shouldRetryResult.backOffTime.toMillis() - stopwatch.getTime()) : Duration.ZERO;
            return RetryUtils.recursiveFunc(callbackMethod, retryPolicy, inBackoffAlternateCallbackMethod, shouldRetryResult, minBackoffForInBackoffCallback, rxDocumentServiceRequest, addressSelector).delaySubscription(Duration.ofMillis(backoffTime.toMillis()), CosmosSchedulers.COSMOS_PARALLEL);
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void stopStopWatch(StopWatch stopwatch) {
        StopWatch stopWatch = stopwatch;
        synchronized (stopWatch) {
            stopwatch.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void startStopWatch(StopWatch stopwatch) {
        StopWatch stopWatch = stopwatch;
        synchronized (stopWatch) {
            stopwatch.start();
        }
    }

    private static void addStatusSubStatusCodeOnRetryContext(RetryContext retryContext, CosmosException clientException, boolean isNonRelatedException) {
        if (!isNonRelatedException && retryContext != null && clientException != null) {
            retryContext.addStatusAndSubStatusCode(clientException.getStatusCode(), clientException.getSubStatusCode());
        }
    }
}

