/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.CosmosException;
import com.azure.cosmos.implementation.CosmosError;
import com.azure.cosmos.implementation.directconnectivity.HttpUtils;
import com.azure.cosmos.implementation.http.HttpHeaders;
import java.net.URI;
import java.util.Map;

public class NotFoundException
extends CosmosException {
    private static final long serialVersionUID = 1L;

    public NotFoundException() {
        this("Entity with the specified id does not exist in the system. More info: https://aka.ms/cosmosdb-tsg-not-found-java");
    }

    public NotFoundException(CosmosError cosmosError, long lsn, String partitionKeyRangeId, Map<String, String> responseHeaders) {
        super(404, cosmosError, responseHeaders);
        BridgeInternal.setLSN(this, lsn);
        BridgeInternal.setPartitionKeyRangeId(this, partitionKeyRangeId);
    }

    public NotFoundException(String message) {
        this(message, null, (HttpHeaders)null, null);
    }

    public NotFoundException(String message, Map<String, String> headers, String requestUri) {
        this(message, null, headers, requestUri);
    }

    NotFoundException(String message, HttpHeaders headers, String requestUri) {
        this(message, null, headers, requestUri);
    }

    public NotFoundException(String message, HttpHeaders headers, URI requestUri) {
        this(message, headers, requestUri != null ? requestUri.toString() : null);
    }

    NotFoundException(Exception innerException) {
        this("Entity with the specified id does not exist in the system. More info: https://aka.ms/cosmosdb-tsg-not-found-java", innerException, (Map<String, String>)null, null);
    }

    NotFoundException(String message, Exception innerException, HttpHeaders headers, String requestUri) {
        this(message, innerException, HttpUtils.asMap(headers), requestUri);
    }

    NotFoundException(String message, Exception innerException, Map<String, String> headers, String requestUri) {
        super(String.format("%s: %s", "Entity with the specified id does not exist in the system. More info: https://aka.ms/cosmosdb-tsg-not-found-java", message), innerException, headers, 404, requestUri);
    }
}

