/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.implementation.ClientSideRequestStatistics;
import java.util.Collection;
import java.util.Iterator;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;

public class DistinctClientSideRequestStatisticsCollection
implements Queue<ClientSideRequestStatistics> {
    private final Queue<ClientSideRequestStatistics> queue = new ConcurrentLinkedQueue<ClientSideRequestStatistics>();
    private final Set<ClientSideRequestStatistics> set = ConcurrentHashMap.newKeySet();

    @Override
    public synchronized int size() {
        return this.set.size();
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.set.isEmpty();
    }

    @Override
    public synchronized boolean contains(Object o) {
        return this.set.contains(o);
    }

    @Override
    public synchronized Iterator<ClientSideRequestStatistics> iterator() {
        return this.queue.iterator();
    }

    @Override
    public synchronized Object[] toArray() {
        return this.queue.toArray();
    }

    @Override
    public synchronized <T> T[] toArray(T[] a) {
        return this.queue.toArray(a);
    }

    @Override
    public synchronized boolean add(ClientSideRequestStatistics clientSideRequestStatistics) {
        if (clientSideRequestStatistics == null) {
            return true;
        }
        boolean isNew = this.set.add(clientSideRequestStatistics);
        if (isNew) {
            return this.queue.add(clientSideRequestStatistics);
        }
        return false;
    }

    @Override
    public synchronized boolean remove(Object o) {
        if (o == null) {
            return true;
        }
        if (this.set.remove(o)) {
            return this.queue.remove(o);
        }
        return false;
    }

    @Override
    public synchronized boolean containsAll(Collection<?> c) {
        if (c == null || c.isEmpty()) {
            return true;
        }
        return this.set.containsAll(c);
    }

    @Override
    public synchronized boolean addAll(Collection<? extends ClientSideRequestStatistics> c) {
        if (c == null || c.isEmpty()) {
            return true;
        }
        boolean hasAddedAll = true;
        for (ClientSideRequestStatistics clientSideRequestStatistics : c) {
            if (this.set.add(clientSideRequestStatistics)) {
                hasAddedAll &= this.queue.add(clientSideRequestStatistics);
                continue;
            }
            hasAddedAll = false;
        }
        return hasAddedAll;
    }

    @Override
    public synchronized boolean removeAll(Collection<?> c) {
        if (c == null || c.isEmpty()) {
            return true;
        }
        this.set.removeAll(c);
        return this.queue.removeAll(c);
    }

    @Override
    public synchronized boolean retainAll(Collection<?> c) {
        if (c == null || c.isEmpty()) {
            return true;
        }
        this.set.retainAll(c);
        return this.queue.retainAll(c);
    }

    @Override
    public synchronized void clear() {
        this.set.clear();
        this.queue.clear();
    }

    @Override
    public synchronized boolean offer(ClientSideRequestStatistics clientSideRequestStatistics) {
        if (clientSideRequestStatistics == null) {
            return true;
        }
        boolean isAccepted = this.set.add(clientSideRequestStatistics);
        if (isAccepted) {
            return this.queue.offer(clientSideRequestStatistics);
        }
        return false;
    }

    @Override
    public synchronized ClientSideRequestStatistics remove() {
        ClientSideRequestStatistics candidate = this.queue.remove();
        this.set.remove(candidate);
        return candidate;
    }

    @Override
    public synchronized ClientSideRequestStatistics poll() {
        ClientSideRequestStatistics candidate = this.queue.poll();
        if (candidate != null) {
            this.set.remove(candidate);
        }
        return candidate;
    }

    @Override
    public ClientSideRequestStatistics element() {
        return this.queue.element();
    }

    @Override
    public ClientSideRequestStatistics peek() {
        return this.queue.peek();
    }
}

