/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.query.metrics;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.implementation.CompositeIndexUtilizationEntity;
import com.azure.cosmos.implementation.IndexUtilizationInfo;
import com.azure.cosmos.implementation.QueryMetrics;
import com.azure.cosmos.implementation.QueryPreparationTimes;
import com.azure.cosmos.implementation.RuntimeExecutionTimes;
import com.azure.cosmos.implementation.SingleIndexUtilizationEntity;
import com.azure.cosmos.implementation.apachecommons.lang.tuple.ImmutablePair;
import com.azure.cosmos.implementation.query.metrics.ClientSideMetrics;
import com.azure.cosmos.implementation.query.metrics.FetchExecutionRange;
import com.azure.cosmos.implementation.query.metrics.SchedulingTimeSpan;
import java.time.Duration;
import java.time.Instant;
import java.util.List;

abstract class QueryMetricsWriter {
    QueryMetricsWriter() {
    }

    public void writeQueryMetrics(QueryMetrics queryMetrics) {
        this.writeBeforeQueryMetrics();
        this.writeRetrievedDocumentCount(queryMetrics.getRetrievedDocumentCount());
        this.writeRetrievedDocumentSize(queryMetrics.getRetrievedDocumentSize());
        this.writeOutputDocumentCount(queryMetrics.getOutputDocumentCount());
        this.writeOutputDocumentSize(queryMetrics.getOutputDocumentSize());
        this.writeIndexHitRatio(queryMetrics.getIndexHitRatio());
        this.writeTotalQueryExecutionTime(queryMetrics.getTotalQueryExecutionTime());
        this.writeQueryPreparationTimes(queryMetrics.getQueryPreparationTimes());
        this.writeIndexLookupTime(queryMetrics.getIndexLookupTime());
        this.writeDocumentLoadTime(queryMetrics.getDocumentLoadTime());
        this.writeVMExecutionTime(queryMetrics.getVMExecutionTime());
        this.writeRuntimesExecutionTimes(queryMetrics.getRuntimeExecutionTimes());
        this.writeDocumentWriteTime(queryMetrics.getDocumentWriteTime());
        this.writeClientSideMetrics(BridgeInternal.getClientSideMetrics(queryMetrics));
        if (queryMetrics.getIndexUtilizationInfo() != null) {
            this.writeIndexUtilizationInfoMetrics(queryMetrics.getIndexUtilizationInfo());
        }
        this.writeAfterQueryMetrics();
    }

    protected abstract void writeBeforeQueryMetrics();

    protected abstract void writeRetrievedDocumentCount(long var1);

    protected abstract void writeRetrievedDocumentSize(long var1);

    protected abstract void writeOutputDocumentCount(long var1);

    protected abstract void writeOutputDocumentSize(long var1);

    protected abstract void writeIndexHitRatio(double var1);

    protected abstract void writeTotalQueryExecutionTime(Duration var1);

    private void writeQueryPreparationTimes(QueryPreparationTimes queryPreparationTimes) {
        this.writeBeforeQueryPreparationTimes();
        this.writeQueryCompilationTime(queryPreparationTimes.getQueryCompilationTime());
        this.writeLogicalPlanBuildTime(queryPreparationTimes.getLogicalPlanBuildTime());
        this.writePhysicalPlanBuildTime(queryPreparationTimes.getPhysicalPlanBuildTime());
        this.writeQueryOptimizationTime(queryPreparationTimes.getQueryOptimizationTime());
        this.writeAfterQueryPreparationTimes();
    }

    protected abstract void writeBeforeQueryPreparationTimes();

    protected abstract void writeQueryCompilationTime(Duration var1);

    protected abstract void writeLogicalPlanBuildTime(Duration var1);

    protected abstract void writePhysicalPlanBuildTime(Duration var1);

    protected abstract void writeQueryOptimizationTime(Duration var1);

    protected abstract void writeAfterQueryPreparationTimes();

    protected abstract void writeIndexLookupTime(Duration var1);

    protected abstract void writeDocumentLoadTime(Duration var1);

    protected abstract void writeVMExecutionTime(Duration var1);

    private void writeRuntimesExecutionTimes(RuntimeExecutionTimes runtimeExecutionTimes) {
        this.writeBeforeRuntimeExecutionTimes();
        this.writeQueryEngineExecutionTime(runtimeExecutionTimes.getQueryEngineExecutionTime());
        this.writeSystemFunctionExecutionTime(runtimeExecutionTimes.getSystemFunctionExecutionTime());
        this.writeUserDefinedFunctionExecutionTime(runtimeExecutionTimes.getUserDefinedFunctionExecutionTime());
        this.writeAfterRuntimeExecutionTimes();
    }

    protected abstract void writeBeforeRuntimeExecutionTimes();

    protected abstract void writeQueryEngineExecutionTime(Duration var1);

    protected abstract void writeSystemFunctionExecutionTime(Duration var1);

    protected abstract void writeUserDefinedFunctionExecutionTime(Duration var1);

    protected abstract void writeAfterRuntimeExecutionTimes();

    protected abstract void writeDocumentWriteTime(Duration var1);

    private void writeClientSideMetrics(ClientSideMetrics clientSideMetrics) {
        this.writeBeforeClientSideMetrics();
        this.writeRetries(clientSideMetrics.getRetries());
        this.writeRequestCharge(clientSideMetrics.getRequestCharge());
        this.writePartitionExecutionTimeline(clientSideMetrics);
        this.writeSchedulingMetrics(clientSideMetrics);
        this.writeAfterClientSideMetrics();
    }

    protected abstract void writeBeforeClientSideMetrics();

    protected abstract void writeRetries(long var1);

    protected abstract void writeRequestCharge(double var1);

    private void writePartitionExecutionTimeline(ClientSideMetrics clientSideMetrics) {
        this.writeBeforePartitionExecutionTimeline();
        List<FetchExecutionRange> fetchExecutionRanges = clientSideMetrics.getFetchExecutionRanges();
        fetchExecutionRanges.sort((f1, f2) -> f2.getStartTime().compareTo(f1.getStartTime()));
        for (FetchExecutionRange fetchExecutionRange : clientSideMetrics.getFetchExecutionRanges()) {
            this.writeFetchExecutionRange(fetchExecutionRange);
        }
        this.writeAfterPartitionExecutionTimeline();
    }

    protected abstract void writeBeforePartitionExecutionTimeline();

    private void writeFetchExecutionRange(FetchExecutionRange fetchExecutionRange) {
        this.writeBeforeFetchExecutionRange();
        this.writeFetchPartitionKeyRangeId(fetchExecutionRange.getPartitionId());
        this.writeActivityId(fetchExecutionRange.getActivityId());
        this.writeStartTime(fetchExecutionRange.getStartTime());
        this.writeEndTime(fetchExecutionRange.getEndTime());
        this.writeFetchDocumentCount(fetchExecutionRange.getNumberOfDocuments());
        this.writeFetchRetryCount(fetchExecutionRange.getRetryCount());
        this.writeAfterFetchExecutionRange();
    }

    protected abstract void writeBeforeFetchExecutionRange();

    protected abstract void writeFetchPartitionKeyRangeId(String var1);

    protected abstract void writeActivityId(String var1);

    protected abstract void writeStartTime(Instant var1);

    protected abstract void writeEndTime(Instant var1);

    protected abstract void writeFetchDocumentCount(long var1);

    protected abstract void writeFetchRetryCount(long var1);

    protected abstract void writeAfterFetchExecutionRange();

    protected abstract void writeAfterPartitionExecutionTimeline();

    private void writeSchedulingMetrics(ClientSideMetrics clientSideMetrics) {
        this.writeBeforeSchedulingMetrics();
        List<ImmutablePair<String, SchedulingTimeSpan>> partitionSchedulingTimeSpans = clientSideMetrics.getPartitionSchedulingTimeSpans();
        partitionSchedulingTimeSpans.sort((o1, o2) -> (int)(((SchedulingTimeSpan)o2.right).getResponseTime() - ((SchedulingTimeSpan)o1.right).getResponseTime()));
        for (ImmutablePair<String, SchedulingTimeSpan> partitionSchedulingDuration : partitionSchedulingTimeSpans) {
            String partitionId = partitionSchedulingDuration.getLeft();
            SchedulingTimeSpan schedulingDuration = partitionSchedulingDuration.getRight();
            this.writePartitionSchedulingDuration(partitionId, schedulingDuration);
        }
        this.writeAfterSchedulingMetrics();
    }

    protected abstract void writeBeforeSchedulingMetrics();

    private void writePartitionSchedulingDuration(String partitionId, SchedulingTimeSpan schedulingDuration) {
        this.writeBeforePartitionSchedulingDuration();
        this.writePartitionSchedulingDurationId(partitionId);
        this.writeResponseTime(schedulingDuration.getResponseTime());
        this.writeRunTime(schedulingDuration.getRunTime());
        this.writeWaitTime(schedulingDuration.getWaitTime());
        this.writeTurnaroundTime(schedulingDuration.getTurnaroundTime());
        this.writeNumberOfPreemptions(schedulingDuration.getNumPreemptions());
        this.writeAfterPartitionSchedulingDuration();
    }

    protected abstract void writeBeforePartitionSchedulingDuration();

    protected abstract void writePartitionSchedulingDurationId(String var1);

    protected abstract void writeResponseTime(long var1);

    protected abstract void writeRunTime(long var1);

    protected abstract void writeWaitTime(long var1);

    protected abstract void writeTurnaroundTime(long var1);

    protected abstract void writeNumberOfPreemptions(long var1);

    protected abstract void writeAfterPartitionSchedulingDuration();

    protected abstract void writeAfterSchedulingMetrics();

    protected abstract void writeAfterClientSideMetrics();

    private void writeIndexUtilizationInfoMetrics(IndexUtilizationInfo indexUtilizationInfo) {
        this.writeBeforeIndexUtilizationInfoMetrics();
        this.writeUtilizedSingleIndexesMetrics(indexUtilizationInfo);
        this.writePotentialSingleIndexesMetrics(indexUtilizationInfo);
        this.writeUtilizedCompositeIndexesMetrics(indexUtilizationInfo);
        this.writePotentialCompositeIndexesMetrics(indexUtilizationInfo);
        this.writeAfterIndexUtilizationInfoMetrics();
    }

    protected abstract void writeBeforeIndexUtilizationInfoMetrics();

    private void writeUtilizedSingleIndexesMetrics(IndexUtilizationInfo indexUtilizationInfo) {
        this.writeBeforeUtilizedSingleIndexesMetrics();
        if (indexUtilizationInfo.getUtilizedSingleIndexes() != null) {
            for (SingleIndexUtilizationEntity singleIndexUtilizationEntity : indexUtilizationInfo.getUtilizedSingleIndexes()) {
                this.writeUtilizedSingleIndex(singleIndexUtilizationEntity);
            }
        }
        this.writeAfterUtilizedSingleIndexesMetrics();
    }

    protected abstract void writeBeforeUtilizedSingleIndexesMetrics();

    private void writeUtilizedSingleIndex(SingleIndexUtilizationEntity singleIndexUtilizationEntity) {
        this.writeBeforeUtilizedSingleIndex();
        this.writeUtilizedSingleFilterExpression(singleIndexUtilizationEntity.getFilterExpression());
        this.writeUtilizedSingleIndexDocumentExpression(singleIndexUtilizationEntity.getIndexDocumentExpression());
        this.writeUtilizedSingleFilterExpressionPrecision(singleIndexUtilizationEntity.isFilterExpressionPrecision());
        this.writeUtilizedSingleIndexPlanFullFidelity(singleIndexUtilizationEntity.isIndexPlanFullFidelity());
        this.writeUtilizedSingleIndexImpactScore(singleIndexUtilizationEntity.getIndexImpactScore());
        this.writeAfterUtilizedSingleIndex();
    }

    protected abstract void writeBeforeUtilizedSingleIndex();

    protected abstract void writeUtilizedSingleFilterExpression(String var1);

    protected abstract void writeUtilizedSingleIndexDocumentExpression(String var1);

    protected abstract void writeUtilizedSingleFilterExpressionPrecision(boolean var1);

    protected abstract void writeUtilizedSingleIndexPlanFullFidelity(boolean var1);

    protected abstract void writeUtilizedSingleIndexImpactScore(String var1);

    protected abstract void writeAfterUtilizedSingleIndex();

    protected abstract void writeAfterUtilizedSingleIndexesMetrics();

    private void writePotentialSingleIndexesMetrics(IndexUtilizationInfo indexUtilizationInfo) {
        this.writeBeforePotentialSingleIndexesMetrics();
        if (indexUtilizationInfo.getPotentialSingleIndexes() != null) {
            for (SingleIndexUtilizationEntity singleIndexUtilizationEntity : indexUtilizationInfo.getPotentialSingleIndexes()) {
                this.writePotentialSingleIndex(singleIndexUtilizationEntity);
            }
        }
        this.writeAfterPotentialSingleIndexesMetrics();
    }

    protected abstract void writeBeforePotentialSingleIndexesMetrics();

    private void writePotentialSingleIndex(SingleIndexUtilizationEntity singleIndexUtilizationEntity) {
        this.writeBeforePotentialSingleIndex();
        this.writePotentialSingleFilterExpression(singleIndexUtilizationEntity.getFilterExpression());
        this.writePotentialSingleIndexDocumentExpression(singleIndexUtilizationEntity.getIndexDocumentExpression());
        this.writePotentialSingleFilterExpressionPrecision(singleIndexUtilizationEntity.isFilterExpressionPrecision());
        this.writePotentialSingleIndexPlanFullFidelity(singleIndexUtilizationEntity.isIndexPlanFullFidelity());
        this.writePotentialSingleIndexImpactScore(singleIndexUtilizationEntity.getIndexImpactScore());
        this.writeAfterPotentialSingleIndex();
    }

    protected abstract void writeBeforePotentialSingleIndex();

    protected abstract void writePotentialSingleFilterExpression(String var1);

    protected abstract void writePotentialSingleIndexDocumentExpression(String var1);

    protected abstract void writePotentialSingleFilterExpressionPrecision(boolean var1);

    protected abstract void writePotentialSingleIndexPlanFullFidelity(boolean var1);

    protected abstract void writePotentialSingleIndexImpactScore(String var1);

    protected abstract void writeAfterPotentialSingleIndex();

    protected abstract void writeAfterPotentialSingleIndexesMetrics();

    private void writeUtilizedCompositeIndexesMetrics(IndexUtilizationInfo indexUtilizationInfo) {
        this.writeBeforeUtilizedCompositeIndexesMetrics();
        if (indexUtilizationInfo.getUtilizedCompositeIndexes() != null) {
            for (CompositeIndexUtilizationEntity compositeIndexUtilizationEntity : indexUtilizationInfo.getUtilizedCompositeIndexes()) {
                this.writeUtilizedCompositeIndex(compositeIndexUtilizationEntity);
            }
        }
        this.writeAfterUtilizedCompositeIndexesMetrics();
    }

    protected abstract void writeBeforeUtilizedCompositeIndexesMetrics();

    private void writeUtilizedCompositeIndex(CompositeIndexUtilizationEntity compositeIndexUtilizationEntity) {
        this.writeBeforeUtilizedCompositeIndex();
        this.writeUtilizedCompositeIndexDocumentExpressions(compositeIndexUtilizationEntity.getIndexDocumentExpressions());
        this.writeUtilizedCompositeIndexPlanFullFidelity(compositeIndexUtilizationEntity.isIndexPlanFullFidelity());
        this.writeUtilizedCompositeIndexImpactScore(compositeIndexUtilizationEntity.getIndexImpactScore());
        this.writeAfterUtilizedCompositeIndex();
    }

    protected abstract void writeBeforeUtilizedCompositeIndex();

    protected abstract void writeUtilizedCompositeIndexDocumentExpressions(List<String> var1);

    protected abstract void writeUtilizedCompositeIndexPlanFullFidelity(boolean var1);

    protected abstract void writeUtilizedCompositeIndexImpactScore(String var1);

    protected abstract void writeAfterUtilizedCompositeIndex();

    protected abstract void writeAfterUtilizedCompositeIndexesMetrics();

    private void writePotentialCompositeIndexesMetrics(IndexUtilizationInfo indexUtilizationInfo) {
        this.writeBeforePotentialCompositeIndexesMetrics();
        if (indexUtilizationInfo.getPotentialCompositeIndexes() != null) {
            for (CompositeIndexUtilizationEntity compositeIndexUtilizationEntity : indexUtilizationInfo.getPotentialCompositeIndexes()) {
                this.writePotentialCompositeIndex(compositeIndexUtilizationEntity);
            }
        }
        this.writeAfterPotentialCompositeIndexesMetrics();
    }

    protected abstract void writeBeforePotentialCompositeIndexesMetrics();

    private void writePotentialCompositeIndex(CompositeIndexUtilizationEntity compositeIndexUtilizationEntity) {
        this.writeBeforePotentialCompositeIndex();
        this.writePotentialCompositeIndexDocumentExpressions(compositeIndexUtilizationEntity.getIndexDocumentExpressions());
        this.writePotentialCompositeIndexPlanFullFidelity(compositeIndexUtilizationEntity.isIndexPlanFullFidelity());
        this.writePotentialCompositeIndexImpactScore(compositeIndexUtilizationEntity.getIndexImpactScore());
        this.writeAfterPotentialCompositeIndex();
    }

    protected abstract void writeBeforePotentialCompositeIndex();

    protected abstract void writePotentialCompositeIndexDocumentExpressions(List<String> var1);

    protected abstract void writePotentialCompositeIndexPlanFullFidelity(boolean var1);

    protected abstract void writePotentialCompositeIndexImpactScore(String var1);

    protected abstract void writeAfterPotentialCompositeIndex();

    protected abstract void writeAfterPotentialCompositeIndexesMetrics();

    protected abstract void writeAfterIndexUtilizationInfoMetrics();

    protected abstract void writeAfterQueryMetrics();
}

