/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.changefeed.epkversion;

import com.azure.cosmos.ThroughputControlGroupConfig;
import com.azure.cosmos.ThroughputControlGroupConfigBuilder;
import com.azure.cosmos.implementation.PartitionKeyRange;
import com.azure.cosmos.implementation.changefeed.ChangeFeedContextClient;
import com.azure.cosmos.implementation.changefeed.Lease;
import com.azure.cosmos.implementation.feedranges.FeedRangeEpkImpl;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.implementation.routing.PartitionKeyInternalHelper;
import com.azure.cosmos.models.FeedRange;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class FeedRangeThroughputControlConfigManager {
    private static final Logger logger = LoggerFactory.getLogger(FeedRangeThroughputControlConfigManager.class);
    private final ThroughputControlGroupConfig throughputControlGroupConfig;
    private final ChangeFeedContextClient documentClient;
    private final AtomicReference<List<FeedRangeEpkImpl>> leaseTokens;
    private final Map<PartitionKeyRange, List<FeedRange>> pkRangeToFeedRangeMap;
    private final Map<FeedRange, ThroughputControlGroupConfig> feedRangeToThroughputControlGroupConfigMap;

    public FeedRangeThroughputControlConfigManager(ThroughputControlGroupConfig throughputControlGroupConfig, ChangeFeedContextClient documentClient) {
        Preconditions.checkNotNull(throughputControlGroupConfig, "Argument 'throughputControlGroupConfig' can not be null");
        Preconditions.checkNotNull(documentClient, "Argument 'documentClient' can not be null");
        this.throughputControlGroupConfig = throughputControlGroupConfig;
        this.documentClient = documentClient;
        this.leaseTokens = new AtomicReference();
        this.pkRangeToFeedRangeMap = new ConcurrentHashMap<PartitionKeyRange, List<FeedRange>>();
        this.feedRangeToThroughputControlGroupConfigMap = new ConcurrentHashMap<FeedRange, ThroughputControlGroupConfig>();
    }

    public Mono<Void> refresh(List<Lease> leases) {
        if (leases != null && !leases.isEmpty()) {
            this.leaseTokens.set(leases.stream().map(lease -> (FeedRangeEpkImpl)lease.getFeedRange()).collect(Collectors.toList()));
        }
        return this.documentClient.getOverlappingRanges(PartitionKeyInternalHelper.FullRange, false).doOnNext(pkRanges -> {
            if (!pkRanges.isEmpty()) {
                for (PartitionKeyRange pkRange : this.pkRangeToFeedRangeMap.keySet()) {
                    if (pkRanges.contains(pkRange)) continue;
                    List<FeedRange> feedRanges = this.pkRangeToFeedRangeMap.remove(pkRange);
                    logger.debug("PkRange {} does not exist any more, remove it from map. ", (Object)pkRange.getId());
                    for (FeedRange feedRange : feedRanges) {
                        this.feedRangeToThroughputControlGroupConfigMap.remove(feedRange);
                    }
                }
            }
        }).onErrorResume(throwable -> {
            logger.warn("Refresh pkRanges failed", throwable);
            return Mono.empty();
        }).then();
    }

    public Mono<ThroughputControlGroupConfig> getOrCreateThroughputControlConfigForFeedRange(FeedRangeEpkImpl feedRange) {
        Preconditions.checkNotNull(feedRange, "Argument 'feedRange' can not be null");
        ThroughputControlGroupConfig throughputControlGroupConfigForFeedRange = this.feedRangeToThroughputControlGroupConfigMap.get(feedRange);
        if (throughputControlGroupConfigForFeedRange != null) {
            return Mono.just((Object)throughputControlGroupConfigForFeedRange);
        }
        return this.createThroughputControlConfigForFeedRange(feedRange);
    }

    public Mono<ThroughputControlGroupConfig> createThroughputControlConfigForFeedRange(FeedRangeEpkImpl feedRange) {
        Preconditions.checkNotNull(feedRange, "Argument 'feedRange' can not be null");
        return this.documentClient.getOverlappingRanges(feedRange.getRange(), false).flatMap(partitionKeyRanges -> {
            if (partitionKeyRanges.isEmpty()) {
                return Mono.error((Throwable)new IllegalStateException("Failed to get overlapping partition key range for range " + feedRange));
            }
            if (partitionKeyRanges.size() > 1) {
                return Mono.error((Throwable)new IllegalStateException("There are more than one partition key ranges mapped to the lease feed range. This should never happen"));
            }
            this.pkRangeToFeedRangeMap.compute((PartitionKeyRange)partitionKeyRanges.get(0), (key, feedRangeList) -> {
                if (feedRangeList == null) {
                    feedRangeList = new ArrayList<FeedRangeEpkImpl>();
                }
                feedRangeList.add(feedRange);
                return feedRangeList;
            });
            long leasesBelongToSamePartitionKeyRange = this.leaseTokens.get().stream().filter(leaseToken -> leaseToken.getRange().getMin().compareTo(((PartitionKeyRange)partitionKeyRanges.get(0)).getMinInclusive()) >= 0 && leaseToken.getRange().getMax().compareTo(((PartitionKeyRange)partitionKeyRanges.get(0)).getMaxExclusive()) <= 0).count();
            ThroughputControlGroupConfig throughputControlGroupConfigForFeedRange = this.getThroughputControlGroupConfigInternal(feedRange, leasesBelongToSamePartitionKeyRange);
            return Mono.just((Object)this.feedRangeToThroughputControlGroupConfigMap.compute(feedRange, (key, config) -> throughputControlGroupConfigForFeedRange));
        }).onErrorResume(throwable -> {
            logger.warn("getThroughputControlConfigForLeaseFeedRange failed, using divide factor 1", throwable);
            return Mono.just((Object)this.getThroughputControlGroupConfigInternal(feedRange, 1L));
        });
    }

    private ThroughputControlGroupConfig getThroughputControlGroupConfigInternal(FeedRange feedRange, long perPartitionDivideFactor) {
        ThroughputControlGroupConfigBuilder throughputControlGroupConfigForFeedRangeBuilder = new ThroughputControlGroupConfigBuilder().groupName(this.throughputControlGroupConfig.getGroupName() + "-" + feedRange.toString()).continueOnInitError(this.throughputControlGroupConfig.continueOnInitError());
        if (this.throughputControlGroupConfig.getTargetThroughput() != null) {
            throughputControlGroupConfigForFeedRangeBuilder.targetThroughput((int)Math.max((long)this.throughputControlGroupConfig.getTargetThroughput().intValue() / perPartitionDivideFactor, 1L));
        }
        if (this.throughputControlGroupConfig.getTargetThroughputThreshold() != null) {
            throughputControlGroupConfigForFeedRangeBuilder.targetThroughputThreshold(this.throughputControlGroupConfig.getTargetThroughputThreshold() / (double)perPartitionDivideFactor);
        }
        if (this.throughputControlGroupConfig.getPriorityLevel() != null) {
            throughputControlGroupConfigForFeedRangeBuilder.priorityLevel(this.throughputControlGroupConfig.getPriorityLevel());
        }
        ThroughputControlGroupConfig throughputControlGroupConfigForFeedRange = throughputControlGroupConfigForFeedRangeBuilder.build();
        this.documentClient.getContainerClient().enableLocalThroughputControlGroup(throughputControlGroupConfigForFeedRange);
        return throughputControlGroupConfigForFeedRange;
    }
}

