/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.ThroughputControlGroupConfig;
import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.models.PriorityLevel;
import com.azure.cosmos.util.Beta;

public class ThroughputControlGroupConfigBuilder {
    private static final boolean DEFAULT_CONTINUE_ON_INIT_ERROR = false;
    private String groupName;
    private Integer targetThroughput;
    private Double targetThroughputThreshold;
    private boolean isDefault;
    private PriorityLevel priorityLevel;
    private boolean continueOnInitError = false;

    @Deprecated
    @Beta(value=Beta.SinceVersion.V4_13_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public ThroughputControlGroupConfigBuilder setGroupName(String groupName) {
        Preconditions.checkArgument(StringUtils.isNotEmpty(groupName), "Group name cannot be null nor empty");
        this.groupName = groupName;
        return this;
    }

    public ThroughputControlGroupConfigBuilder groupName(String groupName) {
        Preconditions.checkArgument(StringUtils.isNotEmpty(groupName), "Group name cannot be null nor empty");
        this.groupName = groupName;
        return this;
    }

    @Deprecated
    @Beta(value=Beta.SinceVersion.V4_13_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public ThroughputControlGroupConfigBuilder setTargetThroughput(int targetThroughput) {
        Preconditions.checkArgument(targetThroughput > 0, "Target throughput should be greater than 0");
        this.targetThroughput = targetThroughput;
        return this;
    }

    public ThroughputControlGroupConfigBuilder targetThroughput(int targetThroughput) {
        Preconditions.checkArgument(targetThroughput > 0, "Target throughput should be greater than 0");
        this.targetThroughput = targetThroughput;
        return this;
    }

    @Deprecated
    @Beta(value=Beta.SinceVersion.V4_13_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public ThroughputControlGroupConfigBuilder setTargetThroughputThreshold(double targetThroughputThreshold) {
        Preconditions.checkArgument(targetThroughputThreshold > 0.0 && targetThroughputThreshold <= 1.0, "Target throughput threshold should between (0, 1]");
        this.targetThroughputThreshold = targetThroughputThreshold;
        return this;
    }

    public ThroughputControlGroupConfigBuilder targetThroughputThreshold(double targetThroughputThreshold) {
        Preconditions.checkArgument(targetThroughputThreshold > 0.0 && targetThroughputThreshold <= 1.0, "Target throughput threshold should between (0, 1]");
        this.targetThroughputThreshold = targetThroughputThreshold;
        return this;
    }

    public ThroughputControlGroupConfigBuilder priorityLevel(PriorityLevel priorityLevel) {
        this.priorityLevel = priorityLevel;
        return this;
    }

    @Deprecated
    @Beta(value=Beta.SinceVersion.V4_13_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public ThroughputControlGroupConfigBuilder setDefault(boolean aDefault) {
        this.isDefault = aDefault;
        return this;
    }

    public ThroughputControlGroupConfigBuilder defaultControlGroup(boolean aDefault) {
        this.isDefault = aDefault;
        return this;
    }

    public ThroughputControlGroupConfigBuilder continueOnInitError(boolean continueOnInitError) {
        this.continueOnInitError = continueOnInitError;
        return this;
    }

    public ThroughputControlGroupConfig build() {
        if (StringUtils.isEmpty(this.groupName)) {
            throw new IllegalArgumentException("Group name cannot be null nor empty");
        }
        if (this.targetThroughput == null && this.targetThroughputThreshold == null && this.priorityLevel == null) {
            throw new IllegalArgumentException("All targetThroughput, targetThroughputThreshold and priorityLevel cannot be null or empty.");
        }
        if (this.targetThroughput == null && this.targetThroughputThreshold == null) {
            this.targetThroughput = Integer.MAX_VALUE;
        }
        return new ThroughputControlGroupConfig(this.groupName, this.targetThroughput, this.targetThroughputThreshold, this.priorityLevel, this.isDefault, this.continueOnInitError);
    }
}

