/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.CosmosDiagnostics;
import com.azure.cosmos.CosmosItemSerializer;
import com.azure.cosmos.implementation.Document;
import com.azure.cosmos.implementation.ImplementationBridgeHelpers;
import com.azure.cosmos.implementation.InternalObjectNode;
import com.azure.cosmos.implementation.ResourceResponse;
import com.azure.cosmos.implementation.SerializationDiagnosticsContext;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.apachecommons.lang.tuple.Pair;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;

public class CosmosItemResponse<T> {
    private final Class<T> itemClassType;
    private final CosmosItemSerializer itemSerializer;
    private volatile T item;
    private volatile JsonNode itemBodyOverride;
    final ResourceResponse<Document> resourceResponse;
    private InternalObjectNode props;
    private final AtomicBoolean hasTrackingIdCalculated = new AtomicBoolean(false);
    private boolean hasTrackingId;
    private final Supplier<Boolean> hasPayload;

    CosmosItemResponse(ResourceResponse<Document> response, Class<T> classType, CosmosItemSerializer itemSerializer) {
        this.itemClassType = classType;
        this.resourceResponse = response;
        this.itemSerializer = itemSerializer;
        this.item = null;
        this.hasPayload = response::hasPayload;
        this.itemBodyOverride = null;
    }

    private CosmosItemResponse(ResourceResponse<Document> response, T item, JsonNode itemBodyOverride, Class<T> classType, CosmosItemSerializer itemSerializer) {
        this.itemClassType = classType;
        this.resourceResponse = response;
        this.itemSerializer = itemSerializer;
        this.item = item;
        this.itemBodyOverride = itemBodyOverride;
        boolean hasPayloadStaticValue = item != null;
        this.hasPayload = () -> hasPayloadStaticValue;
    }

    private byte[] getItemAsByteArray() {
        JsonNode effectiveJson;
        if (this.item != null && this.itemClassType == Utils.byteArrayClass) {
            return (byte[])this.item;
        }
        JsonNode jsonNode = effectiveJson = this.itemBodyOverride != null ? this.itemBodyOverride : this.resourceResponse.getBody();
        if (effectiveJson == null) {
            return null;
        }
        return effectiveJson.toString().getBytes(StandardCharsets.UTF_8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getItem() {
        if (this.item != null) {
            return this.item;
        }
        SerializationDiagnosticsContext serializationDiagnosticsContext = BridgeInternal.getSerializationDiagnosticsContext(this.getDiagnostics());
        if (this.item == null) {
            CosmosItemResponse cosmosItemResponse = this;
            synchronized (cosmosItemResponse) {
                if (this.item == null && this.hasPayload.get().booleanValue()) {
                    if (this.itemClassType == Utils.byteArrayClass) {
                        Instant serializationStartTime = Instant.now();
                        JsonNode json = this.resourceResponse.getBody();
                        this.item = (T)json.toString().getBytes(StandardCharsets.UTF_8);
                        Instant serializationEndTime = Instant.now();
                        SerializationDiagnosticsContext.SerializationDiagnostics diagnostics = new SerializationDiagnosticsContext.SerializationDiagnostics(serializationStartTime, serializationEndTime, SerializationDiagnosticsContext.SerializationType.ITEM_DESERIALIZATION);
                        serializationDiagnosticsContext.addSerializationDiagnostics(diagnostics);
                        return this.item;
                    }
                    if (this.itemClassType == String.class) {
                        Instant serializationStartTime = Instant.now();
                        JsonNode json = this.resourceResponse.getBody();
                        this.item = json.toString();
                        Instant serializationEndTime = Instant.now();
                        SerializationDiagnosticsContext.SerializationDiagnostics diagnostics = new SerializationDiagnosticsContext.SerializationDiagnostics(serializationStartTime, serializationEndTime, SerializationDiagnosticsContext.SerializationType.ITEM_DESERIALIZATION);
                        serializationDiagnosticsContext.addSerializationDiagnostics(diagnostics);
                        return this.item;
                    }
                    if (this.itemClassType == InternalObjectNode.class) {
                        Instant serializationStartTime = Instant.now();
                        this.item = this.getProperties();
                        Instant serializationEndTime = Instant.now();
                        SerializationDiagnosticsContext.SerializationDiagnostics diagnostics = new SerializationDiagnosticsContext.SerializationDiagnostics(serializationStartTime, serializationEndTime, SerializationDiagnosticsContext.SerializationType.ITEM_DESERIALIZATION);
                        serializationDiagnosticsContext.addSerializationDiagnostics(diagnostics);
                        return this.item;
                    }
                    Instant serializationStartTime = Instant.now();
                    this.item = Utils.parse((ObjectNode)this.resourceResponse.getBody(), this.itemClassType, this.itemSerializer);
                    Instant serializationEndTime = Instant.now();
                    SerializationDiagnosticsContext.SerializationDiagnostics diagnostics = new SerializationDiagnosticsContext.SerializationDiagnostics(serializationStartTime, serializationEndTime, SerializationDiagnosticsContext.SerializationType.ITEM_DESERIALIZATION);
                    serializationDiagnosticsContext.addSerializationDiagnostics(diagnostics);
                    return this.item;
                }
            }
        }
        return this.item;
    }

    InternalObjectNode getProperties() {
        this.ensureInternalObjectNodeInitialized();
        return this.props;
    }

    int getResponsePayloadLength() {
        return this.resourceResponse.getResponsePayloadLength();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureInternalObjectNodeInitialized() {
        CosmosItemResponse cosmosItemResponse = this;
        synchronized (cosmosItemResponse) {
            this.props = !this.resourceResponse.hasPayload() ? null : new InternalObjectNode((ObjectNode)this.resourceResponse.getBody());
        }
    }

    public String getMaxResourceQuota() {
        return this.resourceResponse.getMaxResourceQuota();
    }

    public String getCurrentResourceQuotaUsage() {
        return this.resourceResponse.getCurrentResourceQuotaUsage();
    }

    public String getActivityId() {
        return this.resourceResponse.getActivityId();
    }

    public double getRequestCharge() {
        return this.resourceResponse.getRequestCharge();
    }

    public int getStatusCode() {
        return this.resourceResponse.getStatusCode();
    }

    public String getSessionToken() {
        return this.resourceResponse.getSessionToken();
    }

    public Map<String, String> getResponseHeaders() {
        return this.resourceResponse.getResponseHeaders();
    }

    public CosmosDiagnostics getDiagnostics() {
        return this.resourceResponse.getDiagnostics();
    }

    public Duration getDuration() {
        return this.resourceResponse.getDuration();
    }

    public String getETag() {
        return this.resourceResponse.getETag();
    }

    CosmosItemResponse<T> withRemappedStatusCode(int statusCode, double additionalRequestCharge, boolean isContentResponseOnWriteEnabled) {
        ResourceResponse<Document> mappedResourceResponse = this.resourceResponse.withRemappedStatusCode(statusCode, additionalRequestCharge);
        T payload = null;
        JsonNode itemBodyOverride = null;
        if (isContentResponseOnWriteEnabled) {
            payload = this.getItem();
            itemBodyOverride = this.itemBodyOverride;
        }
        return new CosmosItemResponse<Object>(mappedResourceResponse, payload, itemBodyOverride, (Class<Object>)this.itemClassType, this.itemSerializer);
    }

    boolean hasTrackingId(String candidate) {
        if (this.hasTrackingIdCalculated.compareAndSet(false, true)) {
            SerializationDiagnosticsContext serializationDiagnosticsContext = BridgeInternal.getSerializationDiagnosticsContext(this.getDiagnostics());
            Instant serializationStartTime = Instant.now();
            InternalObjectNode itemNode = this.getProperties();
            Instant serializationEndTime = Instant.now();
            SerializationDiagnosticsContext.SerializationDiagnostics diagnostics = new SerializationDiagnosticsContext.SerializationDiagnostics(serializationStartTime, serializationEndTime, SerializationDiagnosticsContext.SerializationType.ITEM_DESERIALIZATION);
            serializationDiagnosticsContext.addSerializationDiagnostics(diagnostics);
            this.hasTrackingId = itemNode != null && candidate.equals(itemNode.get("_trackingId"));
            return this.hasTrackingId;
        }
        return this.hasTrackingId;
    }

    static void initialize() {
        ImplementationBridgeHelpers.CosmosItemResponseHelper.setCosmosItemResponseBuilderAccessor(new ImplementationBridgeHelpers.CosmosItemResponseHelper.CosmosItemResponseBuilderAccessor(){

            @Override
            public <T> CosmosItemResponse<T> createCosmosItemResponse(CosmosItemResponse<byte[]> response, Class<T> classType, CosmosItemSerializer serializer) {
                return new CosmosItemResponse(response.resourceResponse, Utils.parse(((CosmosItemResponse)response).getItemAsByteArray(), classType, serializer), ((CosmosItemResponse)response).itemBodyOverride, classType, serializer);
            }

            @Override
            public <T> CosmosItemResponse<T> createCosmosItemResponse(ResourceResponse<Document> response, Class<T> classType, CosmosItemSerializer serializer) {
                return new CosmosItemResponse<T>(response, classType, serializer);
            }

            @Override
            public <T> CosmosItemResponse<T> withRemappedStatusCode(CosmosItemResponse<T> originalResponse, int newStatusCode, double additionalRequestCharge, boolean isContentResponseOnWriteEnabled) {
                return originalResponse.withRemappedStatusCode(newStatusCode, additionalRequestCharge, isContentResponseOnWriteEnabled);
            }

            @Override
            public byte[] getByteArrayContent(CosmosItemResponse<byte[]> response) {
                return ((CosmosItemResponse)response).getItemAsByteArray();
            }

            @Override
            public void setByteArrayContent(CosmosItemResponse<byte[]> response, Pair<byte[], JsonNode> content) {
                ((CosmosItemResponse)response).item = content.getLeft();
                ((CosmosItemResponse)response).itemBodyOverride = content.getRight();
            }

            @Override
            public ResourceResponse<Document> getResourceResponse(CosmosItemResponse<byte[]> response) {
                return response.resourceResponse;
            }

            @Override
            public boolean hasTrackingId(CosmosItemResponse<?> response, String candidate) {
                Preconditions.checkNotNull(response, "Argument 'response' must not be null.");
                Preconditions.checkNotNull(candidate, "Argument 'candidate' must not be null.");
                return response.hasTrackingId(candidate);
            }
        });
    }

    static {
        CosmosItemResponse.initialize();
    }
}

