/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.routing;

import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.routing.IPartitionKeyComponent;
import com.azure.cosmos.implementation.routing.PartitionKeyComponentType;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.io.OutputStream;

class StringPartitionKeyComponent
implements IPartitionKeyComponent {
    public static final int MAX_STRING_CHARS = 100;
    public static final int MAX_STRING_BYTES_TO_APPEND = 100;
    private final String value;
    private final byte[] utf8Value;

    public StringPartitionKeyComponent(String value) {
        if (value == null) {
            throw new IllegalArgumentException("value");
        }
        this.value = value;
        this.utf8Value = Utils.getUTF8Bytes(value);
    }

    @Override
    public int compareTo(IPartitionKeyComponent other) {
        StringPartitionKeyComponent otherString = Utils.as(other, StringPartitionKeyComponent.class);
        if (otherString == null) {
            throw new IllegalArgumentException("other");
        }
        return this.value.compareTo(otherString.value);
    }

    @Override
    public int getTypeOrdinal() {
        return PartitionKeyComponentType.STRING.type;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public IPartitionKeyComponent truncate() {
        if (this.value.length() > 100) {
            return new StringPartitionKeyComponent(this.value.substring(0, 100));
        }
        return this;
    }

    @Override
    public Object toObject() {
        return this.value;
    }

    @Override
    public void jsonEncode(JsonGenerator writer) {
        try {
            writer.writeString(this.value);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void writeForHashing(OutputStream outputStream) {
        try {
            outputStream.write((byte)PartitionKeyComponentType.STRING.type);
            outputStream.write(this.utf8Value);
            outputStream.write(0);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void writeForHashingV2(OutputStream outputStream) {
        try {
            outputStream.write((byte)PartitionKeyComponentType.STRING.type);
            outputStream.write(this.utf8Value);
            outputStream.write(-1);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void writeForBinaryEncoding(OutputStream outputStream) {
        try {
            outputStream.write((byte)PartitionKeyComponentType.STRING.type);
            boolean shortString = this.utf8Value.length <= 100;
            for (int index = 0; index < (shortString ? this.utf8Value.length : 101); ++index) {
                byte charByte = this.utf8Value[index];
                charByte = (byte)(charByte + 1);
                outputStream.write(charByte);
            }
            if (shortString) {
                outputStream.write(0);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

