/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.faultinjection;

import com.azure.cosmos.CosmosException;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.directconnectivity.rntbd.IRequestRecord;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdRequestRecord;
import com.azure.cosmos.implementation.faultinjection.IServerErrorInjector;
import com.azure.cosmos.implementation.faultinjection.RntbdFaultInjectionRequestArgs;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public class RntbdServerErrorInjector {
    private List<IServerErrorInjector> faultInjectors = new ArrayList<IServerErrorInjector>();

    public void registerServerErrorInjector(IServerErrorInjector serverErrorInjector) {
        Preconditions.checkNotNull(serverErrorInjector, "Argument 'serverErrorInjector' can not be null");
        this.faultInjectors.add(serverErrorInjector);
    }

    public boolean injectRntbdServerResponseDelayBeforeProcessing(RntbdRequestRecord requestRecord, Consumer<Duration> writeRequestWithDelayConsumer) {
        Utils.ValueHolder<Duration> injectedDelay = new Utils.ValueHolder<Duration>();
        for (IServerErrorInjector injector : this.faultInjectors) {
            if (!injector.injectServerResponseDelayBeforeProcessing(this.createFaultInjectionRequestArgs(requestRecord), injectedDelay)) continue;
            writeRequestWithDelayConsumer.accept((Duration)injectedDelay.v);
            return true;
        }
        return false;
    }

    public boolean injectRntbdServerResponseDelayAfterProcessing(RntbdRequestRecord requestRecord, Consumer<Duration> writeRequestWithDelayConsumer) {
        Utils.ValueHolder<Duration> injectedDelay = new Utils.ValueHolder<Duration>();
        for (IServerErrorInjector injector : this.faultInjectors) {
            if (!injector.injectServerResponseDelayAfterProcessing(this.createFaultInjectionRequestArgs(requestRecord), injectedDelay)) continue;
            writeRequestWithDelayConsumer.accept((Duration)injectedDelay.v);
            return true;
        }
        return false;
    }

    public boolean injectRntbdServerResponseError(RntbdRequestRecord requestRecord) {
        Utils.ValueHolder<CosmosException> injectedException = new Utils.ValueHolder<CosmosException>();
        for (IServerErrorInjector injector : this.faultInjectors) {
            if (!injector.injectServerResponseError(this.createFaultInjectionRequestArgs(requestRecord), injectedException)) continue;
            requestRecord.completeExceptionally((Throwable)injectedException.v);
            return true;
        }
        return false;
    }

    public boolean injectRntbdServerConnectionDelay(IRequestRecord requestRecord, Consumer<Duration> openConnectionWithDelayConsumer) {
        Utils.ValueHolder<Duration> injectedDelay = new Utils.ValueHolder<Duration>();
        for (IServerErrorInjector injector : this.faultInjectors) {
            if (!injector.injectServerConnectionDelay(this.createFaultInjectionRequestArgs(requestRecord), injectedDelay)) continue;
            openConnectionWithDelayConsumer.accept((Duration)injectedDelay.v);
            return true;
        }
        return false;
    }

    private RntbdFaultInjectionRequestArgs createFaultInjectionRequestArgs(RntbdRequestRecord requestRecord) {
        if (requestRecord == null) {
            return null;
        }
        return new RntbdFaultInjectionRequestArgs(requestRecord.args().transportRequestId(), requestRecord.args().physicalAddressUri().getURI(), requestRecord.args().physicalAddressUri().isPrimary(), requestRecord.args().serviceRequest());
    }

    private RntbdFaultInjectionRequestArgs createFaultInjectionRequestArgs(IRequestRecord requestRecord) {
        if (requestRecord == null) {
            return null;
        }
        return new RntbdFaultInjectionRequestArgs(requestRecord.getRequestId(), requestRecord.args().physicalAddressUri().getURI(), requestRecord.args().physicalAddressUri().isPrimary(), requestRecord.args().serviceRequest());
    }
}

