/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.changefeed.common;

import com.azure.cosmos.ChangeFeedProcessorContext;
import com.azure.cosmos.implementation.changefeed.ChangeFeedObserver;
import com.azure.cosmos.implementation.changefeed.ChangeFeedObserverFactory;
import com.azure.cosmos.implementation.changefeed.common.DefaultObserver;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultObserverFactory<T>
implements ChangeFeedObserverFactory<T> {
    private final Logger log = LoggerFactory.getLogger(DefaultObserverFactory.class);
    private final Consumer<List<T>> consumer;
    private final BiConsumer<List<T>, ChangeFeedProcessorContext> biConsumer;

    public DefaultObserverFactory(Consumer<List<T>> consumer) {
        this.consumer = consumer;
        this.biConsumer = null;
    }

    public DefaultObserverFactory(BiConsumer<List<T>, ChangeFeedProcessorContext> biConsumer) {
        this.biConsumer = biConsumer;
        this.consumer = null;
    }

    @Override
    public ChangeFeedObserver<T> createObserver() {
        if (this.consumer != null) {
            return new DefaultObserver<T>(this.consumer);
        }
        if (this.biConsumer != null) {
            return new DefaultObserver<T>(this.biConsumer);
        }
        throw new IllegalStateException("Both consumer and biConsumer cannot be null");
    }
}

