/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.CosmosException;
import com.azure.cosmos.implementation.DocumentClientRetryPolicy;
import com.azure.cosmos.implementation.Exceptions;
import com.azure.cosmos.implementation.RequestOptions;
import com.azure.cosmos.implementation.RetryContext;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.ShouldRetryResult;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.caches.RxClientCollectionCache;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicInteger;
import reactor.core.publisher.Mono;

public class PartitionKeyMismatchRetryPolicy
extends DocumentClientRetryPolicy {
    private static final int MaxRetries = 1;
    private RxClientCollectionCache clientCollectionCache;
    private DocumentClientRetryPolicy nextRetryPolicy;
    private AtomicInteger retriesAttempted = new AtomicInteger(0);
    private String collectionLink;
    private RequestOptions options;
    private RxDocumentServiceRequest request;

    public PartitionKeyMismatchRetryPolicy(RxClientCollectionCache clientCollectionCache, DocumentClientRetryPolicy nextRetryPolicy, String resourceFullName, RequestOptions requestOptions) {
        this.clientCollectionCache = clientCollectionCache;
        this.nextRetryPolicy = nextRetryPolicy;
        this.collectionLink = Utils.getCollectionName(resourceFullName);
        this.options = requestOptions;
    }

    @Override
    public Mono<ShouldRetryResult> shouldRetry(Exception exception) {
        CosmosException clientException = Utils.as(exception, CosmosException.class);
        if (clientException != null && Exceptions.isStatusCode(clientException, 400) && Exceptions.isSubStatusCode(clientException, 1001) && this.retriesAttempted.get() < 1) {
            if (this.options != null) {
                this.clientCollectionCache.refresh(BridgeInternal.getMetaDataDiagnosticContext(this.request.requestContext.cosmosDiagnostics), this.collectionLink, this.options.getProperties());
            } else {
                this.clientCollectionCache.refresh(BridgeInternal.getMetaDataDiagnosticContext(this.request.requestContext.cosmosDiagnostics), this.collectionLink, null);
            }
            this.retriesAttempted.incrementAndGet();
            return Mono.just((Object)ShouldRetryResult.retryAfter(Duration.ZERO));
        }
        return this.nextRetryPolicy.shouldRetry(exception);
    }

    @Override
    public void onBeforeSendRequest(RxDocumentServiceRequest request) {
        this.request = request;
        this.nextRetryPolicy.onBeforeSendRequest(request);
    }

    @Override
    public RetryContext getRetryContext() {
        if (this.nextRetryPolicy != null) {
            return this.nextRetryPolicy.getRetryContext();
        }
        return null;
    }
}

