/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.ConsistencyLevel;
import com.azure.cosmos.implementation.JsonSerializable;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.time.Duration;

public final class ConsistencyPolicy
extends JsonSerializable {
    private static final ConsistencyLevel DEFAULT_DEFAULT_CONSISTENCY_LEVEL = ConsistencyLevel.SESSION;
    private static final int DEFAULT_MAX_STALENESS_INTERVAL = 5;
    private static final int DEFAULT_MAX_STALENESS_PREFIX = 100;
    private ConsistencyLevel consistencyLevel = null;

    public ConsistencyPolicy() {
    }

    public ConsistencyPolicy(ObjectNode objectNode) {
        super(objectNode);
    }

    public ConsistencyPolicy(String jsonString) {
        super(jsonString);
    }

    public ConsistencyLevel getDefaultConsistencyLevel() {
        if (this.consistencyLevel == null) {
            ConsistencyLevel result = DEFAULT_DEFAULT_CONSISTENCY_LEVEL;
            String consistencyLevelString = super.getString("defaultConsistencyLevel");
            try {
                result = BridgeInternal.fromServiceSerializedFormat(consistencyLevelString);
            }
            catch (IllegalArgumentException e) {
                this.getLogger().warn("Unknown consistency level {}, value ignored.", (Object)consistencyLevelString);
            }
            this.consistencyLevel = result;
        }
        return this.consistencyLevel;
    }

    public ConsistencyPolicy setDefaultConsistencyLevel(ConsistencyLevel level) {
        this.consistencyLevel = level;
        super.set("defaultConsistencyLevel", level.toString());
        return this;
    }

    public int getMaxStalenessPrefix() {
        Integer value = super.getInt("maxStalenessPrefix");
        if (value == null) {
            return 100;
        }
        return value;
    }

    public ConsistencyPolicy setMaxStalenessPrefix(int maxStalenessPrefix) {
        super.set("maxStalenessPrefix", maxStalenessPrefix);
        return this;
    }

    public Duration getMaxStalenessInterval() {
        Integer value = super.getInt("maxIntervalInSeconds");
        if (value == null) {
            return Duration.ofSeconds(5L);
        }
        return Duration.ofSeconds(value.intValue());
    }

    public ConsistencyPolicy setMaxStalenessInterval(Duration maxStalenessInterval) {
        if (maxStalenessInterval == null) {
            throw new IllegalArgumentException("maxStalenessInterval should not be null");
        }
        super.set("maxIntervalInSeconds", maxStalenessInterval.getSeconds());
        return this;
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

