/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.CosmosAsyncUser;
import com.azure.cosmos.CosmosDatabase;
import com.azure.cosmos.models.CosmosUserProperties;
import com.azure.cosmos.models.CosmosUserResponse;

public class CosmosUser {
    private final CosmosAsyncUser asyncUser;
    private final CosmosDatabase database;
    private final String id;

    CosmosUser(CosmosAsyncUser asyncUser, CosmosDatabase database, String id) {
        this.asyncUser = asyncUser;
        this.database = database;
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public CosmosUserResponse read() {
        return this.database.blockUserResponse(this.asyncUser.read());
    }

    public CosmosUserResponse replace(CosmosUserProperties userProperties) {
        return this.database.blockUserResponse(this.asyncUser.replace(userProperties));
    }

    public CosmosUserResponse delete() {
        return this.database.blockUserResponse(this.asyncUser.delete());
    }
}

