/*
 * Decompiled with CFR 0.152.
 */
package com.inet.viewer.pdf.renderer;

import com.inet.lib.json.Json;
import com.inet.remote.gui.angular.AngularApplicationServlet;
import com.inet.report.PromptRequestWarning;
import com.inet.report.PropertiesChecker;
import com.inet.report.ReportException;
import com.inet.report.cache.Cache;
import com.inet.report.cache.EngineFactory;
import com.inet.report.cache.ReportCacheKey;
import com.inet.report.renderer.api.RendererFactory;
import com.inet.report.renderer.api.ToClientCmd;
import com.inet.report.renderer.doc.DocumentWriter;
import com.inet.report.renderer.pdf.PDFConfig;
import com.inet.report.renderer.pdf.PDFDocumentWriter;
import com.inet.report.util.EngineUtils;
import com.inet.report.util.SupplierWithException;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class a
implements RendererFactory,
ToClientCmd {
    private AngularApplicationServlet f;

    public a(AngularApplicationServlet angularApplicationServlet) {
        this.f = angularApplicationServlet;
    }

    @Nonnull
    public String getExtensionName() {
        return "pdfviewer";
    }

    @Nonnull
    public String getDisplayName() {
        return "PDF Viewer";
    }

    public boolean isViewer(String exportFormat) {
        return true;
    }

    @Nonnull
    public String getMimeType() {
        return "text/html; charset=utf-8";
    }

    public void decodeContentTypeAndFormat(@Nonnull String exportFormat, @Nonnull Properties props) throws ReportException {
        props.put("init", "pdfviewer");
        props.put("export_fmt", "pdf");
        props.put("content", "text/html; charset=utf-8");
    }

    @Nullable
    public ToClientCmd getToClientCmd(@Nonnull String exportFormat) {
        return this;
    }

    @Nullable
    public DocumentWriter getDocumentWriter(@Nonnull String exportFormat) {
        return new PDFDocumentWriter(new PDFConfig());
    }

    public void handle(@Nonnull Cache cache, @Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response, @Nonnull OutputStream out, @Nonnull SupplierWithException<ReportCacheKey> keySupplier, @Nonnull Properties props, @Nullable String page, @Nullable PropertiesChecker checker) throws Exception {
        try {
            Objects.requireNonNull(request);
            Objects.requireNonNull(response);
            cache.createKey(props, checker, (Object)request);
            EngineUtils.createReportGenerator((Properties)props, (PropertiesChecker)checker, (EngineFactory)Cache.getEngineFactory(), (Object)request);
            request.setAttribute("reportProps", (Object)props);
            this.f.service(request, response);
        }
        catch (ServletException servletException) {
            throw new IOException(servletException);
        }
    }

    public byte @Nullable [] getErrorData(Throwable th, Properties props) {
        if (!(th instanceof PromptRequestWarning)) {
            return super.getErrorData(th, props);
        }
        return new Json().toJson(Map.of("needsPrompts", Boolean.TRUE)).getBytes();
    }
}

