'use strict';(function(){angular.module(clearreportsApp.name).factory("pdfviewerFactory",["pdfviewer","sidenavigation","$timeout","$location","$window",function($pdfviewer,sidenavigation,$timeout,$location,$window){var $this=this;this.getPageCanvas=function(pageNumber){var pageId="#pdfjsViewer div.page[data-page-number\x3d"+pageNumber+"]";return $pdfviewer.viewer.find(pageId)};this.getPageView=function(pageNumber){return $pdfviewer.viewer.pdfViewer.getPageView((pageNumber||$pdfviewer.model.currentPage)-
1)};this.getPageViewport=function(pageNumber){return $this.getPageView(pageNumber).viewport};this.getScrollPanePadding=function(){return parseInt(window.getComputedStyle($pdfviewer.container[0]).paddingTop)};this.initPDFCSStoPDFUnits=function(){var viewport=$this.getPageViewport();var PDF_TO_CSS_UNITS=viewport.scale/$pdfviewer.getScale();return PDF_TO_CSS_UNITS};var ensurePageNumber=function(pageNumber){return Math.max(1,Math.min(pageNumber||$pdfviewer.model.currentPage,$pdfviewer.model.pdf.numPages))};
this.updateScrollPosition=function(pageNumber,bottom){pageNumber=ensurePageNumber(pageNumber);var padding=$this.getScrollPanePadding();var viewport=$this.getPageViewport(pageNumber);var $canvas=$this.getPageCanvas(pageNumber);var offset=$pdfviewer.scrollPane.scrollTop()+$canvas.offset().top-$pdfviewer.scrollPane.offset().top;var y=bottom?viewport.height/viewport.scale-bottom:0;$pdfviewer.scrollPane[0].scroll({top:y*$pdfviewer.getScale()+offset-padding,behavior:"smooth"});$pdfviewer.viewer.pdfViewer.currentPageNumber=
pageNumber};this.highlightSection=function(pageNumber,bottom,highlightBottom){pageNumber=ensurePageNumber(pageNumber);var pageview=$this.getPageView(pageNumber);var viewport=pageview.viewport;var $textLayerDiv=$(pageview.textLayer.div);var yTop=bottom<0?0:viewport.height/viewport.scale-bottom;var yBottom=viewport.height/viewport.scale-highlightBottom;return $('\x3cdiv class\x3d"highlight"\x3e\x3c/div\x3e').css({top:yTop*$pdfviewer.getScale(),height:(yBottom-yTop)*$pdfviewer.getScale()}).appendTo($textLayerDiv)};
this.setZoom=function(newZoom){var viewerTop=$pdfviewer.scrollPane.offset().top;var viewerWidth=$pdfviewer.scrollPane.outerWidth();var viewerHeight=$pdfviewer.scrollPane.outerHeight();var canvases=$pdfviewer.viewer.find("div.page");var currentVisiblePage=1;for(var i=0;i<canvases.length;i++){var canvas=$(canvases[i]);var canvasTop=canvas.offset().top;var canvasHeight=canvas.outerHeight();if(canvasTop+canvasHeight>viewerTop&&canvasTop+canvasHeight<viewerTop+viewerHeight||canvasTop<viewerTop&&canvasTop+
canvasHeight>viewerTop+viewerHeight){currentVisiblePage=i+1;break}}var padding=$this.getScrollPanePadding();var offsetLeft=viewerWidth/2;var currentLeft=($pdfviewer.scrollPane.scrollLeft()-padding+offsetLeft)/$pdfviewer.getScale();padding=padding*currentVisiblePage;var currentTop=($pdfviewer.scrollPane.scrollTop()-padding)/$pdfviewer.getScale();$pdfviewer.model.currentZoom=newZoom;var adjustedScale=$pdfviewer.getScale()/$pdfviewer.PDF_CSS_UNIT;$pdfviewer.viewer.pdfViewer.currentScaleValue=adjustedScale;
$pdfviewer.scrollPane[0].scroll({top:currentTop*$pdfviewer.getScale()+padding,left:currentLeft*$pdfviewer.getScale()+padding-offsetLeft})};this.setZoomFor=function(maxX,maxY){$pdfviewer.model.pdf.getPage($pdfviewer.model.currentPage).then(function(page){var padding=$this.getScrollPanePadding();maxX&&(maxX-=2*padding);maxY&&(maxY-=2*padding);var viewport=page.getViewport({scale:1});var zoomX=Math.floor(100/viewport.width*(maxX||Number.MAX_SAFE_INTEGER));var zoomY=Math.floor(100/viewport.height*(maxY||
Number.MAX_SAFE_INTEGER));var zoom=Math.min($pdfviewer.PAGE_ZOOM_MAX,Math.max($pdfviewer.PAGE_ZOOM_MIN,Math.min(zoomX,zoomY)));$timeout(function(){$this.setZoom(zoom)})})};this.buildGroupTree=function(outline){var entries=[];var grouptree=[];outline=outline||[];var getNextNode=function(previousId){var entries=Object.values($pdfviewer.grouptree);for(var i=0;i<entries.length;i++){var previousElements=entries[i].previousId;if(previousId===previousElements)return entries[i]}return undefined};var addEntries=
function(node,parent,previousId,parentId){var guid=window.GUID.createNew();node.id=guid;node.previousId=previousId;node.parentId=parentId;grouptree[guid]=node;var current={id:guid,previousId:previousId,parentId:parentId,label:node.title,onEveryClick:function(dest){if(sidenavigation.selected===dest.id){$pdfviewer.viewer.find(".textLayer div.highlight").remove();$pdfviewer.model.currentHighlights=undefined;sidenavigation.selected=undefined;return}sidenavigation.selected=dest.id;var entry=$pdfviewer.grouptree[dest.id];
var bottom=entry.dest[3];$pdfviewer.model.pdf.getPageIndex(entry.dest[0]).then(function(pageIndex){$this.updateScrollPosition(pageIndex+1,bottom);$pdfviewer.viewer.find(".textLayer div.highlight").remove();var nextNode=getNextNode(dest.id);if(nextNode===undefined&&dest.parentId!==undefined)nextNode=getNextNode(dest.parentId);if(!nextNode){$this.highlightSection(pageIndex+1,bottom,0);return}$pdfviewer.model.pdf.getPageIndex(nextNode.dest[0]).then(function(destinationPage){for(var currentPage=pageIndex;currentPage<=
destinationPage;currentPage++){var highlightTop=currentPage==pageIndex?bottom:-1;var highlightBottom=currentPage==destinationPage?nextNode.dest[3]:0;$this.highlightSection(currentPage+1,highlightTop,highlightBottom)}})})},children:[]};parent.push(current);var sectionId=previousId;for(var i=0;i<node.items.length;i++)sectionId=addEntries(node.items[i],current.children,sectionId,guid);return guid};var sectionId=undefined;for(var i=0;i<outline.length;i++)sectionId=addEntries(outline[i],entries,sectionId);
$pdfviewer.grouptree=grouptree;!(window.pdfviewer.PROPS.pdfviewer||{}).isEmbedded&&sidenavigation.setEntries(entries)};var threshholds=function(start,end,step){var array=[];for(var i=start;i<=end;i+=step)array.push(i);return array}(0,1,.01);var pageScrollObserver;var pageScrollObserverMap=[];this.getPageScrollObserver=function(){if(pageScrollObserver===undefined)pageScrollObserver=new IntersectionObserver(function(pdfviewer){var i;for(i=0;i<pdfviewer.length;i++){var entry=pdfviewer[i];var $canvas=
$(entry.target);var page=parseInt($canvas.data("page-number"));pageScrollObserverMap[page]=entry.isIntersecting?Math.ceil(entry.intersectionRatio*100):0}var currentPageNumber=1;var maxRatio=0;for(i=1;i<=pageScrollObserverMap.length;i++){var ratio=pageScrollObserverMap[i];if(ratio===undefined)continue;if(maxRatio<ratio){maxRatio=ratio;currentPageNumber=i}else if(maxRatio>0)break}$timeout(function(){$pdfviewer.model.currentPage=currentPageNumber})},{threshold:threshholds,root:$pdfviewer.scrollPane[0],
rootMargin:"0px"});return pageScrollObserver};this.promptParameters=function(){var parameters=$location.search(),parameterKeys=Object.keys(parameters||{}),PROMPT=[];for(var i=0;i<parameterKeys.length;i++){var key=parameterKeys[i];if(key.toLowerCase().indexOf("prompt")<0)continue;PROMPT.push({name:key,value:parameters[key]})}return PROMPT};var forbiddenKeys=["init","export_fmt","cmd"];this.reportProperties=function(properties){var PROPS=[];properties=properties||$window.pdfviewer.PROPS;var propertyKeys=
Object.keys(properties||{});for(var i=0;i<propertyKeys.length;i++){var key=propertyKeys[i];if(forbiddenKeys.indexOf(key)>=0)continue;PROPS.push({name:key,value:properties[key]})}return PROPS};this.alreadyEncoded=function(input){if(input!=null&&input.indexOf&&input.indexOf("%")==-1)return false;try{if(decodeURIComponent(input)==input)return false}catch(e){return false}return true};this.ensureParameterPromptKey=function(name){return name.indexOf("#")>=0?encodeURIComponent(name):name};this.decodedPromptParameters=
function(){let PROMPT=$window.pdfviewer.PROMPT;let array=[];for(let i=0;i<PROMPT.length;i++){let entry=PROMPT[i];if(entry===null)continue;let key=entry.name,param=entry.value;key=this.alreadyEncoded(key)?decodeURIComponent(key):key;param=this.alreadyEncoded(param)?decodeURIComponent(param):param;array.push({name:key,value:param})}return array};this.getBaseURLParametersOnly=function(defaultProperties){return[].concat($this.reportProperties(defaultProperties),$this.promptParameters(),$this.decodedPromptParameters())};
this.getBaseURLParameters=function(defaultProperties){var baseURL="";var prompt=this.getBaseURLParametersOnly(defaultProperties);for(var i=0;i<prompt.length;i++)baseURL+=(i==0?"":"\x26")+encodeURIComponent(prompt[i].name)+"\x3d"+encodeURIComponent(prompt[i].value);return baseURL};this.getBaseURL=function(defaultProperties,basePath){var baseURL=$("base").attr("roothref");baseURL+=(basePath||"report")+"/?";baseURL+=$this.getBaseURLParameters(defaultProperties);return baseURL};return this}])})();