/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.server.persistence.impl.file;

import com.inet.cache.CacheTimeoutListener;
import com.inet.cache.MemoryStoreMap;
import com.inet.cache.internal.AbstractMap;
import com.inet.id.GUID;
import com.inet.pdfc.PDFCCore;
import com.inet.pdfc.config.IProfile;
import com.inet.pdfc.config.PdfSource;
import com.inet.pdfc.generator.message.ErrorData;
import com.inet.pdfc.generator.message.InfoData;
import com.inet.pdfc.generator.message.PageDataImpl;
import com.inet.pdfc.generator.message.PartialDiffs;
import com.inet.pdfc.generator.message.ProgressState;
import com.inet.pdfc.generator.message.State;
import com.inet.pdfc.i18n.Msg;
import com.inet.pdfc.plugin.persistence.ComparePersistence;
import com.inet.pdfc.plugin.persistence.CompareState;
import com.inet.pdfc.plugin.persistence.PersistenceFactory;
import com.inet.pdfc.plugin.persistence.PersistenceObserver;
import com.inet.pdfc.plugin.persistence.QuotaExceededException;
import com.inet.pdfc.plugin.persistence.UserContingent;
import com.inet.pdfc.plugin.persistence.UserPersistenceManager;
import com.inet.pdfc.plugin.persistence.UserSession;
import com.inet.pdfc.plugin.persistence.UserState;
import com.inet.pdfc.results.ResultModel;
import com.inet.pdfc.results.ResultModelData;
import com.inet.pdfc.results.ResultPage;
import com.inet.pdfc.server.PDFCServerPlugin;
import com.inet.pdfc.server.persistence.ContingentManager;
import com.inet.pdfc.server.persistence.impl.file.CoreComparePersistence;
import com.inet.pdfc.server.persistence.impl.file.PersistenceCloudEvent;
import com.inet.permissions.AccessDeniedException;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.persistence.MaintenanceMode;
import com.inet.persistence.Persistence;
import com.inet.persistence.PersistenceEntry;
import com.inet.persistence.PersistenceListener;
import com.inet.persistence.spi.PersistenceLogger;
import com.inet.plugin.ServerPluginManager;
import com.inet.search.index.IndexSearchEngine;
import com.inet.thread.BaseRunnableSession;
import com.inet.thread.RunnableSession;
import com.inet.thread.SessionLocator;
import com.inet.usersandgroups.api.user.UserAccountScope;
import com.inet.usersandgroups.api.user.UserManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

public class b
implements PersistenceFactory,
PersistenceListener<PersistenceCloudEvent> {
    private com.inet.pdfc.server.persistence.b bO;
    private final Set<GUID> bP = new HashSet<GUID>();
    private Object bQ = new Object();
    private MemoryStoreMap<GUID, CoreComparePersistence> bR = new MemoryStoreMap((Integer)PDFCServerPlugin.USER_DISCONNECT_TIME_VALUE.get() * 60, true);
    private ContingentManager bq;
    private Thread bS;
    private ThreadLocal<Boolean> bu = new ThreadLocal();
    private List<PersistenceFactory.GlobalPersistenceObsever> bT = new ArrayList<PersistenceFactory.GlobalPersistenceObsever>();

    public b(com.inet.pdfc.server.persistence.b b2) {
        this.bO = b2;
        this.bR.setTimeoutCheck(externalDataMapEntry -> {
            CoreComparePersistence coreComparePersistence = (CoreComparePersistence)externalDataMapEntry.getValue();
            if (coreComparePersistence == null) {
                return true;
            }
            switch (coreComparePersistence.getCompareState().getState()) {
                case CANCELING: 
                case COMPARING: 
                case PAUSED: 
                case QUEUED: 
                case START: 
                case UPDATE_DOCUMENT: {
                    return false;
                }
            }
            for (PersistenceObserver object : coreComparePersistence.getObservers()) {
                if (object.canTimeout()) continue;
                return false;
            }
            if (!((Boolean)PDFCServerPlugin.COMPARISON_DELETE_VALUE.get()).booleanValue() || !com.inet.pdfc.server.persistence.impl.b.a(null, coreComparePersistence)) {
                List<UserSession> list = coreComparePersistence.getViewers();
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    UserSession userSession = (UserSession)iterator.next();
                    if (userSession.getLastAccess() <= System.currentTimeMillis() - b.ar()) continue;
                    return false;
                }
            }
            return true;
        });
        this.bR.addTimeoutListener((CacheTimeoutListener)new CacheTimeoutListener<GUID, CoreComparePersistence>(){

            public void a(GUID gUID, CoreComparePersistence coreComparePersistence) {
                block10: {
                    if (coreComparePersistence == null) {
                        return;
                    }
                    try {
                        if (((Boolean)PDFCServerPlugin.COMPARISON_DELETE_VALUE.get()).booleanValue() && com.inet.pdfc.server.persistence.impl.b.a(null, coreComparePersistence)) {
                            try (UserAccountScope userAccountScope = UserAccountScope.createPrivileged();){
                                b.this.remove(coreComparePersistence.getGUID(), false);
                                break block10;
                            }
                        }
                        new Thread(() -> {
                            try {
                                coreComparePersistence.clearForFinalize(true);
                            }
                            catch (IOException iOException) {
                                PDFCCore.LOGGER_CORE.error((Throwable)iOException);
                            }
                            b.this.bq.notifyComparisonTimeout(coreComparePersistence);
                        }, "CleanUp for comparison " + String.valueOf(gUID)).start();
                    }
                    catch (Exception exception) {
                        PDFCCore.LOGGER_CORE.error((Throwable)exception);
                    }
                }
            }

            public /* synthetic */ void timeout(Object object, Object object2) {
                this.a((GUID)object, (CoreComparePersistence)object2);
            }
        });
        c c2 = new c(this.bQ, (AbstractMap<GUID, CoreComparePersistence>)this.bR, this.bP);
        this.bS = new Thread(c2);
        this.bS.setName("Contingent Monitor");
        this.bS.setDaemon(true);
        this.bS.setPriority(1);
        this.bS.start();
    }

    public void a(int n) {
        this.bR.setTimeout(n * 60, true);
    }

    public static long ar() {
        return ((Integer)PDFCServerPlugin.USER_DISCONNECT_TIME_VALUE.get()).longValue() * 60L * 1000L;
    }

    ContingentManager T() {
        if (this.bq == null) {
            this.bq = (ContingentManager)ServerPluginManager.getInstance().getSingleInstance(ContingentManager.class);
        }
        return this.bq;
    }

    public CoreComparePersistence u(GUID gUID) throws AccessDeniedException, IOException {
        if (gUID == null) {
            return null;
        }
        CoreComparePersistence coreComparePersistence = this.b(gUID, true);
        if (coreComparePersistence == null) {
            return null;
        }
        coreComparePersistence.ad();
        return coreComparePersistence;
    }

    public CoreComparePersistence v(GUID gUID) throws IOException {
        return this.b(gUID, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoreComparePersistence b(GUID gUID, boolean bl) throws IOException {
        if (MaintenanceMode.getState() == MaintenanceMode.IN_PROGRESS) {
            return null;
        }
        boolean bl2 = false;
        CoreComparePersistence coreComparePersistence = null;
        Object object = this.bQ;
        synchronized (object) {
            CoreComparePersistence coreComparePersistence2 = bl ? (CoreComparePersistence)this.bR.get((Object)gUID) : (CoreComparePersistence)this.bR.getIfInMemeory((Object)gUID);
            if (coreComparePersistence2 != null) {
                return coreComparePersistence2;
            }
            PersistenceEntry persistenceEntry = this.bO.a(gUID);
            if (!persistenceEntry.exists()) {
                return null;
            }
            try {
                coreComparePersistence = new CoreComparePersistence(persistenceEntry, gUID, null);
            }
            catch (IllegalArgumentException | IllegalStateException runtimeException) {
                return null;
            }
            if (bl) {
                this.bR.put((Object)gUID, (Object)coreComparePersistence);
                bl2 = true;
            }
        }
        if (bl2) {
            this.T().monitorComparison(coreComparePersistence);
        }
        coreComparePersistence.a(new b(coreComparePersistence, this.bu));
        return coreComparePersistence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CoreComparePersistence w(GUID gUID) {
        Object object = this.bQ;
        synchronized (object) {
            return (CoreComparePersistence)this.bR.getIfInMemeory((Object)gUID);
        }
    }

    public void forEachGUID(Consumer<GUID> action) throws IOException {
        this.bO.a((String string) -> action.accept(GUID.valueOf((String)string)));
    }

    public boolean hasComparison(GUID compareID) {
        if (compareID == null) {
            return false;
        }
        return this.bO.a(compareID).exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GUID getOwner(GUID compareID) {
        CoreComparePersistence coreComparePersistence;
        if (compareID == null) {
            return null;
        }
        Object object = this.bQ;
        synchronized (object) {
            coreComparePersistence = (CoreComparePersistence)this.bR.get((Object)compareID);
        }
        if (coreComparePersistence != null) {
            return coreComparePersistence.getOwnerID();
        }
        object = this.bO.a(compareID);
        if (!object.exists()) {
            return null;
        }
        try {
            return GUID.valueOf((String)com.inet.pdfc.server.persistence.impl.file.c.c((PersistenceEntry)object));
        }
        catch (Exception exception) {
            PDFCCore.LOGGER_CORE.error((Throwable)exception);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(GUID compareID, boolean waitForCompletion) throws AccessDeniedException, IOException {
        Object object = this.bP;
        synchronized (object) {
            if (this.bP.contains(compareID)) {
                return;
            }
        }
        if (MaintenanceMode.getState() == MaintenanceMode.IN_PROGRESS) {
            throw new IllegalStateException("The server is currently in maintenance mode. Data manipulation is deactivated.");
        }
        if (!SystemPermissionChecker.checkAccess((Permission)PDFCServerPlugin.PERMISSION_OWN_COMPARISONS)) {
            throw new AccessDeniedException(PDFCServerPlugin.PERMISSION_OWN_COMPARISONS);
        }
        try {
            object = this.u(compareID);
            if (object != null) {
                ((CoreComparePersistence)object).al();
                if (((CoreComparePersistence)object).getPublicationMode() != ComparePersistence.PUBLICATION_MODE.none) {
                    ((CoreComparePersistence)object).unpublish();
                }
                ((CoreComparePersistence)object).ao();
            }
        }
        catch (Throwable throwable) {
            if (throwable instanceof AccessDeniedException) {
                throw throwable;
            }
            PDFCCore.LOGGER_CORE.debug((Object)throwable);
        }
        object = (CoreComparePersistence)this.bR.get((Object)compareID);
        State state = this.bP;
        synchronized (state) {
            this.bP.add(compareID);
        }
        try {
            if (object != null) {
                state = ((CoreComparePersistence)object).getCompareState().getState();
                switch (state) {
                    case CANCELING: 
                    case COMPARING: 
                    case PAUSED: 
                    case QUEUED: 
                    case START: 
                    case CLOUDCOMPARE: {
                        ((CoreComparePersistence)object).cancel(new a(), waitForCompletion);
                        return;
                    }
                }
            }
            this.x(compareID);
        }
        catch (Throwable throwable) {
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            PDFCCore.LOGGER_CORE.error(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void x(GUID gUID) throws IOException {
        Object object;
        Object object2 = this.bP;
        synchronized (object2) {
            if (!this.bP.contains(gUID)) {
                throw new IllegalStateException("Synchronization error while removing comparison " + String.valueOf(gUID));
            }
        }
        try {
            object2 = this.bO.a(gUID);
            CoreComparePersistence coreComparePersistence = (CoreComparePersistence)this.bR.get((Object)gUID);
            if (!object2.exists()) {
                if (coreComparePersistence != null) {
                    object = coreComparePersistence.getOwnerID();
                    this.bq.notifyChangeInBackground(new PersistenceCloudEvent(gUID, (GUID)object, PersistenceObserver.EventType.REMOVED, null), false);
                }
                return;
            }
            if (coreComparePersistence != null) {
                coreComparePersistence.cancel(null, false);
                coreComparePersistence.clearForFinalize(false);
            } else {
                try {
                    String string = com.inet.pdfc.server.persistence.impl.file.c.c(object2);
                    if (string == null) {
                        throw new IllegalStateException("OwnerID is not stored for comparison " + String.valueOf(gUID));
                    }
                    GUID gUID2 = GUID.valueOf((String)string);
                    this.bq.notifyChangeInBackground(new PersistenceCloudEvent(gUID, gUID2, PersistenceObserver.EventType.REMOVED, null), false);
                }
                catch (Exception exception) {
                    PDFCCore.LOGGER_CORE.error((Object)("Unable to determine the owner of comparison " + String.valueOf(gUID) + " during the remove operation. The comparison will be removed anyways but this error may cause an incorrect quota for the original owner."));
                }
            }
            try {
                if (coreComparePersistence != null) {
                    coreComparePersistence.ab().a(() -> this.bO.c(gUID));
                } else {
                    this.bO.c(gUID);
                }
            }
            catch (Exception exception) {
                PDFCCore.LOGGER_CORE.error((Object)("Could not delete folder of session '" + String.valueOf(gUID) + "'. Please close all files in the session first."));
                PDFCCore.LOGGER_CORE.debug((Object)exception);
                throw exception;
            }
        }
        finally {
            this.bR.remove((Object)gUID);
            object = this.bP;
            synchronized (object) {
                this.bP.remove(gUID);
            }
            com.inet.pdfc.server.a.b.a(gUID, new Object[0]);
        }
    }

    public CoreComparePersistence a(GUID gUID, UserSession userSession, String string) throws AccessDeniedException, IllegalArgumentException, IOException, QuotaExceededException {
        return this.a(gUID, userSession, string, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CoreComparePersistence a(GUID gUID, UserSession userSession, String string, boolean bl) throws IllegalArgumentException, IOException, QuotaExceededException {
        CoreComparePersistence coreComparePersistence;
        if (MaintenanceMode.getState() == MaintenanceMode.IN_PROGRESS) {
            throw new IllegalStateException("The server is currently in maintenance mode. Data manipulation is deactivated.");
        }
        if (!SystemPermissionChecker.checkAccess((Permission)PDFCServerPlugin.PERMISSION_OWN_COMPARISONS)) {
            throw new AccessDeniedException(PDFCServerPlugin.PERMISSION_OWN_COMPARISONS);
        }
        PersistenceEntry persistenceEntry = this.bO.a(gUID);
        if (persistenceEntry.exists()) {
            throw new IllegalArgumentException("There already is a session with GUID '" + String.valueOf(gUID) + "'");
        }
        GUID gUID2 = userSession.getUserID();
        if (bl) {
            this.T().cleanUpContingent(gUID2, string);
        }
        UserContingent userContingent = this.T().getUserContingent(gUID2);
        if (!this.T().hasFreeHDDSpace(gUID2)) {
            long l = (userContingent.getUsedHardDiskSpace() - this.T().getQuotaValue(ContingentManager.QUOTA_TYPE.hdd, gUID2)) / 0x100000L;
            throw new QuotaExceededException(Msg.getMsg((String)"Server.quotaexceeded.hdd", (Object[])new Object[]{UserManager.getRecoveryEnabledInstance().getUserAccount(gUID2).getDisplayName(), l}));
        }
        if (!this.T().isAllowedComparing(gUID2)) {
            Long l = this.T().getQuotaValue(ContingentManager.QUOTA_TYPE.comparisons, gUID2);
            throw new QuotaExceededException(Msg.getMsg((String)"Server.quotaexceeded.comparison", (Object[])new Object[]{UserManager.getRecoveryEnabledInstance().getUserAccount(gUID2).getDisplayName(), l}));
        }
        Object object = this.bQ;
        synchronized (object) {
            coreComparePersistence = new CoreComparePersistence(persistenceEntry, gUID, gUID2);
            if (string != null) {
                coreComparePersistence.setMetaProperty("creator", string);
            }
            coreComparePersistence.notifyUserAccess(userSession, UserState.ACTIVE);
            this.bR.put((Object)gUID, (Object)coreComparePersistence);
        }
        this.T().monitorComparison(coreComparePersistence);
        coreComparePersistence.a(new b(coreComparePersistence, this.bu));
        coreComparePersistence.a(PersistenceObserver.EventType.CREATED, coreComparePersistence.getOwnerID());
        com.inet.pdfc.server.a.a.a(gUID, new Object[0]);
        return coreComparePersistence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAllSessions() {
        Object object = this.bQ;
        synchronized (object) {
            for (Map.Entry entry : this.bR.entrySet()) {
                CoreComparePersistence coreComparePersistence = (CoreComparePersistence)entry.getValue();
                coreComparePersistence.cancel(null, true);
                try {
                    coreComparePersistence.finalize();
                }
                catch (Throwable throwable) {
                    PDFCCore.LOGGER_CORE.error(throwable);
                }
            }
        }
    }

    public String getExtensionName() {
        return "filepersistence";
    }

    protected void finalize() throws Throwable {
        this.bS.interrupt();
        this.bS = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void a(PersistenceCloudEvent persistenceCloudEvent) {
        Object object;
        CoreComparePersistence coreComparePersistence = null;
        PersistenceObserver.EventType<?> eventType = this.bQ;
        // MONITORENTER : eventType
        coreComparePersistence = (CoreComparePersistence)this.bR.get((Object)persistenceCloudEvent.getPersistenceID());
        // MONITOREXIT : eventType
        eventType = persistenceCloudEvent.getEventType();
        if (PersistenceLogger.LOGGER.isInfo()) {
            object = eventType.fromJSON(persistenceCloudEvent.getJsonEventData());
            PersistenceLogger.LOGGER.info((Object)("[PDFC] Event Received (GUID=" + String.valueOf(persistenceCloudEvent.getPersistenceID()) + ";type=" + (eventType != null ? eventType.getJSONKey() : "<empty>") + (String)(object != null ? "=" + object.toString() : "") + ";session=" + (coreComparePersistence != null ? "ACTIVE" : "INACTIVE") + ")"));
        }
        if (coreComparePersistence == null) {
            this.T().notifyChangeInBackground(persistenceCloudEvent, true);
            object = this.bQ;
            // MONITORENTER : object
            coreComparePersistence = (CoreComparePersistence)this.bR.get((Object)persistenceCloudEvent.getPersistenceID());
            // MONITOREXIT : object
            if (coreComparePersistence == null) {
                return;
            }
        }
        if (eventType == null) {
            PDFCCore.LOGGER_CORE.error((Object)("Recieved unknown event type from cloud multicast: " + String.valueOf(persistenceCloudEvent)));
            return;
        }
        object = coreComparePersistence.getOwnerID();
        if (object == null) {
            throw new IllegalStateException("Comparison '" + String.valueOf(coreComparePersistence.getGUID()) + "' has no owner set.");
        }
        try (UserAccountScope userAccountScope = UserAccountScope.create((GUID)object);){
            this.bu.set(Boolean.TRUE);
            if (!object.equals((Object)UserManager.getRecoveryEnabledInstance().getCurrentUserAccountID())) {
                throw new IllegalStateException("Cannot switch to unknown user '" + String.valueOf(object) + "'");
            }
            Object object2 = eventType.fromJSON(persistenceCloudEvent.getJsonEventData());
            if (eventType == PersistenceObserver.EventType.ERROR) {
                coreComparePersistence.ah();
                CompareState compareState = coreComparePersistence.getCompareState();
                object2 = new ErrorData(compareState.getError(), 3, true);
                coreComparePersistence.a(eventType, object2, true);
                return;
            }
            if (eventType == PersistenceObserver.EventType.COMPARISON_RESET) {
                coreComparePersistence.a(PersistenceObserver.EventType.PROGRESS, new ProgressState(State.START, 0.0f, -1L), true);
                return;
            }
            if (eventType == PersistenceObserver.EventType.TOTAL_SIZE_CHANGED) {
                this.T().notifyChangeInBackground(persistenceCloudEvent, true);
                coreComparePersistence.a(eventType, object2, true);
                this.a(persistenceCloudEvent.getPersistenceID(), persistenceCloudEvent.getEventType(), object2, true);
                return;
            }
            if (eventType == PersistenceObserver.EventType.COMPARISON_INFO) {
                try {
                    PdfSource pdfSource = coreComparePersistence.getDocument(true);
                    PdfSource pdfSource2 = coreComparePersistence.getDocument(false);
                    coreComparePersistence.a(PersistenceObserver.EventType.COMPARISON_INFO, new InfoData(pdfSource, pdfSource2, -1, -1, (IProfile)coreComparePersistence.getProfile()), true);
                    return;
                }
                catch (IOException iOException) {
                    PDFCCore.LOGGER_CORE.error((Throwable)iOException);
                    return;
                }
            }
            if (eventType == PersistenceObserver.EventType.CREATED) {
                coreComparePersistence.a(eventType, object2, true);
                return;
            }
            if (eventType == PersistenceObserver.EventType.DOCUMENT_CHANGED) {
                coreComparePersistence.a(eventType, object2, true);
                coreComparePersistence.a(PersistenceObserver.EventType.PROGRESS, new ProgressState(State.IDLE, 0.0f), true);
                return;
            }
            if (eventType == PersistenceObserver.EventType.COMPARISON_SERIALIZED) {
                try {
                    boolean bl = coreComparePersistence.Y();
                    coreComparePersistence.ah();
                    try (UserAccountScope userAccountScope2 = UserAccountScope.create((GUID)object);){
                        coreComparePersistence.an();
                    }
                    if (!object.equals((Object)UserManager.getRecoveryEnabledInstance().getCurrentUserAccountID())) {
                        throw new IllegalStateException("Cannot switch to unknown user '" + String.valueOf(object) + "'");
                    }
                    if (!bl) {
                        userAccountScope2 = coreComparePersistence.getCompareState();
                        coreComparePersistence.a(PersistenceObserver.EventType.PROGRESS, new ProgressState(userAccountScope2.getState(), userAccountScope2.getProgress()), true);
                        return;
                    }
                    ResultModel resultModel = coreComparePersistence.getResult();
                    if (resultModel == null) return;
                    coreComparePersistence.a(PersistenceObserver.EventType.PROGRESS, new ProgressState(State.COMPARING, 5.0f), true);
                    coreComparePersistence.a(PersistenceObserver.EventType.COMPARISON_INFO, resultModel.getComparisonParameters(), true);
                    int n = resultModel.getPageCount(true);
                    int n2 = resultModel.getPageCount(false);
                    int n3 = 0;
                    while (true) {
                        ResultPage resultPage;
                        if (n3 >= Math.max(n, n2)) {
                            PartialDiffs partialDiffs = new PartialDiffs(ResultModelData.getDifferences((boolean)true, (boolean)true, (ResultModel)resultModel), true);
                            coreComparePersistence.a(PersistenceObserver.EventType.PARTIAL_DIFFS, partialDiffs, true);
                            resultPage = coreComparePersistence.getCompareState();
                            coreComparePersistence.a(PersistenceObserver.EventType.PROGRESS, new ProgressState(resultPage.getState(), resultPage.getProgress()), true);
                            return;
                        }
                        if (n3 < n) {
                            resultPage = resultModel.getPage(n3, true);
                            coreComparePersistence.a(PersistenceObserver.EventType.PAGE_PARSED, new PageDataImpl(n3, true, (float)resultPage.getWidth(), (float)resultPage.getHeight()), true);
                        }
                        if (n3 < n2) {
                            resultPage = resultModel.getPage(n3, false);
                            coreComparePersistence.a(PersistenceObserver.EventType.PAGE_PARSED, new PageDataImpl(n3, false, (float)resultPage.getWidth(), (float)resultPage.getHeight()), true);
                        }
                        ++n3;
                    }
                }
                catch (IOException iOException) {
                    PDFCCore.LOGGER_CORE.error((Throwable)iOException);
                    return;
                }
            }
            coreComparePersistence.a(eventType, object2, true);
            if (eventType != PersistenceObserver.EventType.REMOVED) return;
            GUID gUID = persistenceCloudEvent.getPersistenceID();
            Set<GUID> set = this.bQ;
            // MONITORENTER : set
            this.bR.remove((Object)gUID);
            // MONITOREXIT : set
            set = this.bP;
            // MONITORENTER : set
            this.bP.remove(gUID);
            // MONITOREXIT : set
            return;
        }
        finally {
            this.bu.set(Boolean.FALSE);
        }
    }

    public IndexSearchEngine<GUID> getSearchIndex() {
        return ((com.inet.pdfc.server.persistence.impl.b)ServerPluginManager.getInstance().getSingleInstance(UserPersistenceManager.class)).p();
    }

    public void addGlobalObserver(PersistenceFactory.GlobalPersistenceObsever observer) {
        if (this.bT.contains(observer)) {
            return;
        }
        ArrayList<PersistenceFactory.GlobalPersistenceObsever> arrayList = new ArrayList<PersistenceFactory.GlobalPersistenceObsever>(this.bT);
        arrayList.add(observer);
        this.bT = arrayList;
    }

    public void removeGlobalObserver(PersistenceFactory.GlobalPersistenceObsever observer) {
        ArrayList<PersistenceFactory.GlobalPersistenceObsever> arrayList = new ArrayList<PersistenceFactory.GlobalPersistenceObsever>(this.bT);
        arrayList.remove(observer);
        this.bT = arrayList;
    }

    public <T> void a(GUID gUID, PersistenceObserver.EventType<T> eventType, T t, boolean bl) {
        if (this.bT.isEmpty()) {
            return;
        }
        for (PersistenceFactory.GlobalPersistenceObsever globalPersistenceObsever : this.bT) {
            globalPersistenceObsever.changed(gUID, eventType, t, bl);
        }
    }

    public /* synthetic */ ComparePersistence createPersistence(GUID gUID, UserSession userSession, String string, boolean bl) throws AccessDeniedException, IllegalArgumentException, IOException, QuotaExceededException {
        return this.a(gUID, userSession, string, bl);
    }

    public /* synthetic */ ComparePersistence createPersistence(GUID gUID, UserSession userSession, String string) throws AccessDeniedException, IllegalArgumentException, IOException, QuotaExceededException {
        return this.a(gUID, userSession, string);
    }

    public /* synthetic */ ComparePersistence getPersistenceSystemAccess(GUID gUID) throws IOException {
        return this.v(gUID);
    }

    public /* synthetic */ ComparePersistence getPersistence(GUID gUID) throws AccessDeniedException, IOException {
        return this.u(gUID);
    }

    public /* synthetic */ void eventReceived(Object object) {
        this.a((PersistenceCloudEvent)object);
    }

    private static class c
    implements Runnable {
        private Object bQ;
        private AbstractMap<GUID, CoreComparePersistence> bW;
        private Set<GUID> bP;

        public c(Object object, AbstractMap<GUID, CoreComparePersistence> abstractMap, Set<GUID> set) {
            this.bQ = object;
            this.bW = abstractMap;
            this.bP = set;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            RunnableSession runnableSession = SessionLocator.exists() ? SessionLocator.getCurrent() : new BaseRunnableSession();
            while (true) {
                ArrayList arrayList;
                Iterator iterator = this.bQ;
                synchronized (iterator) {
                    arrayList = new ArrayList(this.bW.keySet());
                }
                runnableSession.resetThreadLocal();
                for (GUID gUID : arrayList) {
                    Object object = this.bP;
                    synchronized (object) {
                        if (this.bP.contains(gUID)) {
                            continue;
                        }
                    }
                    Object object2 = this.bQ;
                    synchronized (object2) {
                        object = (CoreComparePersistence)this.bW.getIfInMemeory((Object)gUID);
                    }
                    if (object == null) continue;
                    ((CoreComparePersistence)object).ag();
                }
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }
        }
    }

    private static class b
    implements PersistenceObserver {
        private CoreComparePersistence bV;
        private ThreadLocal<Boolean> bu;

        public b(CoreComparePersistence coreComparePersistence, ThreadLocal<Boolean> threadLocal) {
            this.bV = coreComparePersistence;
            this.bu = threadLocal;
        }

        public boolean isValid() {
            return true;
        }

        public <T> void changed(PersistenceObserver.EventType<T> type, T eventData, boolean isPassive) {
            if (isPassive || this.bu.get() == Boolean.TRUE) {
                return;
            }
            if (type.isRuntimeEvent()) {
                return;
            }
            if (type == PersistenceObserver.EventType.SETTINGS_CHANGED) {
                switch (this.bV.getCompareState().getState()) {
                    case CANCELING: 
                    case PAUSED: 
                    case QUEUED: 
                    case START: {
                        return;
                    }
                }
            }
            if (type == PersistenceObserver.EventType.META_CHANGED) {
                eventData = new HashMap();
            }
            Persistence.getInstance().sendEvent((Object)new PersistenceCloudEvent(this.bV.getGUID(), this.bV.getOwnerID(), type, eventData));
        }
    }

    private class a
    implements Consumer<GUID> {
        public void z(GUID gUID) {
            try {
                b.this.x(gUID);
            }
            catch (IOException iOException) {
                PDFCCore.LOGGER_CORE.error((Throwable)iOException);
            }
        }

        @Override
        public /* synthetic */ void accept(Object object) {
            this.z((GUID)object);
        }
    }
}

