/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.server.persistence.impl.file;

import com.inet.annotations.JsonData;
import com.inet.cache.InetSerializer;
import com.inet.lib.json.Bon;
import com.inet.lib.json.Json;
import com.inet.lib.json.JsonException;
import com.inet.lib.json.JsonTypeResolver;
import com.inet.pdfc.PDFCCore;
import com.inet.pdfc.results.CollapsePagesModelData;
import com.inet.pdfc.results.FieldTypeResolver;
import com.inet.pdfc.results.ResultModel;
import com.inet.pdfc.results.ResultModelData;
import com.inet.pdfc.results.ResultModelUpdater;
import com.inet.pdfc.server.persistence.impl.file.ResultModelContainer;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;

@JsonData
public class ResultModelSerializer
implements InetSerializer<ResultModelContainer, ResultModelSerializer> {
    public void write(OutputStream out, ResultModelContainer serializableInstance) throws IOException {
        ResultModelData resultModelData = new ResultModelUpdater(serializableInstance.model).getModelData();
        if (resultModelData instanceof CollapsePagesModelData) {
            resultModelData = ((CollapsePagesModelData)resultModelData).getOriginalData();
        }
        new Bon().toBinary((Object)resultModelData, out);
    }

    public ResultModelContainer read(InputStream in) throws IOException {
        Object object;
        Object object2;
        ResultModelData resultModelData;
        HashMap hashMap = new HashMap();
        try {
            resultModelData = (ResultModelData)new Bon().fromBinary(in, ResultModelData.class, hashMap, (JsonTypeResolver)new FieldTypeResolver());
        }
        catch (JsonException jsonException) {
            try {
                in.reset();
                resultModelData = (ResultModelData)new Json().fromJson((Reader)new InputStreamReader(in, StandardCharsets.UTF_8), ResultModelData.class, (JsonTypeResolver)new FieldTypeResolver());
            }
            catch (Throwable throwable) {
                throw jsonException;
            }
        }
        hashMap.remove(resultModelData.getInfo().getFirstFile());
        hashMap.remove(resultModelData.getInfo().getSecondFile());
        if (hashMap.size() > 0) {
            try {
                object2 = resultModelData.getInfo().getFirstFile().getName();
                object = resultModelData.getInfo().getSecondFile().getName();
                PDFCCore.LOGGER_COMPARE.warn((Object)("Persisted data of comparison '" + (String)object2 + "' vs. '" + (String)object + "' seems to be generated by a more recent version. So the result may be incomplete."));
            }
            catch (Throwable throwable) {
                PDFCCore.LOGGER_COMPARE.debug((Object)throwable);
            }
        }
        object2 = new ResultModel(resultModelData);
        object = new ResultModelContainer((ResultModel)object2);
        return object;
    }
}

