/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.server.persistence.impl.file;

import com.inet.annotations.JsonData;
import com.inet.id.GUID;
import com.inet.pdfc.plugin.persistence.PersistenceObserver;

@JsonData
public class PersistenceCloudEvent {
    private GUID persistenceID;
    private String eventType;
    private String jsonEventData;
    private GUID owner;

    public <T> PersistenceCloudEvent(GUID persistenceID, GUID owner, PersistenceObserver.EventType<T> eventType, T eventData) {
        this.persistenceID = persistenceID;
        this.owner = owner;
        this.eventType = eventType.getJSONKey();
        this.jsonEventData = eventType.toJson(eventData);
    }

    private PersistenceCloudEvent() {
    }

    public GUID getPersistenceID() {
        return this.persistenceID;
    }

    public GUID getOwner() {
        return this.owner;
    }

    public PersistenceObserver.EventType<?> getEventType() {
        return PersistenceObserver.EventType.getTypeForKey((String)this.eventType);
    }

    public String getJsonEventData() {
        return this.jsonEventData;
    }

    public String toString() {
        return "Type:" + this.eventType + " for persistence " + String.valueOf(this.persistenceID);
    }
}

