/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.server.persistence.impl.file;

import com.inet.annotations.InternalApi;
import com.inet.pdfc.config.PdfSource;
import com.inet.pdfc.server.PDFCServerPlugin;
import com.inet.persistence.RandomAccessRead;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

@InternalApi
public class ExternalFilePdfSource
extends PdfSource {
    private transient File bX;

    public ExternalFilePdfSource(File pdfFile) {
        super(pdfFile.getName(), pdfFile.getAbsolutePath(), pdfFile.lastModified(), pdfFile.length());
        this.bX = pdfFile;
    }

    public ExternalFilePdfSource(File pdfFile, String explicitName) {
        this(pdfFile);
        this.getMetaProperties().put("NAME", explicitName);
    }

    public ExternalFilePdfSource(File pdfFile, String explicitName, boolean setNoMetaPath) {
        this(pdfFile, explicitName);
        if (setNoMetaPath) {
            this.getMetaProperties().remove("PATH");
        }
    }

    public long getLastModified() {
        return this.bX.lastModified();
    }

    public long getSize() {
        return this.bX.length();
    }

    public String getPath() {
        String string = super.getPath();
        if (string == null) {
            string = this.bX.getAbsolutePath();
        }
        return string;
    }

    public RandomAccessRead getContent() throws IOException {
        if (!this.bX.exists()) {
            throw new FileNotFoundException(PDFCServerPlugin.MSG_CLIENT.getMsg("pdfc.filenotfound", new Object[]{this.bX.getAbsolutePath()}));
        }
        return RandomAccessRead.wrap((File)this.bX);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.bX);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.bX = (File)stream.readObject();
    }
}

