/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.server.structure;

import com.inet.annotations.InternalApi;
import com.inet.config.ConfigKey;
import com.inet.config.Configuration;
import com.inet.config.structure.provider.ConfigStructureSettings;
import com.inet.lib.json.Json;
import com.inet.pdfc.config.CompareType;
import com.inet.pdfc.config.DefaultProfile;
import com.inet.pdfc.config.PDFCProperty;
import com.inet.pdfc.config.TextStyleType;
import com.inet.pdfc.plugin.persistence.ProfilePersistence;
import com.inet.pdfc.server.structure.FilterPatternEntry;
import com.inet.pdfc.server.structure.PDFCConfigKey;
import com.inet.pdfc.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

@InternalApi
public class PDFCConfigMapper {
    public static void saveInConfiguration(ConfigStructureSettings settings, ProfilePersistence profilePersistence, String key, String value) {
        DefaultProfile defaultProfile = profilePersistence.getProfile();
        if (PDFCConfigKey.COMPARE_MODE_STRICT.getKey().equals(key)) {
            if (Boolean.parseBoolean(value)) {
                defaultProfile.putValue(PDFCProperty.CONTINUOUS_COMPARE, "STRICT");
            } else {
                defaultProfile.putValue(PDFCProperty.CONTINUOUS_COMPARE, "CONTINUOUS");
            }
        } else if (PDFCConfigKey.HEADER_FOOTER_FILTER.getKey().equals(key)) {
            int n;
            int n2;
            if ("off".equalsIgnoreCase(value)) {
                PDFCConfigMapper.a(defaultProfile, PDFCProperty.FILTERS, "HEADERFOOTER", false);
            }
            if ("automatic".equalsIgnoreCase(value)) {
                PDFCConfigMapper.a(defaultProfile, PDFCProperty.FILTERS, "HEADERFOOTER", true);
                n2 = defaultProfile.getInt(PDFCProperty.FIXED_HEADER_SIZE);
                if (n2 >= 0) {
                    n2 = n2 * -1 - 1;
                    defaultProfile.putValue(PDFCProperty.FIXED_HEADER_SIZE, String.valueOf(n2));
                }
                if ((n = defaultProfile.getInt(PDFCProperty.FIXED_FOOTER_SIZE)) >= 0) {
                    n = n * -1 - 1;
                    defaultProfile.putValue(PDFCProperty.FIXED_FOOTER_SIZE, String.valueOf(n));
                }
            }
            if ("manual".equalsIgnoreCase(value)) {
                PDFCConfigMapper.a(defaultProfile, PDFCProperty.FILTERS, "HEADERFOOTER", true);
                n2 = defaultProfile.getInt(PDFCProperty.FIXED_HEADER_SIZE);
                if (n2 < 0) {
                    n2 = (n2 + 1) * -1;
                    defaultProfile.putValue(PDFCProperty.FIXED_HEADER_SIZE, String.valueOf(n2));
                }
                if ((n = defaultProfile.getInt(PDFCProperty.FIXED_FOOTER_SIZE)) < 0) {
                    n = (n + 1) * -1;
                    defaultProfile.putValue(PDFCProperty.FIXED_FOOTER_SIZE, String.valueOf(n));
                }
            }
        } else if (PDFCConfigKey.FIXED_HEADER_SIZE.getKey().equals(key)) {
            int n = Integer.parseInt(value);
            if ("automatic".equalsIgnoreCase(settings.getValue(PDFCConfigKey.HEADER_FOOTER_FILTER))) {
                n = n * -1 - 1;
            }
            defaultProfile.putValue(PDFCProperty.FIXED_HEADER_SIZE, String.valueOf(n));
        } else if (PDFCConfigKey.FIXED_FOOTER_SIZE.getKey().equals(key)) {
            int n = Integer.parseInt(value);
            if ("automatic".equalsIgnoreCase(settings.getValue(PDFCConfigKey.HEADER_FOOTER_FILTER))) {
                n = n * -1 - 1;
            }
            defaultProfile.putValue(PDFCProperty.FIXED_FOOTER_SIZE, String.valueOf(n));
        } else if (PDFCConfigKey.COMPARE_MERGE_DIFFS.getKey().equals(key)) {
            defaultProfile.putValue(PDFCProperty.DIFF_MERGE_FACTOR, value);
        } else if (PDFCConfigKey.UNICODENORMALIZE.getKey().equals(key)) {
            PDFCConfigMapper.a(defaultProfile, PDFCProperty.FILTERS, "UNICODENORMALIZE", Boolean.parseBoolean(value));
        } else if (PDFCConfigKey.MULTICOLUMN.getKey().equals(key)) {
            PDFCConfigMapper.a(defaultProfile, PDFCProperty.FILTERS, "MULTICOLUMN", Boolean.parseBoolean(value));
        } else if (PDFCConfigKey.INVISIBLE_ELEMENTS_FILTER.getKey().equals(key)) {
            PDFCConfigMapper.a(defaultProfile, PDFCProperty.FILTERS, "INVISIBLEELEMENTS", Boolean.parseBoolean(value));
        } else if (PDFCConfigKey.HIDE_ROTATION.getKey().equals(key)) {
            PDFCConfigMapper.a(defaultProfile, PDFCProperty.FILTERS, "HIDEROTATEDTEXT", Boolean.parseBoolean(value));
        } else if (PDFCConfigKey.REGEX_FILTER.getKey().equals(key)) {
            PDFCConfigMapper.a(defaultProfile, PDFCProperty.FILTERS, "REGEXP", Boolean.parseBoolean(value));
        } else if (PDFCConfigKey.FILTER_PATTERNS.getKey().equals(key)) {
            FilterPatternEntry[] filterPatternEntryArray = new FilterPatternEntry[]{};
            if (value != null && value.length() > 0) {
                filterPatternEntryArray = (FilterPatternEntry[])new Json().fromJson(value, FilterPatternEntry[].class);
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (FilterPatternEntry filterPatternEntry : filterPatternEntryArray) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append("\r\n");
                }
                stringBuilder.append(filterPatternEntry.getPattern().replace("\r", "").replace("\n", "[[BR]]"));
                stringBuilder.append('|');
                stringBuilder.append(filterPatternEntry.getType());
                stringBuilder.append('|');
                stringBuilder.append(filterPatternEntry.isActive() ? "active" : "inactive");
            }
            defaultProfile.putValue(PDFCProperty.FILTER_PATTERNS, stringBuilder.toString());
        } else if (PDFCConfigKey.TEXT.getKey().equals(key)) {
            PDFCConfigMapper.a(defaultProfile, PDFCProperty.COMPARE_TYPES, CompareType.TEXT.name(), Boolean.parseBoolean(value));
        } else if (PDFCConfigKey.COMPARE_TEXT_CASE_SENSITIVE.getKey().equals(key)) {
            defaultProfile.putValue(PDFCProperty.COMPARE_TEXT_CASE_SENSITIVE, String.valueOf(Boolean.parseBoolean(value)));
        } else if (PDFCConfigKey.COMPARE_TEXT_SIZE.getKey().equals(key)) {
            PDFCConfigMapper.a(defaultProfile, PDFCProperty.COMPARE_TEXT_STYLES, TextStyleType.SIZE.name(), Boolean.parseBoolean(value));
        } else if (PDFCConfigKey.COMPARE_TEXT_COLOR.getKey().equals(key)) {
            PDFCConfigMapper.a(defaultProfile, PDFCProperty.COMPARE_TEXT_STYLES, TextStyleType.COLOR.name(), Boolean.parseBoolean(value));
        } else if (PDFCConfigKey.COMPARE_TEXT_FAMILY.getKey().equals(key)) {
            PDFCConfigMapper.a(defaultProfile, PDFCProperty.COMPARE_TEXT_STYLES, TextStyleType.FONT.name(), Boolean.parseBoolean(value));
        } else if (PDFCConfigKey.COMPARE_TEXT_STYLE.getKey().equals(key)) {
            PDFCConfigMapper.a(defaultProfile, PDFCProperty.COMPARE_TEXT_STYLES, TextStyleType.STYLES.name(), Boolean.parseBoolean(value));
        } else if (PDFCConfigKey.COMPARE_TEXT_SPACING.getKey().equals(key)) {
            PDFCConfigMapper.a(defaultProfile, PDFCProperty.COMPARE_TEXT_STYLES, TextStyleType.SPACING.name(), Boolean.parseBoolean(value));
        } else if (PDFCConfigKey.TEXT_TOLERANCE.getKey().equals(key)) {
            int n = Integer.parseInt(value);
            double d2 = PDFCConfigMapper.a(PDFCProperty.TEXT_ALIGN_RATIO, n);
            int n3 = (int)PDFCConfigMapper.a(PDFCProperty.TOLERANCE_TEXT_LOCATION, n);
            defaultProfile.putValue(PDFCProperty.TEXT_ALIGN_RATIO, String.valueOf(d2));
            defaultProfile.putValue(PDFCProperty.TOLERANCE_TEXT_LOCATION, String.valueOf(n3));
        } else if (PDFCConfigKey.LINE.getKey().equals(key)) {
            PDFCConfigMapper.a(defaultProfile, PDFCProperty.COMPARE_TYPES, CompareType.LINE.name(), Boolean.parseBoolean(value));
        } else if (PDFCConfigKey.LINE_TOLERANCE.getKey().equals(key)) {
            int n = Integer.parseInt(value);
            int n4 = (int)PDFCConfigMapper.a(PDFCProperty.TOLERANCE_LINE_SIZE, n);
            int n5 = (int)PDFCConfigMapper.a(PDFCProperty.TOLERANCE_LINE_POSITION, n);
            int n6 = (int)PDFCConfigMapper.a(PDFCProperty.TOLERANCE_LINE_THICKNESS, n);
            defaultProfile.putValue(PDFCProperty.TOLERANCE_LINE_SIZE, String.valueOf(n4));
            defaultProfile.putValue(PDFCProperty.TOLERANCE_LINE_POSITION, String.valueOf(n5));
            defaultProfile.putValue(PDFCProperty.TOLERANCE_LINE_THICKNESS, String.valueOf(n6));
        } else if (PDFCConfigKey.IMAGE.getKey().equals(key)) {
            PDFCConfigMapper.a(defaultProfile, PDFCProperty.COMPARE_TYPES, CompareType.IMAGE.name(), Boolean.parseBoolean(value));
        } else if (PDFCConfigKey.IMAGEMETA.getKey().equals(key)) {
            defaultProfile.putValue(PDFCProperty.IMAGE_META_COMPARISON, String.valueOf(Boolean.parseBoolean(value)));
        } else if (PDFCConfigKey.IMAGEDETAILED.getKey().equals(key)) {
            defaultProfile.putValue(PDFCProperty.IMAGE_CHANGE_AREA, String.valueOf(Boolean.parseBoolean(value)));
        } else if (PDFCConfigKey.ANNOTATION.getKey().equals(key)) {
            PDFCConfigMapper.a(defaultProfile, PDFCProperty.COMPARE_TYPES, CompareType.ANNOTATION.name(), Boolean.parseBoolean(value));
        } else if (PDFCConfigKey.ANNOTATION_DETAILED.getKey().equals(key)) {
            defaultProfile.putValue(PDFCProperty.COMPARE_ANNOTATIONS_DETAILED, String.valueOf(Boolean.parseBoolean(value)));
        } else if (PDFCConfigKey.COMPARISON_TAGS.getKey().equals(key)) {
            defaultProfile.putValue(PDFCProperty.COMPARE_TAGS, String.valueOf(Boolean.parseBoolean(value)));
        } else if (PDFCConfigKey.IMAGE_TOLERANCE.getKey().equals(key)) {
            int n = Integer.parseInt(value);
            double d3 = PDFCConfigMapper.a(PDFCProperty.TOLERANCE_IMAGE_PIXEL_VALUE, n);
            double d4 = PDFCConfigMapper.a(PDFCProperty.TOLERANCE_IMAGE_SIZE, n);
            int n7 = (int)PDFCConfigMapper.a(PDFCProperty.TOLERANCE_IMAGE_DISTANCE, n);
            defaultProfile.putValue(PDFCProperty.TOLERANCE_IMAGE_PIXEL_VALUE, String.valueOf(d3));
            defaultProfile.putValue(PDFCProperty.TOLERANCE_IMAGE_SIZE, String.valueOf(d4));
            defaultProfile.putValue(PDFCProperty.TOLERANCE_IMAGE_DISTANCE, String.valueOf(n7));
        } else if (PDFCConfigKey.TEXT_LANGUAGE.getKey().equals(key)) {
            defaultProfile.putValue(PDFCProperty.DOCUMENT_LANGUAGE, value);
        }
    }

    private static double a(PDFCProperty<?> pDFCProperty, int n) {
        if (pDFCProperty == PDFCProperty.TEXT_ALIGN_RATIO) {
            return (double)n * 0.01;
        }
        if (pDFCProperty == PDFCProperty.TOLERANCE_TEXT_LOCATION) {
            return n <= 20 ? (double)(n / 2) : -1.0;
        }
        if (pDFCProperty == PDFCProperty.TOLERANCE_LINE_SIZE) {
            return (double)n / 2.0;
        }
        if (pDFCProperty == PDFCProperty.TOLERANCE_LINE_POSITION) {
            return n;
        }
        if (pDFCProperty == PDFCProperty.TOLERANCE_LINE_THICKNESS) {
            return (double)n / 10.0;
        }
        if (pDFCProperty == PDFCProperty.TOLERANCE_IMAGE_PIXEL_VALUE) {
            return (double)n / 100.0;
        }
        if (pDFCProperty == PDFCProperty.TOLERANCE_IMAGE_SIZE) {
            return (double)n / 100.0;
        }
        if (pDFCProperty == PDFCProperty.TOLERANCE_IMAGE_DISTANCE) {
            return (double)n / 10.0;
        }
        return 0.0;
    }

    private static double a(PDFCProperty<?> pDFCProperty) {
        if (pDFCProperty == PDFCProperty.TEXT_ALIGN_RATIO) {
            return 0.4;
        }
        if (pDFCProperty == PDFCProperty.TOLERANCE_TEXT_LOCATION) {
            return 10.0;
        }
        Pair pair = pDFCProperty.getLimits();
        if (pair != null) {
            return ((Number)pair.get(false)).doubleValue();
        }
        return 100.0;
    }

    private static void a(DefaultProfile defaultProfile, PDFCProperty<?> pDFCProperty, String string, boolean bl) {
        String string2 = defaultProfile.getString(pDFCProperty);
        HashSet<String> hashSet = new HashSet<String>();
        for (String string3 : string2.split("\\s*[,;]\\s*")) {
            if (string3.length() == 0) continue;
            hashSet.add(string3);
        }
        if (bl) {
            hashSet.add(string);
        } else {
            hashSet.remove(string);
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String string4 : hashSet) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(string4);
        }
        defaultProfile.putValue(pDFCProperty, stringBuilder.toString());
    }

    private static boolean a(DefaultProfile defaultProfile, PDFCProperty<?> pDFCProperty, String string) {
        String string2 = defaultProfile.getString(pDFCProperty);
        HashSet<String> hashSet = new HashSet<String>();
        for (String string3 : string2.split("\\s*[,;]\\s*")) {
            if (string3.length() == 0) continue;
            hashSet.add(string3);
        }
        return hashSet.contains(string);
    }

    public static List<FilterPatternEntry> getPattern(ConfigStructureSettings settings, ProfilePersistence configPersistence, ConfigKey key) {
        if (PDFCConfigKey.FILTER_PATTERNS.equals(key)) {
            Object object;
            FilterPatternEntry[] filterPatternEntryArray = (FilterPatternEntry[])settings.getChangedValue(PDFCConfigKey.FILTER_PATTERNS, FilterPatternEntry[].class);
            if (filterPatternEntryArray != null) {
                return Arrays.asList(filterPatternEntryArray);
            }
            ArrayList<FilterPatternEntry> arrayList = new ArrayList<FilterPatternEntry>();
            DefaultProfile defaultProfile = null;
            if (configPersistence != null) {
                defaultProfile = configPersistence.getProfile();
            }
            if (defaultProfile == null) {
                object = settings.getConfiguration();
                defaultProfile = new DefaultProfile();
                defaultProfile.putValues(object.getProperties());
            }
            if ((object = defaultProfile.getString(PDFCProperty.FILTER_PATTERNS)) != null && !((String)object).isEmpty()) {
                String[] stringArray;
                for (String string : stringArray = ((String)object).split("\n")) {
                    String[] stringArray2 = (string = string.replace("\r", "")).split("\\|");
                    if (stringArray2.length < 3) continue;
                    String string2 = stringArray2[stringArray2.length - 1];
                    String string3 = stringArray2[stringArray2.length - 2];
                    String string4 = string.substring(0, string.lastIndexOf(string3) - 1);
                    FilterPatternEntry filterPatternEntry = new FilterPatternEntry(string4.replace("[[BR]]", "\r\n"), string3, "active".equalsIgnoreCase(string2));
                    arrayList.add(filterPatternEntry);
                }
            }
            return arrayList;
        }
        return null;
    }

    public static String getValue(ConfigStructureSettings settings, ProfilePersistence configPersistence, ConfigKey key) {
        String string = settings.getChangedValue(key.getKey());
        if (string != null) {
            return string;
        }
        DefaultProfile defaultProfile = null;
        if (configPersistence != null) {
            defaultProfile = configPersistence.getProfile();
        }
        if (defaultProfile == null) {
            Configuration configuration = settings.getConfiguration();
            defaultProfile = new DefaultProfile();
            defaultProfile.putValues(configuration.getProperties());
        }
        if (PDFCConfigKey.COMPARE_MODE_STRICT.equals(key)) {
            return String.valueOf("STRICT".equals(defaultProfile.getString(PDFCProperty.CONTINUOUS_COMPARE)));
        }
        if (PDFCConfigKey.HEADER_FOOTER_FILTER.equals(key)) {
            boolean bl = PDFCConfigMapper.a(defaultProfile, PDFCProperty.FILTERS, "HEADERFOOTER");
            if (!bl) {
                return "off";
            }
            int n = defaultProfile.getInt(PDFCProperty.FIXED_HEADER_SIZE);
            int n2 = defaultProfile.getInt(PDFCProperty.FIXED_FOOTER_SIZE);
            if (n < 0 && n2 < 0) {
                return "automatic";
            }
            return "manual";
        }
        if (PDFCConfigKey.FIXED_HEADER_SIZE.equals(key)) {
            int n = defaultProfile.getInt(PDFCProperty.FIXED_HEADER_SIZE);
            if (n < 0) {
                n = (n + 1) * -1;
            }
            return String.valueOf(n);
        }
        if (PDFCConfigKey.FIXED_FOOTER_SIZE.equals(key)) {
            int n = defaultProfile.getInt(PDFCProperty.FIXED_FOOTER_SIZE);
            if (n < 0) {
                n = (n + 1) * -1;
            }
            return String.valueOf(n);
        }
        if (PDFCConfigKey.COMPARE_MERGE_DIFFS.equals(key)) {
            int n = defaultProfile.getInt(PDFCProperty.DIFF_MERGE_FACTOR);
            return Integer.toString(n);
        }
        if (PDFCConfigKey.UNICODENORMALIZE.equals(key)) {
            return String.valueOf(PDFCConfigMapper.a(defaultProfile, PDFCProperty.FILTERS, "UNICODENORMALIZE"));
        }
        if (PDFCConfigKey.MULTICOLUMN.equals(key)) {
            return String.valueOf(PDFCConfigMapper.a(defaultProfile, PDFCProperty.FILTERS, "MULTICOLUMN"));
        }
        if (PDFCConfigKey.INVISIBLE_ELEMENTS_FILTER.equals(key)) {
            return String.valueOf(PDFCConfigMapper.a(defaultProfile, PDFCProperty.FILTERS, "INVISIBLEELEMENTS"));
        }
        if (PDFCConfigKey.HIDE_ROTATION.equals(key)) {
            return String.valueOf(PDFCConfigMapper.a(defaultProfile, PDFCProperty.FILTERS, "HIDEROTATEDTEXT"));
        }
        if (PDFCConfigKey.REGEX_FILTER.equals(key)) {
            return String.valueOf(PDFCConfigMapper.a(defaultProfile, PDFCProperty.FILTERS, "REGEXP"));
        }
        if (PDFCConfigKey.TEXT.equals(key)) {
            return String.valueOf(PDFCConfigMapper.a(defaultProfile, PDFCProperty.COMPARE_TYPES, CompareType.TEXT.name()));
        }
        if (PDFCConfigKey.COMPARE_TEXT_CASE_SENSITIVE.equals(key)) {
            return String.valueOf(defaultProfile.getBool(PDFCProperty.COMPARE_TEXT_CASE_SENSITIVE));
        }
        if (PDFCConfigKey.COMPARE_TEXT_SIZE.equals(key)) {
            return String.valueOf(PDFCConfigMapper.a(defaultProfile, PDFCProperty.COMPARE_TEXT_STYLES, TextStyleType.SIZE.name()));
        }
        if (PDFCConfigKey.COMPARE_TEXT_COLOR.equals(key)) {
            return String.valueOf(PDFCConfigMapper.a(defaultProfile, PDFCProperty.COMPARE_TEXT_STYLES, TextStyleType.COLOR.name()));
        }
        if (PDFCConfigKey.COMPARE_TEXT_FAMILY.equals(key)) {
            return String.valueOf(PDFCConfigMapper.a(defaultProfile, PDFCProperty.COMPARE_TEXT_STYLES, TextStyleType.FONT.name()));
        }
        if (PDFCConfigKey.COMPARE_TEXT_STYLE.equals(key)) {
            return String.valueOf(PDFCConfigMapper.a(defaultProfile, PDFCProperty.COMPARE_TEXT_STYLES, TextStyleType.STYLES.name()));
        }
        if (PDFCConfigKey.COMPARE_TEXT_SPACING.equals(key)) {
            return String.valueOf(PDFCConfigMapper.a(defaultProfile, PDFCProperty.COMPARE_TEXT_STYLES, TextStyleType.SPACING.name()));
        }
        if (PDFCConfigKey.TEXT_TOLERANCE.equals(key)) {
            if ("STRICT".equals(defaultProfile.getString(PDFCProperty.CONTINUOUS_COMPARE))) {
                return String.valueOf(PDFCConfigMapper.a(defaultProfile, PDFCProperty.TEXT_ALIGN_RATIO, PDFCProperty.TOLERANCE_TEXT_LOCATION));
            }
            return String.valueOf(PDFCConfigMapper.a(defaultProfile, PDFCProperty.TEXT_ALIGN_RATIO));
        }
        if (PDFCConfigKey.LINE.equals(key)) {
            return String.valueOf(PDFCConfigMapper.a(defaultProfile, PDFCProperty.COMPARE_TYPES, CompareType.LINE.name()));
        }
        if (PDFCConfigKey.LINE_TOLERANCE.equals(key)) {
            return String.valueOf(PDFCConfigMapper.a(defaultProfile, PDFCProperty.TOLERANCE_LINE_SIZE, PDFCProperty.TOLERANCE_LINE_POSITION, PDFCProperty.TOLERANCE_LINE_THICKNESS));
        }
        if (PDFCConfigKey.IMAGE.equals(key)) {
            return String.valueOf(PDFCConfigMapper.a(defaultProfile, PDFCProperty.COMPARE_TYPES, CompareType.IMAGE.name()));
        }
        if (PDFCConfigKey.IMAGEMETA.equals(key)) {
            return defaultProfile.getString(PDFCProperty.IMAGE_META_COMPARISON);
        }
        if (PDFCConfigKey.IMAGEDETAILED.equals(key)) {
            return defaultProfile.getString(PDFCProperty.IMAGE_CHANGE_AREA);
        }
        if (PDFCConfigKey.IMAGE_TOLERANCE.equals(key)) {
            return String.valueOf(PDFCConfigMapper.a(defaultProfile, PDFCProperty.TOLERANCE_IMAGE_PIXEL_VALUE, PDFCProperty.TOLERANCE_IMAGE_SIZE, PDFCProperty.TOLERANCE_IMAGE_DISTANCE));
        }
        if (PDFCConfigKey.ANNOTATION.equals(key)) {
            return String.valueOf(PDFCConfigMapper.a(defaultProfile, PDFCProperty.COMPARE_TYPES, CompareType.ANNOTATION.name()));
        }
        if (PDFCConfigKey.ANNOTATION_DETAILED.equals(key)) {
            return defaultProfile.getString(PDFCProperty.COMPARE_ANNOTATIONS_DETAILED);
        }
        if (PDFCConfigKey.COMPARISON_TAGS.equals(key)) {
            return defaultProfile.getString(PDFCProperty.COMPARE_TAGS);
        }
        if (PDFCConfigKey.TEXT_LANGUAGE.equals(key)) {
            return String.valueOf(defaultProfile.getString(PDFCProperty.DOCUMENT_LANGUAGE));
        }
        return null;
    }

    private static int a(DefaultProfile defaultProfile, PDFCProperty<?> ... pDFCPropertyArray) {
        int n;
        int n2 = 0;
        double d2 = 2.147483647E9;
        double[] dArray = new double[pDFCPropertyArray.length];
        for (n = 0; n < pDFCPropertyArray.length; ++n) {
            PDFCProperty<?> pDFCProperty = pDFCPropertyArray[n];
            dArray[n] = pDFCProperty.getType() == Integer.class ? (double)defaultProfile.getInt(pDFCProperty) : defaultProfile.getDouble(pDFCProperty);
        }
        for (n = 0; n <= 100; ++n) {
            double d3 = 0.0;
            for (int k = 0; k < pDFCPropertyArray.length; ++k) {
                PDFCProperty<?> pDFCProperty = pDFCPropertyArray[k];
                double d4 = PDFCConfigMapper.a(pDFCProperty, n);
                d3 += Math.abs(dArray[k] - d4) / PDFCConfigMapper.a(pDFCProperty);
            }
            if (!(d3 < d2)) continue;
            n2 = n;
            d2 = d3;
        }
        return n2;
    }
}

