/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.server.persistence;

import com.inet.annotations.InternalApi;
import com.inet.config.ConfigKey;
import com.inet.config.ConfigValue;
import com.inet.field.fieldtypes.FieldTypeFactory;
import com.inet.id.GUID;
import com.inet.pdfc.plugin.persistence.ComparePersistence;
import com.inet.pdfc.plugin.persistence.UserContingent;
import com.inet.pdfc.server.persistence.impl.file.PersistenceCloudEvent;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.UserGroupField;

@InternalApi
public interface ContingentManager {
    public static final int MEGABYTE = 0x100000;
    public static final ConfigKey LIMITHDD = new ConfigKey("quotaHDD", "500", Long.class);
    public static final ConfigKey LIMITCOMPARISIONPERUSER = new ConfigKey("quotaComparisionPerUser", "10", Integer.class);
    public static final ConfigKey LIMITNUMOFPAGES = new ConfigKey("quotaPages", "5000", Integer.class);
    public static final ConfigValue<Long> CONTIGENT_HDD = new ConfigValue(LIMITHDD);
    public static final ConfigValue<Integer> CONTIGENT_COMPARISIONPERUSER = new ConfigValue(LIMITCOMPARISIONPERUSER);
    public static final ConfigValue<Integer> CONTIGENT_NUMOFPAGES = new ConfigValue(LIMITNUMOFPAGES);
    public static final UserField<Integer> USER_QUOTA_HDD = new UserField<Integer>("pdfc.quota.hdd.user", null, FieldTypeFactory.auto().withoutSearchTag()){};
    public static final UserGroupField<Integer> GROUP_QUOTA_HDD = new UserGroupField<Integer>("pdfc.quota.hdd.group", null, FieldTypeFactory.auto().withoutSearchTag()){};
    public static final UserField<Integer> USER_QUOTA_COMPARISONS = new UserField<Integer>("pdfc.quota.comparisons.user", null, FieldTypeFactory.auto().withoutSearchTag()){};
    public static final UserGroupField<Integer> GROUP_QUOTA_COMPARISONS = new UserGroupField<Integer>("pdfc.quota.comparisons.group", null, FieldTypeFactory.auto().withoutSearchTag()){};
    public static final UserField<Integer> USER_QUOTA_PAGES = new UserField<Integer>("pdfc.quota.pages.user", null, FieldTypeFactory.auto().withoutSearchTag()){};
    public static final UserGroupField<Integer> GROUP_QUOTA_PAGES = new UserGroupField<Integer>("pdfc.quota.pages.group", null, FieldTypeFactory.auto().withoutSearchTag()){};

    public boolean hasFreeHDDSpace(GUID var1);

    public boolean isAllowedComparing(GUID var1);

    public UserContingent getUserContingent(GUID var1);

    public void cleanUpContingent(GUID var1, String var2);

    public boolean reserveSpace(ComparePersistence var1, long var2);

    public void removeReserveSpace(ComparePersistence var1);

    public void monitorComparison(ComparePersistence var1);

    public void notifyChangeInBackground(PersistenceCloudEvent var1, boolean var2);

    public long getQuotaValue(QUOTA_TYPE var1, GUID var2);

    public void notifyComparisonTimeout(ComparePersistence var1);

    @InternalApi
    public static final class QUOTA_TYPE
    extends Enum<QUOTA_TYPE> {
        public static final /* enum */ QUOTA_TYPE hdd = new QUOTA_TYPE(USER_QUOTA_HDD, GROUP_QUOTA_HDD, CONTIGENT_HDD, 0x100000L);
        public static final /* enum */ QUOTA_TYPE pages = new QUOTA_TYPE(USER_QUOTA_PAGES, GROUP_QUOTA_PAGES, CONTIGENT_NUMOFPAGES, 1L);
        public static final /* enum */ QUOTA_TYPE comparisons = new QUOTA_TYPE(USER_QUOTA_COMPARISONS, GROUP_QUOTA_COMPARISONS, CONTIGENT_COMPARISIONPERUSER, 1L);
        private UserField<Integer> N;
        private UserGroupField<Integer> O;
        private ConfigValue<? extends Number> P;
        private long Q;
        private static final /* synthetic */ QUOTA_TYPE[] R;

        public static QUOTA_TYPE[] values() {
            return (QUOTA_TYPE[])R.clone();
        }

        public static QUOTA_TYPE valueOf(String name) {
            return Enum.valueOf(QUOTA_TYPE.class, name);
        }

        private QUOTA_TYPE(UserField<Integer> userField, UserGroupField<Integer> goupField, ConfigValue<? extends Number> configValue, long unitMultiplier) {
            this.N = userField;
            this.O = goupField;
            this.P = configValue;
            this.Q = unitMultiplier;
        }

        public UserField<Integer> getUserField() {
            return this.N;
        }

        public UserGroupField<Integer> getGroupField() {
            return this.O;
        }

        public ConfigValue<? extends Number> getConfigValue() {
            return this.P;
        }

        public long getUnitMultiplier() {
            return this.Q;
        }

        private static /* synthetic */ QUOTA_TYPE[] g() {
            return new QUOTA_TYPE[]{hdd, pages, comparisons};
        }

        static {
            R = QUOTA_TYPE.g();
        }
    }
}

