/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.server.model;

import com.inet.annotations.InternalApi;

@InternalApi
public class ExportSetting {
    private ExportFormat u = ExportFormat.PDF;
    private Orientation v = Orientation.PORTRAIT;
    private int w = PageFormat.A4.getWidth();
    private int x = PageFormat.A4.getHeight();
    private boolean y = true;
    private boolean z = true;
    private int A = -1;
    private int B = -1;
    private ExportPage C = ExportPage.BOTH;
    private String D = null;
    private boolean E = true;
    private PageFormat F;

    public void setReportAppendSetting(boolean reportAppendSetting) {
        this.z = reportAppendSetting;
    }

    public void setReportDetailed(boolean reportDetailed) {
        this.y = reportDetailed;
    }

    public boolean isReportDetailed() {
        return this.y;
    }

    public boolean isAutoPageSize() {
        return this.F == PageFormat.AUTO;
    }

    public boolean isReportAppendSetting() {
        return this.z;
    }

    public ExportFormat getExportFormat() {
        return this.u;
    }

    public Orientation getOrientation() {
        return this.v;
    }

    public int getPaperWidth() {
        if (this.v == Orientation.LANDSCAPE) {
            return this.x;
        }
        return this.w;
    }

    public int getPaperHeight() {
        if (this.v == Orientation.LANDSCAPE) {
            return this.w;
        }
        return this.x;
    }

    public int getStartPage() {
        return this.A;
    }

    public int getEndPage() {
        return this.B;
    }

    public ExportPage getExportPage() {
        return this.C;
    }

    public void setExportFormat(ExportFormat exportFormat) {
        this.u = exportFormat;
    }

    public void setOrientation(Orientation orientation) {
        this.v = orientation;
    }

    public void setPaperWidth(int paperWidth) {
        this.w = paperWidth;
    }

    public void setPaperHeight(int paperHeight) {
        this.x = paperHeight;
    }

    public void setStartPage(int startPage) {
        this.A = startPage;
    }

    public void setEndPage(int endPage) {
        this.B = endPage;
    }

    public void setExportPage(ExportPage exportPage) {
        this.C = exportPage;
    }

    public void setPageFormat(PageFormat pageFormat) {
        this.F = pageFormat;
        this.setPaperWidth(pageFormat.getWidth());
        this.setPaperHeight(pageFormat.getHeight());
    }

    public String getOwnerPass() {
        return this.D;
    }

    public void setOwnerPass(String ownerPass) {
        this.D = ownerPass;
    }

    public void setReplaceSystemFonts(boolean replace) {
        this.E = replace;
    }

    public boolean isReplace() {
        return this.E;
    }

    @InternalApi
    public static final class ExportFormat
    extends Enum<ExportFormat> {
        public static final /* enum */ ExportFormat PDF = new ExportFormat();
        public static final /* enum */ ExportFormat PNG = new ExportFormat();
        public static final /* enum */ ExportFormat REPORTODS = new ExportFormat();
        public static final /* enum */ ExportFormat REPORTPDF = new ExportFormat();
        public static final /* enum */ ExportFormat REPORTRTF = new ExportFormat();
        public static final /* enum */ ExportFormat REPORTXLS = new ExportFormat();
        public static final /* enum */ ExportFormat REPORTXLSX = new ExportFormat();
        private static final /* synthetic */ ExportFormat[] G;

        public static ExportFormat[] values() {
            return (ExportFormat[])G.clone();
        }

        public static ExportFormat valueOf(String name) {
            return Enum.valueOf(ExportFormat.class, name);
        }

        public static ExportFormat getReportFormat(String reportFormat) {
            for (ExportFormat exportFormat : ExportFormat.values()) {
                if (!exportFormat.name().equalsIgnoreCase(reportFormat)) continue;
                return exportFormat;
            }
            return REPORTPDF;
        }

        public String getMimeType() {
            switch (this) {
                case REPORTODS: {
                    return "application/vnd.oasis.opendocument.spreadsheet";
                }
                case REPORTRTF: {
                    return "application/msword";
                }
                case REPORTXLS: {
                    return "application/vnd.ms-excel";
                }
                case REPORTXLSX: {
                    return "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
                }
                case PNG: {
                    return "image/png";
                }
            }
            return "application/pdf";
        }

        public String getFileSuffix() {
            switch (this) {
                case REPORTODS: {
                    return ".ods";
                }
                case REPORTRTF: {
                    return ".rtf";
                }
                case REPORTXLS: {
                    return ".xls";
                }
                case REPORTXLSX: {
                    return ".xlsx";
                }
                case PNG: {
                    return ".png";
                }
            }
            return ".pdf";
        }

        private static /* synthetic */ ExportFormat[] c() {
            return new ExportFormat[]{PDF, PNG, REPORTODS, REPORTPDF, REPORTRTF, REPORTXLS, REPORTXLSX};
        }

        static {
            G = ExportFormat.c();
        }
    }

    @InternalApi
    public static final class Orientation
    extends Enum<Orientation> {
        public static final /* enum */ Orientation PORTRAIT = new Orientation();
        public static final /* enum */ Orientation LANDSCAPE = new Orientation();
        private static final /* synthetic */ Orientation[] J;

        public static Orientation[] values() {
            return (Orientation[])J.clone();
        }

        public static Orientation valueOf(String name) {
            return Enum.valueOf(Orientation.class, name);
        }

        public static Orientation getValue(String value) {
            for (Orientation orientation : Orientation.values()) {
                if (!orientation.name().equalsIgnoreCase(value)) continue;
                return orientation;
            }
            return PORTRAIT;
        }

        private static /* synthetic */ Orientation[] e() {
            return new Orientation[]{PORTRAIT, LANDSCAPE};
        }

        static {
            J = Orientation.e();
        }
    }

    @InternalApi
    public static final class PageFormat
    extends Enum<PageFormat> {
        public static final /* enum */ PageFormat AUTO = new PageFormat("Auto", 793, 1122);
        public static final /* enum */ PageFormat A3 = new PageFormat("A3 (ISO/DIN & JIS)", 1122, 1587);
        public static final /* enum */ PageFormat A4 = new PageFormat("A4 (ISO/DIN & JIS)", 793, 1122);
        public static final /* enum */ PageFormat A5 = new PageFormat("A5 (ISO/DIN & JIS)", 559, 793);
        public static final /* enum */ PageFormat B4 = new PageFormat("B4 (JIS)", 971, 1375);
        public static final /* enum */ PageFormat B5 = new PageFormat("B5 (JIS)", 687, 971);
        public static final /* enum */ PageFormat LEGAL = new PageFormat("Legal", 816, 1344);
        public static final /* enum */ PageFormat LETTER = new PageFormat("Letter", 816, 1056);
        private final String name;
        private final int K;
        private final int L;
        private static final /* synthetic */ PageFormat[] M;

        public static PageFormat[] values() {
            return (PageFormat[])M.clone();
        }

        public static PageFormat valueOf(String name) {
            return Enum.valueOf(PageFormat.class, name);
        }

        private PageFormat(String name, int width, int height) {
            this.name = name;
            this.K = width;
            this.L = height;
        }

        public int getWidth() {
            return this.K;
        }

        public int getHeight() {
            return this.L;
        }

        public String getName() {
            return this.name;
        }

        public static PageFormat getValue(String value) {
            for (PageFormat pageFormat : PageFormat.values()) {
                if (!pageFormat.name().equalsIgnoreCase(value)) continue;
                return pageFormat;
            }
            return A4;
        }

        private static /* synthetic */ PageFormat[] f() {
            return new PageFormat[]{AUTO, A3, A4, A5, B4, B5, LEGAL, LETTER};
        }

        static {
            M = PageFormat.f();
        }
    }

    @InternalApi
    public static final class ExportPage
    extends Enum<ExportPage> {
        public static final /* enum */ ExportPage LEFT = new ExportPage(1);
        public static final /* enum */ ExportPage RIGHT = new ExportPage(2);
        public static final /* enum */ ExportPage BOTH = new ExportPage(3);
        private byte H;
        private static final /* synthetic */ ExportPage[] I;

        public static ExportPage[] values() {
            return (ExportPage[])I.clone();
        }

        public static ExportPage valueOf(String name) {
            return Enum.valueOf(ExportPage.class, name);
        }

        private ExportPage(byte value) {
            this.H = value;
        }

        public byte getValue() {
            return this.H;
        }

        public static ExportPage getValue(String value) {
            for (ExportPage exportPage : ExportPage.values()) {
                if (!exportPage.name().equalsIgnoreCase(value)) continue;
                return exportPage;
            }
            return BOTH;
        }

        private static /* synthetic */ ExportPage[] d() {
            return new ExportPage[]{LEFT, RIGHT, BOTH};
        }

        static {
            I = ExportPage.d();
        }
    }
}

