/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.server.structure;

import com.inet.annotations.InternalApi;
import com.inet.config.ConfigKey;
import com.inet.config.structure.ConfigStructure;
import com.inet.config.structure.model.ConfigAction;
import com.inet.config.structure.model.ConfigCategory;
import com.inet.config.structure.model.ConfigCondition;
import com.inet.config.structure.model.ConfigConditionAction;
import com.inet.config.structure.model.ConfigGroup;
import com.inet.config.structure.model.ConfigProperty;
import com.inet.config.structure.model.ConfigPropertyGroup;
import com.inet.config.structure.model.ConfigValidationMsg;
import com.inet.config.structure.model.LocalizedKey;
import com.inet.config.structure.model.SelectConfigProperty;
import com.inet.config.structure.model.SliderConfigProperty;
import com.inet.config.structure.model.StyledLabelConfigProperty;
import com.inet.config.structure.provider.AbstractStructureProvider;
import com.inet.config.structure.provider.ConditionGenerator;
import com.inet.config.structure.provider.ConfigStructureSettings;
import com.inet.id.GUID;
import com.inet.pdfc.PDFCCore;
import com.inet.pdfc.config.DefaultProfile;
import com.inet.pdfc.config.PDFCProperty;
import com.inet.pdfc.config.ProfileValidator;
import com.inet.pdfc.plugin.PluginManager;
import com.inet.pdfc.plugin.persistence.ComparePersistence;
import com.inet.pdfc.plugin.persistence.PersistenceFactory;
import com.inet.pdfc.plugin.persistence.ProfilePersistence;
import com.inet.pdfc.plugin.persistence.ProfilePersistenceManager;
import com.inet.pdfc.server.structure.PDFCConfigKey;
import com.inet.pdfc.server.structure.PDFCConfigMapper;
import com.inet.permissions.AccessDeniedException;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.api.user.UserManager;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

@InternalApi
public class PDFCProfileStructureProvider
extends AbstractStructureProvider {
    public static final String COMPARE = "configgroup.compare";
    public static final String COMPARE_CONFIGURATION = "category.compare.configuration";
    public static final String VALIDATION = "propertygroup.pdfccompareconfig.validation";
    public static final String VALIDATION_STORE = "propertygroup.pdfccompareconfig.validation.store";
    public static final String VALIDATION_CLEAN = "propertygroup.pdfccompareconfig.validation.clean";
    public static final String DESCRIPTION = "propertygroup.pdfccompareconfig.description";
    public static final String COMPARE_MODE = "propertygroup.pdfccompareconfig.comparemode";
    public static final String FILTER_OPTIMIZING = "propertygroup.pdfccompareconfig.filteroptimizing";
    public static final String COMPARE_TEXT = "propertygroup.pdfccompareconfig.compare.text";
    public static final String COMPARE_LINE = "propertygroup.pdfccompareconfig.compare.line";
    public static final String COMPARE_IMAGE = "propertygroup.pdfccompareconfig.compare.image";
    public static final String COMPARE_ANNOTATION = "propertygroup.pdfccompareconfig.compare.annotation";
    public static final String CATEGORY_PROFILES = "category.profiles";

    public void addCategoriesTo(@Nonnull Set<ConfigCategory> categories, @Nonnull String groupKey, boolean advanced, @Nonnull ConfigStructureSettings settings) {
        switch (groupKey) {
            case "configgroup.compare": {
                categories.add(new ConfigCategory(100, COMPARE_CONFIGURATION, "", "pdfc.gui.profiles"));
                break;
            }
        }
    }

    public URL getCategoryIcon(@Nonnull String categoryKey) {
        switch (categoryKey) {
            case "category.compare.configuration": {
                return ((Object)((Object)this)).getClass().getResource("editconfig_24.png");
            }
        }
        return null;
    }

    public void addPropertyGroupsTo(@Nonnull Set<ConfigPropertyGroup> propertyGroups, @Nonnull String categoryKey, boolean advanced, @Nonnull ConfigStructureSettings settings) {
        switch (categoryKey) {
            case "category.compare.configuration": {
                ProfilePersistence profilePersistence = PDFCProfileStructureProvider.getConfigurationPersistence(settings);
                if (profilePersistence != null && profilePersistence.hasProblems()) {
                    propertyGroups.add(new ConfigPropertyGroup(50, VALIDATION, this.translate(settings, VALIDATION, new Object[0])));
                    if (this.aC()) {
                        ConfigPropertyGroup configPropertyGroup = new ConfigPropertyGroup(90, VALIDATION_STORE, null);
                        configPropertyGroup.setColumnSet(ConfigPropertyGroup.COLUMN_SET.none);
                        propertyGroups.add(configPropertyGroup);
                    }
                    if (this.a(profilePersistence)) {
                        propertyGroups.add(new ConfigPropertyGroup(91, VALIDATION_CLEAN, null, new ConfigAction(VALIDATION_CLEAN, this.translate(settings, VALIDATION_CLEAN, new Object[0]))));
                    }
                    propertyGroups.add(new ConfigPropertyGroup(100, DESCRIPTION, "\u00a0"));
                } else {
                    propertyGroups.add(new ConfigPropertyGroup(100, DESCRIPTION, null));
                }
                propertyGroups.add(new ConfigPropertyGroup(200, COMPARE_MODE, this.translate(settings, COMPARE_MODE, new Object[0])));
                propertyGroups.add(new ConfigPropertyGroup(300, FILTER_OPTIMIZING, this.translate(settings, FILTER_OPTIMIZING, new Object[0])));
                propertyGroups.add(new ConfigPropertyGroup(400, COMPARE_TEXT, this.translate(settings, COMPARE_TEXT, new Object[0])));
                propertyGroups.add(new ConfigPropertyGroup(500, COMPARE_LINE, this.translate(settings, COMPARE_LINE, new Object[0])));
                propertyGroups.add(new ConfigPropertyGroup(600, COMPARE_IMAGE, this.translate(settings, COMPARE_IMAGE, new Object[0])));
                propertyGroups.add(new ConfigPropertyGroup(700, COMPARE_ANNOTATION, this.translate(settings, COMPARE_ANNOTATION, new Object[0])));
                break;
            }
        }
    }

    private boolean a(ProfilePersistence profilePersistence) {
        return profilePersistence != null && profilePersistence.getScope() != ProfilePersistence.SCOPE.DEFAULT && (profilePersistence.getOwnerID().equals((Object)UserManager.getInstance().getCurrentUserAccountID()) || SystemPermissionChecker.checkAccess((Permission)Permission.CONFIGURATION));
    }

    private boolean aC() {
        return ServerPluginManager.getInstance().isPluginLoaded("pluginstore.client") && SystemPermissionChecker.checkAccess((Permission)Permission.CONFIGURATION);
    }

    public void action(String actionKey, ArrayList<ConfigValidationMsg> messages, ConfigStructureSettings settings) {
        ProfilePersistence profilePersistence;
        if (VALIDATION_CLEAN.equals(actionKey) && this.a(profilePersistence = PDFCProfileStructureProvider.getConfigurationPersistence(settings))) {
            new ProfileValidator().cleanUp(profilePersistence.getProfile());
            ProfilePersistenceManager profilePersistenceManager = (ProfilePersistenceManager)PluginManager.getSingleInstance(ProfilePersistenceManager.class);
            try {
                profilePersistenceManager.save(profilePersistence, profilePersistence.getOwnerID());
                messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Reload, "", VALIDATION_CLEAN));
            }
            catch (IOException iOException) {
                messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, iOException.getMessage(), VALIDATION_CLEAN));
                PDFCCore.LOGGER_CORE.error((Throwable)iOException);
            }
        }
    }

    public void addPropertiesTo(@Nonnull Set<ConfigProperty> configProperties, @Nonnull String propertyGroupKey, boolean advanced, @Nonnull ConfigStructureSettings settings) {
        switch (propertyGroupKey) {
            case "propertygroup.pdfccompareconfig.validation": {
                ProfilePersistence profilePersistence = PDFCProfileStructureProvider.getConfigurationPersistence(settings);
                if (profilePersistence == null || !profilePersistence.hasProblems()) break;
                this.addTo(configProperties, "propertygroup.pdfccompareconfig.validation.description", "Label", settings);
                Map map = new ProfileValidator().verifyConfig(profilePersistence.getProfile(), profilePersistence.getScope() == ProfilePersistence.SCOPE.DEFAULT);
                Set<StyledLabelConfigProperty.Style> set = Set.of(StyledLabelConfigProperty.Style.warning);
                int n = 1;
                for (String string : map.values()) {
                    String string2 = n == 1 ? this.translate(settings, "propertygroup.pdfccompareconfig.validation.prefix", new Object[]{map.size()}) : "";
                    configProperties.add((ConfigProperty)new StyledLabelConfigProperty(set, 50 + n, "warning" + n++, string2, string));
                }
                break;
            }
            case "propertygroup.pdfccompareconfig.validation.store": {
                if (!this.aC()) break;
                configProperties.add(new ConfigProperty(90, VALIDATION_STORE, "Link", this.translate(settings, VALIDATION_STORE, new Object[0]), (Object)"store/category/pdfc.filter", null, this.translate(settings, "propertygroup.pdfccompareconfig.validation.store.link", new Object[0])));
                break;
            }
            case "propertygroup.pdfccompareconfig.description": {
                ProfilePersistence profilePersistence = PDFCProfileStructureProvider.getConfigurationPersistence(settings);
                this.addTo(configProperties, "pdfc.meta.description", "SimpleText", profilePersistence == null ? "" : profilePersistence.getDescription(false), settings);
                break;
            }
            case "propertygroup.pdfccompareconfig.comparemode": {
                ProfilePersistence profilePersistence = PDFCProfileStructureProvider.getConfigurationPersistence(settings);
                this.addTo(configProperties, PDFCConfigKey.COMPARE_MODE_STRICT.getKey(), "Boolean", PDFCConfigMapper.getValue(settings, profilePersistence, PDFCConfigKey.COMPARE_MODE_STRICT), settings);
                break;
            }
            case "propertygroup.pdfccompareconfig.filteroptimizing": {
                ProfilePersistence profilePersistence = PDFCProfileStructureProvider.getConfigurationPersistence(settings);
                ArrayList<LocalizedKey> arrayList = new ArrayList<LocalizedKey>();
                arrayList.add(new LocalizedKey("0", this.translate(settings, "pdfc.compare.diff.merge.off", new Object[0])));
                arrayList.add(new LocalizedKey("10", this.translate(settings, "pdfc.compare.diff.merge.max", new Object[0])));
                String string = PDFCConfigMapper.getValue(settings, profilePersistence, PDFCConfigKey.COMPARE_MERGE_DIFFS);
                string = "0".equals(string) ? "0" : "10";
                String string3 = this.translate(settings, PDFCConfigKey.COMPARE_MERGE_DIFFS.getKey(), new Object[0]);
                String string4 = this.translate(settings, PDFCConfigKey.COMPARE_MERGE_DIFFS.getKey() + ".tooltip", new Object[0]);
                SelectConfigProperty selectConfigProperty = new SelectConfigProperty(-1, PDFCConfigKey.COMPARE_MERGE_DIFFS.getKey(), this.getDefaultType(PDFCConfigKey.COMPARE_MERGE_DIFFS), string3, (Object)string, string4, arrayList);
                configProperties.add((ConfigProperty)selectConfigProperty);
                break;
            }
            case "propertygroup.pdfccompareconfig.compare.text": {
                ProfilePersistence profilePersistence = PDFCProfileStructureProvider.getConfigurationPersistence(settings);
                this.addTo(configProperties, PDFCConfigKey.TEXT.getKey(), "Boolean", PDFCConfigMapper.getValue(settings, profilePersistence, PDFCConfigKey.TEXT), settings);
                configProperties.add(new ConfigProperty(configProperties.size() * 100, PDFCConfigKey.TEXT_TOLERANCE_HINT.getKey(), "Label", this.translate(settings, "pdfc.compare.text.tolerance", new Object[0]), (Object)this.translate(settings, "pdfc.compare.text.tolerance.hint", new Object[0]), "", ""));
                configProperties.add((ConfigProperty)new SliderConfigProperty(configProperties.size() * 100, PDFCConfigKey.TEXT_TOLERANCE.getKey(), "", PDFCConfigMapper.getValue(settings, profilePersistence, PDFCConfigKey.TEXT_TOLERANCE), "", new SliderConfigProperty.SliderBound((Number)0, ""), new SliderConfigProperty.SliderBound((Number)40, ""), true).setUnit("%"));
                List list = PDFCProperty.DOCUMENT_LANGUAGE.getAvailableValues().stream().map(validValue -> new LocalizedKey(validValue.getProfileValue(), validValue.getDisplayString())).collect(Collectors.toList());
                if (list.size() > 1) {
                    this.addSelectTo(configProperties, PDFCConfigKey.TEXT_LANGUAGE, PDFCConfigMapper.getValue(settings, profilePersistence, PDFCConfigKey.TEXT_LANGUAGE), settings, list);
                }
                this.addTo(configProperties, PDFCConfigKey.COMPARE_TEXT_CASE_SENSITIVE.getKey(), "Boolean", PDFCConfigMapper.getValue(settings, profilePersistence, PDFCConfigKey.COMPARE_TEXT_CASE_SENSITIVE), settings);
                this.addTo(configProperties, PDFCConfigKey.COMPARE_TEXT_SIZE.getKey(), "Boolean", PDFCConfigMapper.getValue(settings, profilePersistence, PDFCConfigKey.COMPARE_TEXT_SIZE), settings);
                this.addTo(configProperties, PDFCConfigKey.COMPARE_TEXT_COLOR.getKey(), "Boolean", PDFCConfigMapper.getValue(settings, profilePersistence, PDFCConfigKey.COMPARE_TEXT_COLOR), settings);
                this.addTo(configProperties, PDFCConfigKey.COMPARE_TEXT_FAMILY.getKey(), "Boolean", PDFCConfigMapper.getValue(settings, profilePersistence, PDFCConfigKey.COMPARE_TEXT_FAMILY), settings);
                this.addTo(configProperties, PDFCConfigKey.COMPARE_TEXT_STYLE.getKey(), "Boolean", PDFCConfigMapper.getValue(settings, profilePersistence, PDFCConfigKey.COMPARE_TEXT_STYLE), settings);
                this.addTo(configProperties, PDFCConfigKey.COMPARE_TEXT_SPACING.getKey(), "Boolean", PDFCConfigMapper.getValue(settings, profilePersistence, PDFCConfigKey.COMPARE_TEXT_SPACING), settings);
                break;
            }
            case "propertygroup.pdfccompareconfig.compare.line": {
                ProfilePersistence profilePersistence = PDFCProfileStructureProvider.getConfigurationPersistence(settings);
                this.addTo(configProperties, PDFCConfigKey.LINE.getKey(), "Boolean", PDFCConfigMapper.getValue(settings, profilePersistence, PDFCConfigKey.LINE), settings);
                configProperties.add(new ConfigProperty(configProperties.size() * 100, PDFCConfigKey.LINE_TOLERANCE_HINT.getKey(), "Label", this.translate(settings, "pdfc.compare.line.tolerance", new Object[0]), (Object)this.translate(settings, "pdfc.compare.line.tolerance.hint", new Object[0]), "", ""));
                configProperties.add((ConfigProperty)new SliderConfigProperty(configProperties.size() * 100, PDFCConfigKey.LINE_TOLERANCE.getKey(), "", PDFCConfigMapper.getValue(settings, profilePersistence, PDFCConfigKey.LINE_TOLERANCE), "", new SliderConfigProperty.SliderBound((Number)0, ""), new SliderConfigProperty.SliderBound((Number)100, ""), true).setUnit("%"));
                break;
            }
            case "propertygroup.pdfccompareconfig.compare.image": {
                ProfilePersistence profilePersistence = PDFCProfileStructureProvider.getConfigurationPersistence(settings);
                this.addTo(configProperties, PDFCConfigKey.IMAGE.getKey(), "Boolean", PDFCConfigMapper.getValue(settings, profilePersistence, PDFCConfigKey.IMAGE), settings);
                this.addTo(configProperties, PDFCConfigKey.IMAGEMETA.getKey(), "Boolean", PDFCConfigMapper.getValue(settings, profilePersistence, PDFCConfigKey.IMAGEMETA), settings);
                this.addTo(configProperties, PDFCConfigKey.IMAGEDETAILED.getKey(), "Boolean", PDFCConfigMapper.getValue(settings, profilePersistence, PDFCConfigKey.IMAGEDETAILED), settings);
                configProperties.add(new ConfigProperty(configProperties.size() * 100, PDFCConfigKey.IMAGE_TOLERANCE_HINT.getKey(), "Label", this.translate(settings, "pdfc.compare.image.tolerance", new Object[0]), (Object)this.translate(settings, "pdfc.compare.image.tolerance.hint", new Object[0]), "", ""));
                configProperties.add((ConfigProperty)new SliderConfigProperty(configProperties.size() * 100, PDFCConfigKey.IMAGE_TOLERANCE.getKey(), "", PDFCConfigMapper.getValue(settings, profilePersistence, PDFCConfigKey.IMAGE_TOLERANCE), "", new SliderConfigProperty.SliderBound((Number)0, ""), new SliderConfigProperty.SliderBound((Number)100, ""), true).setUnit("%"));
                break;
            }
            case "propertygroup.pdfccompareconfig.compare.annotation": {
                ProfilePersistence profilePersistence = PDFCProfileStructureProvider.getConfigurationPersistence(settings);
                this.addTo(configProperties, PDFCConfigKey.ANNOTATION.getKey(), "Boolean", PDFCConfigMapper.getValue(settings, profilePersistence, PDFCConfigKey.ANNOTATION), settings);
                this.addTo(configProperties, PDFCConfigKey.ANNOTATION_DETAILED.getKey(), "Boolean", PDFCConfigMapper.getValue(settings, profilePersistence, PDFCConfigKey.ANNOTATION_DETAILED), settings);
                this.addTo(configProperties, PDFCConfigKey.COMPARISON_TAGS.getKey(), "Boolean", PDFCConfigMapper.getValue(settings, profilePersistence, PDFCConfigKey.COMPARISON_TAGS), settings);
                break;
            }
        }
    }

    public static ProfilePersistence getConfigurationPersistence(ConfigStructureSettings settings) {
        try {
            GUID gUID = GUID.valueOf((String)settings.getConfiguration().getName());
            ProfilePersistenceManager profilePersistenceManager = (ProfilePersistenceManager)PluginManager.getSingleInstance(ProfilePersistenceManager.class);
            List list = profilePersistenceManager.getAllProfiles(UserManager.getInstance().getCurrentUserAccountID());
            for (ProfilePersistence profilePersistence : list) {
                if (!gUID.equals((Object)profilePersistence.getGUID())) continue;
                return profilePersistence;
            }
            ComparePersistence comparePersistence = ((PersistenceFactory)ServerPluginManager.getInstance().getSingleInstance(PersistenceFactory.class)).getPersistence(gUID);
            if (comparePersistence != null) {
                ProfilePersistence profilePersistence;
                profilePersistence = comparePersistence.getProfile();
                return new ProfilePersistence(gUID, comparePersistence.getOwnerID(), (DefaultProfile)profilePersistence);
            }
        }
        catch (AccessDeniedException accessDeniedException) {
        }
        catch (IOException | IllegalArgumentException exception) {
            PDFCCore.LOGGER_CORE.error((Throwable)exception);
        }
        return null;
    }

    public void addConditionsTo(List<ConfigConditionAction> actions, String categoryKey, boolean advanced, ConfigStructureSettings settings) {
        if (categoryKey.equals(COMPARE_CONFIGURATION)) {
            this.a(actions, PDFCConfigKey.TEXT, PDFCConfigKey.COMPARE_TEXT_CASE_SENSITIVE, PDFCConfigKey.TEXT_TOLERANCE, PDFCConfigKey.TEXT_TOLERANCE_HINT, PDFCConfigKey.TEXT_LANGUAGE, PDFCConfigKey.COMPARE_TEXT_STYLE, PDFCConfigKey.COMPARE_TEXT_FAMILY, PDFCConfigKey.COMPARE_TEXT_COLOR, PDFCConfigKey.COMPARE_TEXT_SIZE, PDFCConfigKey.COMPARE_TEXT_SPACING);
            this.a(actions, PDFCConfigKey.LINE, PDFCConfigKey.LINE_TOLERANCE, PDFCConfigKey.LINE_TOLERANCE_HINT);
            this.a(actions, PDFCConfigKey.IMAGE, PDFCConfigKey.IMAGE_TOLERANCE, PDFCConfigKey.IMAGE_TOLERANCE_HINT, PDFCConfigKey.IMAGEMETA, PDFCConfigKey.IMAGEDETAILED);
            this.a(actions, PDFCConfigKey.ANNOTATION, PDFCConfigKey.ANNOTATION_DETAILED);
        }
    }

    private void a(List<ConfigConditionAction> list, ConfigKey configKey, ConfigKey ... configKeyArray) {
        ConditionGenerator conditionGenerator = new ConditionGenerator();
        ConfigCondition configCondition = conditionGenerator.createCondition().property(configKey).equals().value((Object)Boolean.TRUE);
        for (ConfigKey configKey2 : configKeyArray) {
            list.add(conditionGenerator.enableActionFor(configCondition, configKey2));
        }
    }

    public void addGroupsTo(@Nonnull Set<ConfigGroup> groups, boolean advanced, @Nonnull ConfigStructureSettings settings) {
        groups.add(new ConfigGroup(108, COMPARE, this.translate(settings, COMPARE, new Object[0])));
    }

    public String getApplicationKey() {
        return "PDFC";
    }

    public void validate(String categoryKey, ArrayList<ConfigValidationMsg> messages, ArrayList<ConfigConditionAction> conditions, ConfigStructureSettings settings) {
    }

    public ConfigStructure.SaveState save(String key, String value, ConfigStructureSettings settings) {
        Field[] fieldArray;
        switch (key) {
            case "pdfc.meta.description": {
                ProfilePersistence profilePersistence = PDFCProfileStructureProvider.getConfigurationPersistence(settings);
                profilePersistence.getProfile().putValue("PROFIL_DESCRIPTION", value);
                ProfilePersistenceManager profilePersistenceManager = (ProfilePersistenceManager)PluginManager.getSingleInstance(ProfilePersistenceManager.class);
                try {
                    profilePersistenceManager.save(profilePersistence, UserManager.getInstance().getCurrentUserAccountID());
                }
                catch (IOException iOException) {
                    PDFCCore.LOGGER_CORE.error((Throwable)iOException);
                }
                return ConfigStructure.SaveState.SAVE;
            }
        }
        for (Field field : fieldArray = PDFCConfigKey.class.getDeclaredFields()) {
            if (field.getType() != ConfigKey.class) continue;
            try {
                ConfigKey configKey = (ConfigKey)field.get(null);
                if (!key.equals(configKey.getKey())) continue;
                ProfilePersistence profilePersistence = PDFCProfileStructureProvider.getConfigurationPersistence(settings);
                PDFCConfigMapper.saveInConfiguration(settings, profilePersistence, key, value);
                ProfilePersistenceManager profilePersistenceManager = (ProfilePersistenceManager)PluginManager.getSingleInstance(ProfilePersistenceManager.class);
                try {
                    profilePersistenceManager.save(profilePersistence, UserManager.getInstance().getCurrentUserAccountID());
                }
                catch (IOException iOException) {
                    PDFCCore.LOGGER_CORE.error((Throwable)iOException);
                }
                return ConfigStructure.SaveState.SAVE;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                PDFCCore.LOGGER_CORE.error((Throwable)illegalArgumentException);
            }
            catch (IllegalAccessException illegalAccessException) {
                PDFCCore.LOGGER_CORE.error((Throwable)illegalAccessException);
            }
        }
        return super.save(key, value, settings);
    }
}

