/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.util;

import com.inet.annotations.InternalApi;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

@InternalApi
public class Sample<T>
extends Number {
    public static final Comparator<Sample<?>> SORT_BY_VALUE = (sample, sample2) -> Double.compare(sample.up, sample2.up);
    public static final Comparator<Sample<?>> SORT_BY_OCCURENCES = (sample, sample2) -> {
        if (sample.getOccurrences() == sample2.getOccurrences()) {
            return Double.compare(sample.up, sample2.up);
        }
        return sample.getOccurrences().size() - sample2.getOccurrences().size();
    };
    private double up;
    private double uq = Double.MAX_VALUE;
    private double ur = Double.MIN_VALUE;
    private double us = 0.0;
    private List<T> ut = new ArrayList<T>();

    public Sample(List<T> samples, ValueFunction<T> assignment) {
        double d2 = 0.0;
        for (T t : samples) {
            d2 += assignment.getValue(t);
        }
        this.up = d2 / (double)samples.size();
        for (T t : samples) {
            double d3 = assignment.getValue(t);
            this.us += Math.pow(this.up - d3, 2.0);
            if (d3 < this.uq) {
                this.uq = d3;
            }
            if (!(d3 > this.ur)) continue;
            this.ur = d3;
        }
        this.us /= (double)samples.size();
        this.ut = samples;
    }

    public void addOccurrence(T value) {
        this.ut.add(value);
    }

    public List<T> getOccurrences() {
        return this.ut;
    }

    public int getCount() {
        return this.ut.size();
    }

    public double getMin() {
        return this.uq;
    }

    public double getMax() {
        return this.ur;
    }

    public double getVariance() {
        return this.us;
    }

    @Override
    public int intValue() {
        return (int)Math.round(this.up);
    }

    @Override
    public long longValue() {
        return Math.round(this.up);
    }

    @Override
    public float floatValue() {
        return (float)this.up;
    }

    @Override
    public double doubleValue() {
        return this.up;
    }

    @FunctionalInterface
    @InternalApi
    public static interface ValueFunction<T> {
        public double getValue(T var1);
    }
}

