/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.util;

import com.inet.annotations.InternalApi;
import com.inet.pdfc.generator.model.forms.GeomShape;
import com.inet.pdfc.model.DrawableElement;
import com.inet.pdfc.model.ElementID;
import com.inet.pdfc.model.ShapeElement;
import com.inet.pdfc.util.ElementSorter;
import com.inet.pdfc.util.LocationUtils;
import java.awt.Color;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;

@InternalApi
public class ElementSearch<@Nonnull T extends DrawableElement> {
    public static final double SEARCH_AREA_TOLERANCE = 0.5;
    private int tr;
    private boolean ts;
    private b<a<T>> tt;
    private List<@Nonnull T> tu = new ArrayList<T>();
    private double tv = 0.5;

    public ElementSearch(@Nonnull Rectangle2D pageArea) {
        this(pageArea, 50);
    }

    public ElementSearch(@Nonnull Rectangle2D pageArea, int nodeSize) {
        this.tr = nodeSize;
        this.tt = new b(pageArea.getX() - 0.25, pageArea.getY() - 0.25, pageArea.getWidth() + 0.5, pageArea.getHeight() + 0.5, 0);
    }

    public ElementSearch<T> setSkipBogusElements() {
        this.ts = true;
        return this;
    }

    public void setSearchAreaTolerance(double tolerance) {
        this.tv = tolerance;
    }

    public void add(@Nonnull T element) {
        this.tu.add(element);
    }

    public ElementSearch<T> addAll(@Nonnull @Nonnull List<@Nonnull T> elements) {
        this.tu.addAll(elements);
        return this;
    }

    private void df() {
        if (this.tu.isEmpty()) {
            return;
        }
        for (DrawableElement drawableElement : this.tu) {
            this.tt.a(new a<DrawableElement>(drawableElement));
        }
        this.tu = new ArrayList<T>();
    }

    @Nonnull
    public @Nonnull List<@Nonnull T> getElementsInArea(Rectangle2D requestArea) {
        return this.getElementsInArea(requestArea, false);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Nonnull
    public @Nonnull List<@Nonnull T> getElementsInArea(Rectangle2D requestArea, boolean containedOnly) {
        this.df();
        double d2 = this.tv;
        Rectangle2D.Double double_ = new Rectangle2D.Double(requestArea.getX() - d2, requestArea.getY() - d2, requestArea.getWidth() + d2 * 2.0, requestArea.getHeight() + d2 * 2.0);
        ArrayList<@Nonnull @Nonnull E> arrayList = new ArrayList(1024);
        ArrayList<@Nonnull @Nonnull E> arrayList2 = new ArrayList(1024);
        this.tt.a(double_, arrayList, arrayList2, containedOnly);
        ArrayList<@Nonnull T> arrayList3 = new ArrayList(arrayList.size());
        for (a a2 : arrayList2) {
            a2.v(false);
        }
        for (a a2 : arrayList) {
            a2.v(false);
            arrayList3.add(a2.dg());
        }
        return arrayList3;
    }

    @Nonnull
    public @Nonnull List<@Nonnull T> getElementsInAreaAsList(Rectangle2D requestArea, boolean sort) {
        List<@Nonnull T> list = this.getElementsInArea(requestArea);
        if (sort) {
            Collections.sort(list, ElementSorter.YX_COMPARATOR);
        }
        return list;
    }

    @Nonnull
    public @Nonnull List<@Nonnull T> getElementsInAreaAsList(double x, double y, double width, double height, boolean sort) {
        return this.getElementsInAreaAsList(x, y, width, height, sort, false);
    }

    @Nonnull
    public @Nonnull List<@Nonnull T> getElementsInAreaAsList(double x, double y, double width, double height, boolean sort, boolean containedOnly) {
        @Nonnull ArrayList<@Nonnull T> arrayList = new ArrayList<T>(this.getElementsInArea(new Rectangle2D.Double(x, y, width, height), containedOnly));
        if (sort) {
            Collections.sort(arrayList, ElementSorter.YX_COMPARATOR);
        }
        return arrayList;
    }

    public boolean remove(T e2) {
        if (!this.tu.isEmpty() && this.tu.remove(e2)) {
            return true;
        }
        return this.tt.b(new a<T>(e2));
    }

    protected boolean isBogusElement(DrawableElement e2) {
        switch (e2.getType()) {
            case Shape: {
                Paint paint;
                ShapeElement shapeElement = (ShapeElement)e2;
                if (shapeElement.getIsClip()) {
                    return true;
                }
                if (shapeElement.getStroke() != null && shapeElement.getStrokePaint() != null || !Color.WHITE.equals(paint = shapeElement.getFillPaint()) && (!(paint instanceof Color) || ((Color)paint).getAlpha() >= 5)) break;
                return true;
            }
            case TextWord: 
            case Text: {
                return e2.getLabel() == null || e2.getLabel().trim().length() == 0;
            }
        }
        return false;
    }

    private class b<E extends a<T>>
    extends Rectangle2D.Double {
        private List<@Nonnull E> fo;
        private int tx;
        private int ty;
        private List<b<E>> children;

        public b(double d2, double d3, double d4, double d5, int n) {
            super(d2, d3, d4, d5);
            this.fo = null;
            this.tx = 0;
            this.ty = 1;
            this.children = null;
            this.ty = n + 1;
        }

        public void a(Rectangle2D rectangle2D, List<@Nonnull E> list, List<@Nonnull E> list2, boolean bl) {
            block8: {
                block7: {
                    if (!this.intersects(rectangle2D)) {
                        return;
                    }
                    if (this.fo == null) break block7;
                    for (a a2 : this.fo) {
                        if (a2.dh()) continue;
                        if (!bl && this.b(a2, rectangle2D)) {
                            list.add(a2);
                        } else if (bl && this.c(a2, rectangle2D)) {
                            list.add(a2);
                        } else {
                            list2.add(a2);
                        }
                        a2.v(true);
                    }
                    break block8;
                }
                if (this.children == null) break block8;
                for (b<a> b2 : this.children) {
                    b2.a(rectangle2D, list, list2, bl);
                }
            }
        }

        public void a(@Nonnull E e2) {
            if (ElementSearch.this.ts && ElementSearch.this.isBogusElement((DrawableElement)((a)e2).dg())) {
                return;
            }
            Rectangle2D rectangle2D = ((a)e2).getBounds();
            if (rectangle2D != null) {
                this.a(e2, rectangle2D);
            }
        }

        private boolean b(@Nonnull E e2) {
            if (!this.c(e2)) {
                return false;
            }
            if (this.children != null) {
                boolean bl = true;
                boolean bl2 = false;
                for (b<E> b2 : this.children) {
                    bl2 |= b2.b(e2);
                    bl &= b2.fo == null && b2.children == null;
                }
                if (bl) {
                    this.children = null;
                }
                return bl2;
            }
            if (this.fo != null) {
                boolean bl = this.fo.remove(e2);
                if (((a)e2).getBounds().contains(this)) {
                    --this.tx;
                }
                if (this.fo.isEmpty()) {
                    this.fo = null;
                    return true;
                }
                return bl;
            }
            return false;
        }

        private void a(@Nonnull E e2, Rectangle2D rectangle2D) {
            if (this.children != null) {
                this.d(e2);
                return;
            }
            if (this.fo == null) {
                this.fo = new ArrayList();
            }
            if (rectangle2D.contains(this)) {
                ++this.tx;
            }
            this.fo.add(e2);
            if (this.fo.size() > ElementSearch.this.tr && this.tx < this.fo.size()) {
                this.di();
            }
        }

        public boolean c(@Nonnull E e2) {
            return this.b(e2, this);
        }

        private boolean b(@Nonnull E e2, Rectangle2D rectangle2D) {
            if (!LocationUtils.intersects(((a)e2).getBounds(), rectangle2D)) {
                return false;
            }
            Object object = ((a)e2).dg();
            if (object instanceof GeomShape) {
                GeomShape geomShape = (GeomShape)object;
                object = geomShape.getShape();
                return object.intersects(rectangle2D);
            }
            return true;
        }

        private boolean c(@Nonnull E e2, Rectangle2D rectangle2D) {
            return LocationUtils.contains(rectangle2D, ((a)e2).getBounds());
        }

        public void di() {
            if (this.ty >= 6) {
                return;
            }
            this.children = new ArrayList<b<E>>();
            double d2 = this.width / 2.0;
            double d3 = this.height / 2.0;
            this.children.add(new b<E>(this.x, this.y, d2, d3, this.ty));
            this.children.add(new b<E>(this.x + d2, this.y, d2, d3, this.ty));
            this.children.add(new b<E>(this.x, this.y + d3, d2, d3, this.ty));
            this.children.add(new b<E>(this.x + d2, this.y + d3, d2, d3, this.ty));
            for (a a2 : this.fo) {
                this.d(a2);
            }
            this.fo = null;
        }

        protected void d(@Nonnull E e2) {
            for (b<E> b2 : this.children) {
                if (!b2.c(e2)) continue;
                b2.a(e2);
            }
        }
    }

    private static class a<@Nonnull T extends DrawableElement> {
        private T element;
        @Nonnull
        private ElementID fZ;
        private Rectangle2D bounds;
        private int mL;
        private boolean tw = false;

        public a(@Nonnull T t) {
            this.element = t;
            this.fZ = ((DrawableElement)t).getElementID();
            this.mL = ((DrawableElement)t).getElementID().hashCode();
            this.bounds = LocationUtils.getNormedBounds(t);
            if (this.bounds != null && (this.bounds.getWidth() == 0.0 || this.bounds.getHeight() == 0.0)) {
                this.bounds = new Rectangle2D.Double(this.bounds.getX() - 0.25, this.bounds.getY() - 0.25, this.bounds.getWidth() + 0.5, this.bounds.getHeight() + 0.5);
            }
        }

        @Nonnull
        public T dg() {
            return this.element;
        }

        public Rectangle2D getBounds() {
            return this.bounds;
        }

        public boolean dh() {
            return this.tw;
        }

        public void v(boolean bl) {
            this.tw = bl;
        }

        public int hashCode() {
            return this.mL;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            return this.fZ.equals(((a)obj).fZ);
        }
    }
}

