/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.util;

import com.inet.annotations.InternalApi;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@InternalApi
public class BitmapArea {
    private List<Shape> list = new ArrayList<Shape>();

    public void add(Shape shape) {
        if (shape == null) {
            return;
        }
        this.list.add(shape);
    }

    public void addAll(Collection<? extends Shape> all) {
        this.list.addAll(all);
    }

    public void fill(Graphics2D g2, Color color) {
        this.a(g2, color, 2, true);
    }

    public void fill(Graphics2D g2, Color color, boolean fast) {
        this.a(g2, color, 2, fast);
    }

    public void drawAllShapes(Graphics2D g2, Color color, boolean fast) {
        this.a(g2, color, 1, fast);
    }

    private void a(Graphics2D graphics2D, Color color, int n, boolean bl) {
        graphics2D.setColor(color);
        if (n == 1) {
            for (Shape shape : this.list) {
                if (shape instanceof Rectangle) {
                    Rectangle rectangle = (Rectangle)shape;
                    graphics2D.drawLine(rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y);
                    graphics2D.drawLine(rectangle.x, rectangle.y + rectangle.height, rectangle.x + rectangle.width, rectangle.y + rectangle.height);
                    continue;
                }
                graphics2D.draw(shape);
            }
        } else if (this.list.size() < 10 || !bl) {
            Area area = new Area();
            for (Shape shape : this.list) {
                area.add(new Area(shape));
            }
            graphics2D.fill(area);
        } else {
            double d2 = Double.MAX_VALUE;
            double d3 = Double.MAX_VALUE;
            double d4 = 0.0;
            double d5 = 0.0;
            for (Shape shape : this.list) {
                Rectangle rectangle = shape.getBounds();
                if (rectangle.getMinX() < d2) {
                    d2 = rectangle.getMinX();
                }
                if (rectangle.getMinY() < d3) {
                    d3 = rectangle.getMinY();
                }
                if (rectangle.getMaxX() > d4) {
                    d4 = rectangle.getMaxX();
                }
                if (!(rectangle.getMaxY() > d5)) continue;
                d5 = rectangle.getMaxY();
            }
            Rectangle rectangle = graphics2D.getClipBounds();
            if (rectangle != null) {
                d2 = Math.max(d2, (double)rectangle.x);
                d3 = Math.max(d3, (double)rectangle.y);
                d4 = Math.min(d4, (double)(rectangle.x + rectangle.width));
                d5 = Math.min(d5, (double)(rectangle.y + rectangle.height));
            }
            int n2 = (int)d2;
            int n3 = (int)d3;
            byte[] byArray = new byte[]{0, (byte)color.getRed()};
            byte[] byArray2 = new byte[]{0, (byte)color.getBlue()};
            byte[] byArray3 = new byte[]{0, (byte)color.getGreen()};
            byte[] byArray4 = new byte[]{0, (byte)color.getAlpha()};
            IndexColorModel indexColorModel = new IndexColorModel(8, 2, byArray, byArray3, byArray2, byArray4);
            int n4 = (int)(d5 - (double)n3 + 1.0);
            int n5 = (int)(d4 - (double)n2 + 1.0);
            if (n4 <= 0 || n5 <= 0) {
                return;
            }
            if (n4 * n5 < 16000000) {
                BufferedImage bufferedImage = new BufferedImage(n5, n4, 12, indexColorModel);
                Graphics2D graphics2D2 = bufferedImage.createGraphics();
                graphics2D2.translate(-n2, -n3);
                for (Shape shape : this.list) {
                    graphics2D2.fill(shape);
                }
                graphics2D.drawImage((Image)bufferedImage, n2, n3, null);
                graphics2D2.dispose();
            } else {
                Area area = new Area();
                for (Shape shape : this.list) {
                    area.add(new Area(shape));
                }
                graphics2D.fill(area);
            }
        }
    }
}

