/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.presenter;

import com.inet.annotations.PublicApi;
import com.inet.lib.io.FastBufferedOutputStream;
import com.inet.pdfc.config.DefaultProfile;
import com.inet.pdfc.config.IProfile;
import com.inet.pdfc.config.PDFCProperty;
import com.inet.pdfc.config.Settings;
import com.inet.pdfc.presenter.BasePresenter;
import com.inet.pdfc.presenter.ExportPresenter;
import com.inet.pdfc.results.ResultModel;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.SuppressFBWarnings;

@PublicApi
@SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="No files are being read")
public abstract class ExportFilePresenter
extends ExportPresenter {
    private int pk = -1;
    private int pl = -1;
    private Boolean pm;
    File s;
    File pn;

    protected void applyPrintRange(HasPrintRange printToX) {
        printToX.setPrintRange(this.pk, this.pl);
    }

    public void setPrintRange(int from, int to) {
        this.pk = from;
        this.pl = to;
    }

    public BasePresenter configure(IProfile configuration) {
        DefaultProfile defaultProfile;
        String string;
        if (configuration instanceof DefaultProfile && (string = (defaultProfile = (DefaultProfile)configuration).getProperties().getProperty(PDFCProperty.EXPORT_PDF_ALWAYS.name())) != null && this.getModel() != null) {
            this.getModel().getSettings().setEnabled(Boolean.valueOf(configuration.getBool(PDFCProperty.EXPORT_PDF_ALWAYS)) == false, Settings.EXPORT.ONLY_ON_DIFFERENCES);
        }
        return this;
    }

    protected OutputStream getExportStream() throws IOException {
        if (!(this.s.exists() || this.s.mkdirs() || this.s.isDirectory())) {
            throw new IOException("Could not create output folder '" + this.s.getAbsolutePath() + "'");
        }
        if (this.pn == null) {
            this.pn = new File(this.s, this.getDefaultExportName("differences") + this.getExtension());
        }
        return new FastBufferedOutputStream((OutputStream)new FileOutputStream(this.pn), 32768);
    }

    protected abstract String getExtension();

    @Override
    public void setModel(ResultModel newModel) {
        super.setModel(newModel);
        if (this.pm != null && newModel != null) {
            newModel.getSettings().setEnabled(this.pm, Settings.EXPORT.ONLY_ON_DIFFERENCES);
        }
    }

    public static interface HasPrintRange {
        public void setPrintRange(int var1, int var2);
    }
}

