/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.plugin.persistence;

import com.inet.annotations.InternalApi;
import com.inet.annotations.JsonData;
import com.inet.cache.MemoryStoreMap;
import com.inet.config.ConfigKey;
import com.inet.config.ConfigValue;
import com.inet.error.PersistenceException;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.pdfc.PDFCCore;
import com.inet.pdfc.config.DefaultProfile;
import com.inet.pdfc.config.PDFCProperty;
import com.inet.pdfc.plugin.PluginManager;
import com.inet.pdfc.plugin.configurations.PreInstalledProfile;
import com.inet.pdfc.plugin.persistence.ComparePersistence;
import com.inet.pdfc.plugin.persistence.PersistenceFactory;
import com.inet.pdfc.plugin.persistence.ProfilePersistence;
import com.inet.pdfc.plugin.persistence.ProfilePersistenceManager;
import com.inet.permissions.AccessDeniedException;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.persistence.Persistence;
import com.inet.persistence.PersistenceListener;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.search.AbstractSearchDataCache;
import com.inet.search.SearchDataCache;
import com.inet.search.SearchDataCacheChangeListener;
import com.inet.search.SearchDataType;
import com.inet.search.SearchResult;
import com.inet.search.SearchResultEntry;
import com.inet.search.SearchTag;
import com.inet.search.command.OrSearchExpression;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchExpression;
import com.inet.search.index.IndexSearchEngine;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.ui.Type;
import com.inet.usersandgroups.api.user.BaseUserManager;
import com.inet.usersandgroups.api.user.BinaryDataKey;
import com.inet.usersandgroups.api.user.UserManager;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import javax.annotation.Nonnull;

@InternalApi
public class ProfilePersistenceManagerImpl
implements ProfilePersistenceManager {
    public static final String PUBLIC_PROFILES_PATH = "persistence/public_profiles.json";
    public static final ConfigKey COMPARE_PROFILES_BLACKLIST = new ConfigKey("compareprofiles.blacklist", "[]", Set.class);
    private static final ConfigValue<Set<String>> nI = new ConfigValue(COMPARE_PROFILES_BLACKLIST);
    public static final BinaryDataKey PROFILES_KEY = new BinaryDataKey("pdfc.profiles", true);
    private static final ProfilePersistence nJ = PreInstalledProfile.getContinuousProfile();
    private List<ProfilePersistenceManager.ProfilePersistenceChangeListener> no = new ArrayList<ProfilePersistenceManager.ProfilePersistenceChangeListener>();
    private IndexSearchEngine<GUID> nK;
    private MemoryStoreMap<GUID, ProfilePersistence> nL;
    private static final GUID nM = UsersAndGroups.GROUPID_ALLUSERS;
    private MemoryStoreMap<GUID, Set<GUID>> nN;
    private b nO = new b();
    private static final com.inet.pdfc.plugin.persistence.a nP = new com.inet.pdfc.plugin.persistence.a("title", SearchDataType.String, false, 2, "search.tag.name", true);
    private static final com.inet.pdfc.plugin.persistence.a nQ = new com.inet.pdfc.plugin.persistence.a("owner.id", SearchDataType.ID, false, 3, "search.tag.owner", true);
    private static final com.inet.pdfc.plugin.persistence.a nR = new com.inet.pdfc.plugin.persistence.a("share.groups", SearchDataType.ID, true, 4, "search.tag.public.groups", false){

        public boolean isPhraseContainsIn(String normalizePhrase, Object val) {
            for (String string : (Collection)val) {
                if (!super.isPhraseContainsIn(normalizePhrase, (Object)string)) continue;
                return true;
            }
            return false;
        }
    };
    private static final com.inet.pdfc.plugin.persistence.a nS = new com.inet.pdfc.plugin.persistence.a("share.users", SearchDataType.ID, true, 5, "search.tag.public.users", false){

        public boolean isPhraseContainsIn(String normalizePhrase, Object val) {
            for (String string : (Collection)val) {
                if (!super.isPhraseContainsIn(normalizePhrase, (Object)string)) continue;
                return true;
            }
            return false;
        }
    };

    public ProfilePersistenceManagerImpl() {
        this.nL = new MemoryStoreMap(3600, true);
        this.nN = new MemoryStoreMap(3600, true);
    }

    public void initIndex() {
        if (this.nK != null) {
            return;
        }
        Persistence.getInstance().registerListener((PersistenceListener)new c());
        this.nK = new IndexSearchEngine("publicprofiles", null, false, GUID.class, true);
        try {
            this.nK.addTag((SearchTag)nP);
            this.nK.addTag((SearchTag)nQ);
            this.nK.addTag((SearchTag)nR);
            this.nK.addTag((SearchTag)nS);
            this.nK.setData((SearchDataCache)this.nO);
            this.nO.addChangeListener((SearchDataCacheChangeListener)new SearchDataCacheChangeListener<GUID>(){

                public void a(@Nonnull GUID gUID, Map<String, Object> map) {
                }

                public void b(@Nonnull GUID gUID, Map<String, Object> map) {
                    ProfilePersistenceManagerImpl.this.nL.remove((Object)gUID);
                }

                public void a(@Nonnull GUID gUID, Map<String, Object> map, Map<String, Object> map2) {
                }

                public void h(@Nonnull GUID gUID) {
                    ProfilePersistenceManagerImpl.this.nL.remove((Object)gUID);
                }

                public /* synthetic */ void entryRemovedCompletely(@Nonnull Object object) {
                    this.h((GUID)object);
                }

                public /* synthetic */ void entryChanged(@Nonnull Object object, Map map, Map map2) {
                    this.a((GUID)object, map, map2);
                }

                public /* synthetic */ void entryRemoved(@Nonnull Object object, Map map) {
                    this.b((GUID)object, map);
                }

                public /* synthetic */ void entryAdded(@Nonnull Object object, Map map) {
                    this.a((GUID)object, map);
                }
            });
        }
        catch (IOException | IllegalStateException exception) {
            PDFCCore.LOGGER_CORE.error((Throwable)exception);
        }
        this.reindex();
    }

    @Override
    public void reindex() {
        try {
            List<ProfilePersistence> list = this.p(true);
            boolean bl = this.u(list);
            if (bl) {
                this.v(list);
            }
            for (ProfilePersistence profilePersistence : list) {
                if (this.getProfile(profilePersistence.getOwnerID(), profilePersistence.getGUID()) != null) continue;
                this.nK.reIndex();
                PDFCCore.LOGGER_CORE.info((Object)"Reindex for profil executed.");
                return;
            }
        }
        catch (IOException iOException) {
            PDFCCore.LOGGER_CORE.error((Throwable)iOException);
        }
    }

    private boolean u(List<ProfilePersistence> list) {
        if (list.isEmpty()) {
            return false;
        }
        String[] stringArray = new String[]{"PAGERANGE_END_DOCUMENT1", "PAGERANGE_END_DOCUMENT2", "PAGERANGE_DOCUMENT1", "PAGERANGE_DOCUMENT2"};
        boolean bl = false;
        for (ProfilePersistence profilePersistence : list) {
            Properties properties = profilePersistence.getProfile().getProperties();
            Iterator<Object> iterator = properties.keySet().iterator();
            while (iterator.hasNext()) {
                String string = iterator.next().toString();
                PDFCProperty<?> pDFCProperty = PDFCProperty.valueOf(string);
                if (pDFCProperty == null) {
                    for (String string2 : stringArray) {
                        if (!string.equals(string2) || !profilePersistence.getProfile().getString(string).isBlank()) continue;
                        iterator.remove();
                        bl = true;
                        break;
                    }
                    if (string.equals("USE_PDF_STRUCTURE") && "true".equals(profilePersistence.getProfile().getString(string))) {
                        iterator.remove();
                        bl = true;
                        continue;
                    }
                    if (!string.equals("NORMALIZATION_LEVEL") || !"1".equals(profilePersistence.getProfile().getString(string))) continue;
                    iterator.remove();
                    bl = true;
                    continue;
                }
                String string3 = profilePersistence.getProfile().getString(pDFCProperty);
                Object object = pDFCProperty.getDefaultValue();
                if (object != null) {
                    object = object.toString();
                }
                if (!Objects.equals(object, string3)) continue;
                iterator.remove();
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public boolean checkProfileName(GUID userID, String newName) throws IOException {
        if (newName == null || newName.isEmpty()) {
            return false;
        }
        for (ProfilePersistence profilePersistence : this.c(userID)) {
            if (!newName.equalsIgnoreCase(profilePersistence.getProfile().getString("PROFIL_NAME"))) continue;
            return false;
        }
        return true;
    }

    private void a(GUID gUID, String string) throws IOException {
        if (!this.checkProfileName(gUID, string)) {
            if (string == null || string.isEmpty()) {
                throw new IllegalArgumentException("Profilename is null or empty.");
            }
            throw new IllegalArgumentException("Profilename is duplicated. Name = " + string);
        }
    }

    @Override
    public ProfilePersistence create(@Nonnull GUID userID, @Nonnull DefaultProfile configuration) throws IOException {
        this.a(userID, configuration.getString("PROFIL_NAME"));
        ProfilePersistence profilePersistence = new ProfilePersistence(GUID.generateNew(), userID, configuration);
        List<ProfilePersistence> list = this.c(userID);
        list.add(profilePersistence);
        this.a(userID, list);
        this.a(profilePersistence, ProfilePersistenceManager.ChangeType.ADDED, true);
        return profilePersistence;
    }

    private void a(ProfilePersistence profilePersistence, ProfilePersistenceManager.ChangeType changeType, boolean bl) {
        if (bl) {
            switch (changeType) {
                case ADDED: {
                    this.nO.c(profilePersistence);
                    break;
                }
                case REMOVED: {
                    this.nO.d(profilePersistence);
                    break;
                }
            }
        }
        for (ProfilePersistenceManager.ProfilePersistenceChangeListener profilePersistenceChangeListener : this.no) {
            profilePersistenceChangeListener.profileChanged(profilePersistence, changeType, bl);
        }
        Persistence.getInstance().sendEvent((Object)new ProfileChangeEvent(profilePersistence.getOwnerID(), profilePersistence.getGUID(), changeType));
    }

    private List<ProfilePersistence> ca() {
        ArrayList<ProfilePersistence> arrayList = new ArrayList<ProfilePersistence>();
        List list = DynamicExtensionManager.getInstance().get(ProfilePersistence.class);
        Set set = (Set)nI.get();
        for (ProfilePersistence profilePersistence : list) {
            if (set.contains(profilePersistence.getGUID().toString())) continue;
            profilePersistence.setScope(ProfilePersistence.SCOPE.DEFAULT);
            arrayList.add(profilePersistence);
        }
        return arrayList;
    }

    private void a(@Nonnull GUID gUID2) {
        Set set = (Set)this.nN.remove((Object)gUID2);
        if (set != null) {
            set.forEach(gUID -> this.nL.remove(gUID));
        }
    }

    private List<ProfilePersistence> p(boolean bl) throws IOException {
        Object object;
        Object object2;
        ArrayList<ProfilePersistence> arrayList = new ArrayList<ProfilePersistence>();
        if (bl) {
            this.a(nM);
        } else {
            object2 = (Set)this.nN.get((Object)nM);
            if (object2 != null) {
                boolean bl2 = true;
                object = object2.iterator();
                while (object.hasNext()) {
                    GUID gUID = (GUID)object.next();
                    ProfilePersistence profilePersistence = (ProfilePersistence)this.nL.get((Object)gUID);
                    if (profilePersistence == null) {
                        bl2 = false;
                        break;
                    }
                    arrayList.add(profilePersistence);
                }
                if (bl2) {
                    return arrayList;
                }
            }
        }
        object2 = Persistence.getInstance().resolve(PUBLIC_PROFILES_PATH).getString();
        if (object2 != null) {
            ProfilePersistence[] profilePersistenceArray = (ProfilePersistence[])new Json().fromJson((String)object2, ProfilePersistence[].class, new HashMap());
            arrayList.addAll(Arrays.asList(profilePersistenceArray));
            object = new HashSet();
            arrayList.forEach(arg_0 -> this.b((Set)object, arg_0));
            this.nN.put((Object)nM, object);
        }
        return arrayList;
    }

    private ProfilePersistence b(@Nonnull GUID gUID) {
        ProfilePersistence profilePersistence = (ProfilePersistence)this.nL.get((Object)gUID);
        if (profilePersistence == null) {
            try {
                this.p(false);
            }
            catch (IOException iOException) {
                PDFCCore.LOGGER_CORE.error((Throwable)iOException);
                return null;
            }
            profilePersistence = (ProfilePersistence)this.nL.get((Object)gUID);
        }
        if (profilePersistence != null && profilePersistence.getScope() != ProfilePersistence.SCOPE.USER) {
            return profilePersistence;
        }
        return null;
    }

    @Nonnull
    private List<ProfilePersistence> c(GUID gUID) {
        ArrayList<ProfilePersistence> arrayList = new ArrayList<ProfilePersistence>();
        if (gUID == null || gUID == BaseUserManager.PRIVILEGED_ACCOUNT_ID) {
            return arrayList;
        }
        HashSet hashSet = (HashSet)this.nN.get((Object)gUID);
        if (hashSet != null) {
            boolean bl = true;
            for (GUID gUID2 : hashSet) {
                ProfilePersistence profilePersistence2 = (ProfilePersistence)this.nL.get((Object)gUID2);
                if (profilePersistence2 == null) {
                    bl = false;
                    break;
                }
                arrayList.add(profilePersistence2);
            }
            if (bl) {
                return arrayList;
            }
        }
        try (InputStream inputStream = UserManager.getInstance().getBinaryData(gUID, PROFILES_KEY);){
            if (inputStream != null) {
                HashSet hashSet2 = new HashSet();
                arrayList.addAll(Arrays.asList((ProfilePersistence[])new Json().fromJson((Reader)new InputStreamReader(inputStream, StandardCharsets.UTF_8), ProfilePersistence[].class, new HashMap())));
                arrayList.forEach(profilePersistence -> {
                    profilePersistence.setScope(ProfilePersistence.SCOPE.USER);
                    profilePersistence.setOwnerID(gUID);
                    this.nL.put((Object)profilePersistence.getGUID(), profilePersistence);
                    hashSet2.add(profilePersistence.getGUID());
                });
                hashSet = hashSet2;
            } else {
                hashSet = new HashSet();
            }
            this.nN.put((Object)gUID, hashSet);
        }
        catch (IOException iOException) {
            PDFCCore.LOGGER_COMPARE.error((Throwable)iOException);
            this.nN.put((Object)gUID, new HashSet());
            UserManager.getInstance().deleteBinaryData(gUID, PROFILES_KEY);
        }
        return arrayList;
    }

    @Override
    public ProfilePersistence getUserProfile(GUID userID, String nameOrId) throws IOException {
        List<ProfilePersistence> list = this.getAllProfiles(userID);
        for (ProfilePersistence profilePersistence : list) {
            PreInstalledProfile preInstalledProfile;
            if (profilePersistence.getName().equalsIgnoreCase(nameOrId)) {
                return profilePersistence;
            }
            if (profilePersistence.getGUID().toString().equals(nameOrId)) {
                return profilePersistence;
            }
            if (!(profilePersistence instanceof PreInstalledProfile) || !(preInstalledProfile = (PreInstalledProfile)profilePersistence).getName(Locale.ENGLISH).equalsIgnoreCase(nameOrId)) continue;
            return profilePersistence;
        }
        return null;
    }

    @Override
    public List<ProfilePersistence> getAllProfiles(GUID userID) throws IOException {
        List<ProfilePersistence> list = CompareProfileComparator.a(this.ca(), this.e(userID), this.c(userID));
        if (list.isEmpty()) {
            list.add(nJ);
        }
        return list;
    }

    @Override
    public ProfilePersistence getProfile(GUID userID, GUID profileID) throws IOException {
        List<ProfilePersistence> list = this.ca();
        for (ProfilePersistence object2 : list) {
            if (!object2.getGUID().equals((Object)profileID)) continue;
            return object2;
        }
        if (userID != null) {
            ProfilePersistence profilePersistence = (ProfilePersistence)this.nL.get((Object)profileID);
            if (profilePersistence != null && userID.equals((Object)profilePersistence.getOwnerID())) {
                return profilePersistence;
            }
            List<ProfilePersistence> list2 = this.c(userID);
            for (Object object : list2) {
                if (!profileID.equals((Object)((ProfilePersistence)object).getGUID())) continue;
                return object;
            }
        }
        boolean bl = false;
        if (this.d(userID)) {
            bl = true;
        } else {
            SearchResult<GUID> searchResult = this.f(userID);
            for (Object object : searchResult.getEntries()) {
                if (!((GUID)object.getId()).equals((Object)profileID)) continue;
                bl = true;
            }
        }
        if (!bl) {
            return null;
        }
        return this.b(profileID);
    }

    private boolean d(GUID gUID) {
        if (gUID == null) {
            return false;
        }
        try {
            Set set = UserGroupManager.getInstance().getGroupsForUser(gUID);
            for (UserGroupInfo userGroupInfo : set) {
                if (!userGroupInfo.getID().equals((Object)UsersAndGroups.GROUPID_ADMIN)) continue;
                return true;
            }
        }
        catch (PersistenceException persistenceException) {
            PDFCCore.LOGGER_CORE.debug((Object)persistenceException);
        }
        return false;
    }

    private List<ProfilePersistence> e(GUID gUID) {
        if (this.d(gUID)) {
            try {
                return this.p(false);
            }
            catch (IOException iOException) {
                PDFCCore.LOGGER_CORE.debug((Object)iOException);
            }
        }
        SearchResult<GUID> searchResult = this.f(gUID);
        ArrayList<ProfilePersistence> arrayList = new ArrayList<ProfilePersistence>();
        for (SearchResultEntry searchResultEntry : searchResult.getEntries()) {
            ProfilePersistence profilePersistence = this.b((GUID)searchResultEntry.getId());
            if (profilePersistence == null) continue;
            arrayList.add(profilePersistence);
        }
        return arrayList;
    }

    @Override
    public boolean isPublishedForUser(GUID profileID, GUID userID) {
        SearchResult<GUID> searchResult = this.f(userID);
        return searchResult.getEntries().stream().filter(searchResultEntry -> profileID.equals(searchResultEntry.getId())).findAny().isPresent();
    }

    private SearchResult<GUID> f(GUID gUID) {
        Set set;
        if (this.nK == null) {
            return new SearchResult(new ArrayList(), false);
        }
        HashSet<GUID> hashSet = new HashSet<GUID>();
        hashSet.add(UsersAndGroups.GROUPID_ALLUSERS);
        OrSearchExpression orSearchExpression = new OrSearchExpression();
        if (gUID != null) {
            set = UserGroupManager.getInstance().getGroupsForUser(gUID);
            set.forEach(userGroupInfo -> hashSet.add(userGroupInfo.getID()));
            orSearchExpression.add((Object)new SearchCondition(nS.getTag(), SearchCondition.SearchTermOperator.Equals, (Object)gUID.toString()));
        }
        orSearchExpression.add((Object)new SearchCondition(nR.getTag(), SearchCondition.SearchTermOperator.IN, hashSet));
        orSearchExpression.add((Object)new SearchCondition(nQ.getTag(), SearchCondition.SearchTermOperator.Equals, (Object)gUID));
        set = this.nK.search(new SearchCommand(new SearchExpression[]{orSearchExpression}));
        return set;
    }

    @Override
    public boolean remove(GUID profileID, GUID userID) throws IOException {
        ProfilePersistence profilePersistence;
        Iterator<ProfilePersistence> iterator;
        this.nL.remove((Object)profileID);
        List<ProfilePersistence> list = this.p(true);
        if (list != null) {
            iterator = list.iterator();
            while (iterator.hasNext()) {
                boolean bl;
                profilePersistence = iterator.next();
                if (!profilePersistence.getGUID().equals((Object)profileID) || !Objects.equals(userID, profilePersistence.getOwnerID()) && !(bl = SystemPermissionChecker.checkAccess((Permission)Permission.valueOf((String)"configuration")))) continue;
                iterator.remove();
                this.v(list);
                this.a(profilePersistence, ProfilePersistenceManager.ChangeType.REMOVED, true);
                return true;
            }
        }
        list = this.c(userID);
        iterator = list.iterator();
        while (iterator.hasNext()) {
            profilePersistence = iterator.next();
            if (!profilePersistence.getGUID().equals((Object)profileID)) continue;
            iterator.remove();
            this.a(userID, list);
            this.a(profilePersistence, ProfilePersistenceManager.ChangeType.REMOVED, false);
            return true;
        }
        return false;
    }

    @Override
    public boolean save(ProfilePersistence profile, GUID userID) throws IOException {
        ProfilePersistence profilePersistence;
        Iterator<ProfilePersistence> iterator;
        this.nL.put((Object)profile.getGUID(), (Object)profile);
        List<ProfilePersistence> list = this.p(true);
        if (list != null) {
            iterator = list.iterator();
            while (iterator.hasNext()) {
                profilePersistence = iterator.next();
                if (!profilePersistence.getGUID().equals((Object)profile.getGUID())) continue;
                iterator.remove();
                list.add(profile);
                this.v(list);
                this.a(profilePersistence, ProfilePersistenceManager.ChangeType.CHANGED, profile.getScope() != ProfilePersistence.SCOPE.USER);
                return true;
            }
        }
        if ((list = this.c(userID)) != null) {
            iterator = list.iterator();
            while (iterator.hasNext()) {
                profilePersistence = iterator.next();
                if (!profilePersistence.getGUID().equals((Object)profile.getGUID())) continue;
                iterator.remove();
                list.add(profile);
                this.a(userID, list);
                this.a(profilePersistence, ProfilePersistenceManager.ChangeType.CHANGED, profile.getScope() != ProfilePersistence.SCOPE.USER);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean publish(GUID profileID, GUID userID, Set<ComparePersistence.UserOrGroup> publishFor) throws IOException {
        if (publishFor != null && !publishFor.isEmpty()) {
            List<ProfilePersistence> list = this.c(userID);
            if (list != null) {
                Iterator<ProfilePersistence> iterator = list.iterator();
                while (iterator.hasNext()) {
                    ProfilePersistence profilePersistence = iterator.next();
                    if (!profilePersistence.getGUID().equals((Object)profileID)) continue;
                    iterator.remove();
                    this.a(userID, list);
                    List<ProfilePersistence> list2 = this.p(true);
                    this.nO.a(profileID, profilePersistence.getPublishing(), publishFor);
                    profilePersistence.setScope(ProfilePersistence.SCOPE.PUBLIC);
                    profilePersistence.setPublishing(publishFor);
                    list2.add(profilePersistence);
                    this.v(list2);
                    this.a(profilePersistence, ProfilePersistenceManager.ChangeType.PUBLISHED, true);
                    return true;
                }
            }
            if ((list = this.p(false)) != null) {
                for (ProfilePersistence profilePersistence : list) {
                    if (!profilePersistence.getGUID().equals((Object)profileID)) continue;
                    this.nO.a(profileID, profilePersistence.getPublishing(), publishFor);
                    profilePersistence.setScope(ProfilePersistence.SCOPE.PUBLIC);
                    profilePersistence.setPublishing(publishFor);
                    this.v(list);
                    this.a(profilePersistence, ProfilePersistenceManager.ChangeType.UNPUBLISHED, true);
                    this.a(profilePersistence, ProfilePersistenceManager.ChangeType.PUBLISHED, true);
                    return true;
                }
            }
        } else {
            List<ProfilePersistence> list = this.p(false);
            if (list != null) {
                GUID gUID = UserManager.getInstance().getCurrentUserAccountID();
                Iterator<ProfilePersistence> iterator = list.iterator();
                while (iterator.hasNext()) {
                    ProfilePersistence profilePersistence = iterator.next();
                    GUID gUID2 = profilePersistence.getOwnerID();
                    if (gUID != null && !gUID.equals((Object)gUID2) && !SystemPermissionChecker.isAdministrator()) {
                        throw new AccessDeniedException("Current user is neither owner of the profile nor administrator");
                    }
                    if (!profilePersistence.getGUID().equals((Object)profileID)) continue;
                    List<ProfilePersistence> list3 = this.c(gUID2);
                    profilePersistence.setScope(ProfilePersistence.SCOPE.USER);
                    this.nO.a(profileID, profilePersistence.getPublishing(), publishFor);
                    profilePersistence.setPublishing(null);
                    list3.add(profilePersistence);
                    this.a(gUID2, list3);
                    iterator.remove();
                    this.v(list);
                    this.a(profilePersistence, ProfilePersistenceManager.ChangeType.UNPUBLISHED, true);
                    return true;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public String duplicate(String guid, GUID userID, String profileName) throws IOException {
        Object object;
        DefaultProfile defaultProfile = null;
        if (guid.startsWith("compare_")) {
            guid = guid.substring(8);
            object = PluginManager.getSingleInstance(PersistenceFactory.class).getPersistence(GUID.valueOf((String)guid));
            if (object != null) {
                defaultProfile = object.getProfile();
            }
        } else {
            object = this.getProfile(userID, GUID.valueOf((String)guid));
            if (object != null) {
                defaultProfile = ((ProfilePersistence)object).getProfile();
            }
        }
        this.a(userID, profileName);
        if (defaultProfile != null) {
            object = GUID.generateNew();
            defaultProfile = new DefaultProfile(defaultProfile);
            defaultProfile.putValue("PROFIL_NAME", profileName);
            defaultProfile.putValue("PROFIL_DESCRIPTION", "");
            ProfilePersistence profilePersistence = new ProfilePersistence((GUID)object, userID, defaultProfile);
            profilePersistence.setMetaProperty("lastmodified", String.valueOf(System.currentTimeMillis()));
            List<ProfilePersistence> list = this.c(userID);
            list.add(profilePersistence);
            this.a(userID, list);
            this.a(profilePersistence, ProfilePersistenceManager.ChangeType.ADDED, true);
            return object.toString();
        }
        return null;
    }

    private void v(List<ProfilePersistence> list) throws IOException {
        this.b(nM, list);
        Persistence.getInstance().resolve(PUBLIC_PROFILES_PATH).setString(new Json().toJson(list));
    }

    private void a(GUID gUID, List<ProfilePersistence> list) throws IOException {
        this.b(gUID, list);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        new Json().toJson(list, (OutputStream)byteArrayOutputStream);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        UserManager.getInstance().storeBinaryData(gUID, PROFILES_KEY, (InputStream)byteArrayInputStream, byArray.length);
    }

    private void b(GUID gUID, List<ProfilePersistence> list) {
        this.a(gUID);
        HashSet hashSet = new HashSet();
        list.forEach(profilePersistence -> {
            hashSet.add(profilePersistence.getGUID());
            this.nL.put((Object)profilePersistence.getGUID(), profilePersistence);
        });
        this.nN.put((Object)gUID, hashSet);
    }

    @Override
    public boolean update(GUID profileID, DefaultProfile sourceProfile, GUID userID) throws IOException {
        ProfilePersistence profilePersistence = this.getUserProfile(userID, profileID.toString());
        if (profilePersistence != null) {
            String string = profilePersistence.getProfile().getString("PROFIL_NAME");
            if (string != null && !string.isEmpty()) {
                sourceProfile.putValue("PROFIL_NAME", string);
            }
            profilePersistence.setProfile(sourceProfile);
        }
        return this.save(profilePersistence, userID);
    }

    @Override
    public boolean rename(GUID profileID, GUID userID, String newName) throws IOException {
        ProfilePersistence profilePersistence = this.getUserProfile(userID, profileID.toString());
        if (profilePersistence == null) {
            return false;
        }
        profilePersistence.getProfile().putValue("PROFIL_NAME", newName);
        return this.save(profilePersistence, userID);
    }

    @Override
    public void addChangeListener(ProfilePersistenceManager.ProfilePersistenceChangeListener listener) {
        this.no.add(listener);
    }

    @Override
    public void removeChangeListener(ProfilePersistenceManager.ProfilePersistenceChangeListener listener) {
        this.no.remove(listener);
    }

    private a a(ProfilePersistence profilePersistence, boolean bl) {
        if (profilePersistence == null) {
            return new a();
        }
        return this.a(bl, profilePersistence.getPublishing());
    }

    private a a(boolean bl, Set<ComparePersistence.UserOrGroup> set) {
        a a2 = new a();
        if (set == null || set.isEmpty()) {
            return a2;
        }
        set.stream().filter(userOrGroup -> userOrGroup.getType() == (bl ? Type.group : Type.user)).forEach(userOrGroup -> a2.add(userOrGroup.getId()));
        return a2;
    }

    private ProfilePersistence a(@Nonnull GUID gUID, @Nonnull GUID gUID2, boolean bl) {
        if (bl) {
            this.a(gUID);
        }
        this.c(gUID);
        return (ProfilePersistence)this.nL.get((Object)gUID2);
    }

    private /* synthetic */ void b(Set set, ProfilePersistence profilePersistence) {
        profilePersistence.setScope(ProfilePersistence.SCOPE.PUBLIC);
        Set<ComparePersistence.UserOrGroup> set2 = profilePersistence.getPublishing();
        if (set2 == null || set2.isEmpty()) {
            set2 = new HashSet<ComparePersistence.UserOrGroup>();
            set2.add(new ComparePersistence.UserOrGroup(Type.group, UsersAndGroups.GROUPID_ALLUSERS));
            profilePersistence.setPublishing(set2);
        }
        this.nL.put((Object)profilePersistence.getGUID(), (Object)profilePersistence);
        set.add(profilePersistence.getGUID());
    }

    static {
        nJ.setScope(ProfilePersistence.SCOPE.DEFAULT);
    }

    private class b
    extends AbstractSearchDataCache<GUID> {
        private b() {
        }

        public Map<String, Object> i(GUID gUID) {
            ProfilePersistence profilePersistence = ProfilePersistenceManagerImpl.this.b(gUID);
            if (profilePersistence == null) {
                return null;
            }
            return this.b(profilePersistence);
        }

        private Map<String, Object> b(ProfilePersistence profilePersistence) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put(nP.getTag(), profilePersistence.getName());
            hashMap.put(nQ.getTag(), profilePersistence.getOwnerID());
            hashMap.put(nR.getTag(), ProfilePersistenceManagerImpl.this.a(profilePersistence, true));
            hashMap.put(nS.getTag(), ProfilePersistenceManagerImpl.this.a(profilePersistence, false));
            return hashMap;
        }

        public Iterator<GUID> iterator() {
            try {
                return ProfilePersistenceManagerImpl.this.p(false).stream().map(ProfilePersistence::getGUID).iterator();
            }
            catch (IOException iOException) {
                PDFCCore.LOGGER_CORE.error((Throwable)iOException);
                return new ArrayList(0).iterator();
            }
        }

        public void c(ProfilePersistence profilePersistence) {
            Map<String, Object> map = this.b(profilePersistence);
            for (SearchDataCacheChangeListener searchDataCacheChangeListener : this.getListeners()) {
                searchDataCacheChangeListener.entryAdded((Object)profilePersistence.getGUID(), map);
            }
        }

        public void d(ProfilePersistence profilePersistence) {
            Map<String, Object> map = this.b(profilePersistence);
            for (SearchDataCacheChangeListener searchDataCacheChangeListener : this.getListeners()) {
                searchDataCacheChangeListener.entryRemoved((Object)profilePersistence.getGUID(), map);
            }
        }

        public void a(GUID gUID, Set<ComparePersistence.UserOrGroup> set, Set<ComparePersistence.UserOrGroup> set2) {
            a a2;
            a a3;
            a a4;
            HashMap<String, a> hashMap = new HashMap<String, a>();
            HashMap<String, a> hashMap2 = new HashMap<String, a>();
            a a5 = ProfilePersistenceManagerImpl.this.a(false, set);
            if (!a5.equals(a4 = ProfilePersistenceManagerImpl.this.a(false, set2))) {
                hashMap.put(nS.getTag(), a5);
                hashMap2.put(nS.getTag(), a4);
            }
            if (!(a3 = ProfilePersistenceManagerImpl.this.a(true, set)).equals(a2 = ProfilePersistenceManagerImpl.this.a(true, set2))) {
                hashMap.put(nR.getTag(), a3);
                hashMap2.put(nR.getTag(), a2);
            }
            if (hashMap.isEmpty() && hashMap2.isEmpty()) {
                return;
            }
            for (SearchDataCacheChangeListener searchDataCacheChangeListener : this.getListeners()) {
                searchDataCacheChangeListener.entryChanged((Object)gUID, hashMap, hashMap2);
            }
        }

        public /* synthetic */ Map getCacheEntry(Object object) {
            return this.i((GUID)object);
        }
    }

    private class c
    implements PersistenceListener<ProfileChangeEvent> {
        private c() {
        }

        public void a(ProfileChangeEvent profileChangeEvent) {
            GUID gUID = profileChangeEvent.userID;
            GUID gUID2 = profileChangeEvent.profileID;
            Set set = (Set)ProfilePersistenceManagerImpl.this.nN.get((Object)gUID);
            ProfilePersistence profilePersistence = (ProfilePersistence)ProfilePersistenceManagerImpl.this.nL.get((Object)gUID2);
            boolean bl = false;
            switch (profileChangeEvent.type) {
                case ADDED: {
                    if (set == null) {
                        return;
                    }
                    profilePersistence = ProfilePersistenceManagerImpl.this.a(gUID, gUID2, true);
                    break;
                }
                case REMOVED: 
                case CHANGED: {
                    if (profilePersistence == null) {
                        return;
                    }
                    if (profilePersistence.getScope() == ProfilePersistence.SCOPE.USER) {
                        profilePersistence = ProfilePersistenceManagerImpl.this.a(gUID, gUID2, true);
                        break;
                    }
                    ProfilePersistenceManagerImpl.this.nL.remove((Object)gUID2);
                    ProfilePersistenceManagerImpl.this.a(nM);
                    bl = true;
                    break;
                }
                case PUBLISHED: {
                    ProfilePersistenceManagerImpl.this.nN.remove((Object)gUID);
                    try {
                        ProfilePersistenceManagerImpl.this.p(true);
                    }
                    catch (IOException iOException) {
                        PDFCCore.LOGGER_CORE.error((Throwable)iOException);
                    }
                    profilePersistence = (ProfilePersistence)ProfilePersistenceManagerImpl.this.nL.get((Object)gUID2);
                    bl = true;
                    break;
                }
                case UNPUBLISHED: {
                    ProfilePersistenceManagerImpl.this.a(nM);
                    if (ProfilePersistenceManagerImpl.this.nN.containsKey((Object)gUID)) {
                        profilePersistence = ProfilePersistenceManagerImpl.this.a(gUID, gUID2, true);
                    }
                    bl = true;
                }
            }
            if (profilePersistence != null) {
                for (ProfilePersistenceManager.ProfilePersistenceChangeListener profilePersistenceChangeListener : ProfilePersistenceManagerImpl.this.no) {
                    profilePersistenceChangeListener.profileChanged(profilePersistence, profileChangeEvent.type, bl);
                }
            }
        }

        public /* synthetic */ void eventReceived(Object object) {
            this.a((ProfileChangeEvent)object);
        }
    }

    @JsonData
    private static class ProfileChangeEvent {
        @Nonnull
        private GUID userID;
        @Nonnull
        private GUID profileID;
        @Nonnull
        private ProfilePersistenceManager.ChangeType type;

        public ProfileChangeEvent() {
        }

        public ProfileChangeEvent(@Nonnull GUID userID, @Nonnull GUID profileID, @Nonnull ProfilePersistenceManager.ChangeType type) {
            this.userID = userID;
            this.profileID = profileID;
            this.type = type;
        }
    }

    @InternalApi
    private static class CompareProfileComparator
    implements Comparator<ProfilePersistence> {
        private CompareProfileComparator() {
        }

        private static List<ProfilePersistence> a(List<ProfilePersistence> list, List<ProfilePersistence> list2, List<ProfilePersistence> list3) {
            ArrayList<ProfilePersistence> arrayList = new ArrayList<ProfilePersistence>();
            arrayList.addAll(list);
            arrayList.addAll(list2);
            arrayList.addAll(list3);
            arrayList.sort(new CompareProfileComparator());
            return arrayList;
        }

        @Override
        public int compare(ProfilePersistence c1, ProfilePersistence c2) {
            ProfilePersistence.SCOPE sCOPE;
            ProfilePersistence.SCOPE sCOPE2 = c1.getScope();
            if (sCOPE2 == ProfilePersistence.SCOPE.USER != ((sCOPE = c2.getScope()) == ProfilePersistence.SCOPE.USER)) {
                return sCOPE2.compareTo(sCOPE);
            }
            if (c1.getScope() != ProfilePersistence.SCOPE.USER) {
                int n;
                int n2;
                int n3;
                int n4;
                String string2;
                boolean bl;
                boolean bl2 = this.a(c1);
                if (bl2 != (bl = this.a(c2))) {
                    return Boolean.compare(bl, bl2);
                }
                String string3 = c1.getProfile().getString(PDFCProperty.CONTINUOUS_COMPARE);
                int n5 = string3.compareTo(string2 = c2.getProfile().getString(PDFCProperty.CONTINUOUS_COMPARE));
                if (n5 != 0) {
                    return n5;
                }
                String string4 = c1.getProfile().getString(PDFCProperty.COMPARE_TYPES);
                String string5 = c2.getProfile().getString(PDFCProperty.COMPARE_TYPES);
                int n6 = string4 == null ? 0 : string4.split("[,;]").length;
                int n7 = n4 = string5 == null ? 0 : string5.split("[,;]").length;
                if (n6 != n4) {
                    return n6 - n4;
                }
                String string6 = c1.getProfile().getString(PDFCProperty.FILTERS);
                String string7 = c2.getProfile().getString(PDFCProperty.FILTERS);
                int n8 = string6 == null ? 0 : string6.split("[,;]").length;
                int n9 = n3 = string7 == null ? 0 : string7.split("[,;]").length;
                if (n8 != n3) {
                    return n8 - n3;
                }
                String string8 = c1.getProfile().getString(PDFCProperty.FILTER_PATTERNS);
                String string9 = c2.getProfile().getString(PDFCProperty.FILTER_PATTERNS);
                int n10 = string8 == null ? 0 : (int)Arrays.asList(string8.split("\r\n")).stream().filter(string -> string.endsWith("active")).count();
                int n11 = n2 = string9 == null ? 0 : (int)Arrays.asList(string9.split("\r\n")).stream().filter(string -> string.endsWith("active")).count();
                if (n10 != n2) {
                    return n10 - n2;
                }
                int n12 = c1.getProfile().getProperties().size();
                if (n12 != (n = c2.getProfile().getProperties().size())) {
                    return n12 - n;
                }
            }
            return c1.getName().compareToIgnoreCase(c2.getName());
        }

        private boolean a(ProfilePersistence profilePersistence) {
            if (profilePersistence.getScope() == ProfilePersistence.SCOPE.USER) {
                return false;
            }
            if (profilePersistence.getScope() == ProfilePersistence.SCOPE.DEFAULT) {
                return true;
            }
            Set<ComparePersistence.UserOrGroup> set = profilePersistence.getPublishing();
            for (ComparePersistence.UserOrGroup userOrGroup : set) {
                if (userOrGroup.getType() != Type.group || !UsersAndGroups.GROUPID_ALLUSERS.equals((Object)userOrGroup.getId())) continue;
                return true;
            }
            return false;
        }
    }

    private static class a
    extends HashSet<GUID> {
        private a() {
        }
    }
}

