/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.plugin.persistence;

import com.inet.annotations.InternalApi;
import com.inet.annotations.JsonData;
import com.inet.pdfc.error.ExceptionData;
import com.inet.pdfc.generator.message.Chunk;
import com.inet.pdfc.generator.message.ErrorData;
import com.inet.pdfc.generator.message.ProgressState;
import com.inet.pdfc.generator.message.State;

@JsonData
@InternalApi
public class CompareState {
    private float progress;
    private State state = State.IDLE;
    private ExceptionData error;
    private transient long startTime = -1L;

    public void setFromProgressState(ProgressState chunk) {
        switch (chunk.getId()) {
            case CANCELED: 
            case CANCELING: 
            case ERROR: 
            case PAUSED: 
            case CLOUDCOMPARE: {
                this.startTime = -1L;
                break;
            }
            case START: {
                this.startTime = chunk.getStartTime();
                break;
            }
            default: {
                this.startTime = chunk.getStartTime();
                this.progress = chunk.calculateProgressValue();
            }
        }
        this.setState(chunk.getId());
    }

    public void setFromErrorData(ErrorData data) {
        this.setState(State.ERROR);
        this.error = data.getError();
    }

    public Chunk toChunk() {
        if (this.state == State.ERROR) {
            return new ErrorData(this.error, 3, true);
        }
        return new ProgressState(this.state, this.progress, this.startTime);
    }

    public float getProgress() {
        return this.progress;
    }

    public State getState() {
        return this.state;
    }

    public ExceptionData getError() {
        return this.error;
    }

    public void setProgress(float progress) {
        this.progress = progress;
    }

    public void setState(State state) {
        this.state = state;
    }

    public void resetError() {
        this.error = null;
    }

    public long getStartTime() {
        return this.startTime;
    }
}

