/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.generator.resultfilter;

import com.inet.annotations.InternalApi;
import com.inet.annotations.JsonData;
import com.inet.pdfc.PDFCCore;
import com.inet.pdfc.config.IProfile;
import com.inet.pdfc.config.PDFCProperty;
import com.inet.pdfc.generator.comparator.ElementComparatorFactory;
import com.inet.pdfc.generator.comparator.IElementComparator;
import com.inet.pdfc.generator.filter.SorterUtils;
import com.inet.pdfc.generator.message.HighlightData;
import com.inet.pdfc.generator.model.CompareDiffGroup;
import com.inet.pdfc.generator.model.DiffGroup;
import com.inet.pdfc.generator.model.IDiffGroupBounds;
import com.inet.pdfc.generator.model.Modification;
import com.inet.pdfc.generator.postcompare.PostComparer;
import com.inet.pdfc.generator.resultfilter.IResultFilter;
import com.inet.pdfc.model.DrawableElement;
import com.inet.pdfc.model.ElementID;
import com.inet.pdfc.model.ElementType;
import com.inet.pdfc.model.PagedElement;
import com.inet.pdfc.util.CollectionUtils;
import com.inet.pdfc.util.ElementSorter;
import com.inet.pdfc.util.LocationUtils;
import com.inet.pdfc.util.Pair;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

@InternalApi
public class LocationMixUpFilter
implements IResultFilter {
    public static final String FILTER_NAME = "SOLVEFALSEREPLACE";
    private static final b iB = new b(true);
    private static final b iC = new b(false);
    private IElementComparator dw;
    private PostComparer ha;
    private boolean iD = false;

    public String getExtensionName() {
        return FILTER_NAME;
    }

    @Override
    public IResultFilter setResultFilterProfile(IProfile profile) {
        String string = profile.getString(PDFCProperty.FILTERS);
        if (string.contains("NO_SOLVEFALSEREPLACE")) {
            this.iD = true;
        } else {
            this.dw = ElementComparatorFactory.createComparator(profile);
            this.ha = new PostComparer(profile);
        }
        return this;
    }

    @Override
    public HighlightData getHighlightProvider() {
        return null;
    }

    @Override
    public List<CompareDiffGroup> filterResult(List<CompareDiffGroup> groups, boolean finalize) {
        if (this.iD || groups == null) {
            return groups;
        }
        if (groups.isEmpty()) {
            return new ArrayList<CompareDiffGroup>();
        }
        List<PhantomBounds> list = this.a(groups, true);
        List<PhantomBounds> list2 = this.a(groups, false);
        Collections.sort(list, ElementSorter.YX_COMPARATOR_PAGED);
        Collections.sort(list2, ElementSorter.YX_COMPARATOR_PAGED);
        HashMap<PagedElement, a> hashMap = new HashMap<PagedElement, a>();
        HashMap<CompareDiffGroup, Pair<List<PagedElement>>> hashMap2 = new HashMap<CompareDiffGroup, Pair<List<PagedElement>>>();
        for (boolean bl : new boolean[]{true, false}) {
            List<PhantomBounds> list3 = bl ? list : list2;
            block4: for (CompareDiffGroup compareDiffGroup : groups) {
                switch (compareDiffGroup.getType()) {
                    case MetadataChanged: 
                    case Modified: 
                    case ValidationError: 
                    case Sync: {
                        continue block4;
                    }
                }
                boolean bl2 = false;
                Iterator<Modification> iterator = compareDiffGroup.getModifications().iterator();
                while (iterator.hasNext()) {
                    Modification modification = iterator.next();
                    List<PagedElement> list4 = modification.getAffectedElements(bl);
                    Iterator<PagedElement> iterator2 = list4.iterator();
                    block6: while (iterator2.hasNext()) {
                        PagedElement pagedElement = iterator2.next();
                        int n = this.a(list3, pagedElement, true);
                        int n2 = Math.min(this.a(list3, pagedElement, false) + 1, list3.size());
                        for (int i = n; i < n2; ++i) {
                            PhantomBounds phantomBounds = list3.get(i);
                            if (phantomBounds.source == compareDiffGroup || !phantomBounds.matches((DrawableElement)pagedElement)) continue;
                            if (bl) {
                                hashMap.put(pagedElement, new a(compareDiffGroup, modification));
                                continue block6;
                            }
                            a a2 = (a)hashMap.get(phantomBounds.element);
                            if (a2 == null || this.c(compareDiffGroup, a2.iA)) continue block6;
                            if (!a2.iE.getAffectedElements(true).remove(phantomBounds.element)) {
                                PDFCCore.LOGGER_COMPARE.error((Object)("Inconsistent diffs on page #" + phantomBounds.element.getPageIndex() + ": " + String.valueOf(phantomBounds.element) + " - " + String.valueOf(pagedElement)));
                                continue block6;
                            }
                            hashMap.remove(phantomBounds.element);
                            if (a2.iE.getAffectedElements(true).isEmpty() && a2.iE.getAffectedElements(false).isEmpty()) {
                                a2.iA.getModifications().remove(a2.iE);
                            }
                            a2.iA.resetCache();
                            iterator2.remove();
                            this.a((PagedElement)phantomBounds.element, pagedElement, compareDiffGroup, hashMap2);
                            bl2 = true;
                            continue block6;
                        }
                    }
                    if (!modification.getAffectedElements(true).isEmpty() || !modification.getAffectedElements(false).isEmpty()) continue;
                    iterator.remove();
                }
                if (!bl2) continue;
                compareDiffGroup.resetCache();
            }
        }
        Object object = groups.iterator();
        while (object.hasNext()) {
            CompareDiffGroup compareDiffGroup = (CompareDiffGroup)object.next();
            if (compareDiffGroup.getType() == DiffGroup.GroupType.Sync) continue;
            if (compareDiffGroup.getAddedElements().size() == 0) {
                if (compareDiffGroup.getRemovedElements().size() == 0) {
                    Pair pair = (Pair)hashMap2.get(compareDiffGroup);
                    if (pair != null && ((List)pair.get(true)).size() == ((List)pair.get(false)).size() && this.a(compareDiffGroup, (List)pair.get(true), (List)pair.get(false))) continue;
                    object.remove();
                }
                if (compareDiffGroup.getType() != DiffGroup.GroupType.Replaced) continue;
                compareDiffGroup.setType(DiffGroup.GroupType.AddedOrRemoved);
                continue;
            }
            if (compareDiffGroup.getRemovedElements().size() != 0 || compareDiffGroup.getType() != DiffGroup.GroupType.Replaced) continue;
            compareDiffGroup.setType(DiffGroup.GroupType.AddedOrRemoved);
        }
        ArrayList<CompareDiffGroup> arrayList = new ArrayList<CompareDiffGroup>(groups.size());
        for (CompareDiffGroup compareDiffGroup : groups) {
            if (compareDiffGroup.getType() == DiffGroup.GroupType.Sync) {
                arrayList.add(compareDiffGroup);
                continue;
            }
            if (this.b(compareDiffGroup, arrayList) || this.a(compareDiffGroup, arrayList)) continue;
            if (compareDiffGroup.getAddedElements().size() == 0) {
                if (compareDiffGroup.getRemovedElements().size() == 0) continue;
                if (compareDiffGroup.getType() == DiffGroup.GroupType.Replaced) {
                    compareDiffGroup.setType(DiffGroup.GroupType.AddedOrRemoved);
                }
            } else if (compareDiffGroup.getRemovedElements().size() == 0 && compareDiffGroup.getType() == DiffGroup.GroupType.Replaced) {
                compareDiffGroup.setType(DiffGroup.GroupType.AddedOrRemoved);
            }
            arrayList.add(compareDiffGroup);
        }
        return arrayList;
    }

    private void a(PagedElement pagedElement, PagedElement pagedElement2, CompareDiffGroup compareDiffGroup, Map<CompareDiffGroup, Pair<List<PagedElement>>> map) {
        Pair<List<PagedElement>> pair = map.get(compareDiffGroup);
        if (pair == null) {
            pair = new Pair(new ArrayList(), new ArrayList());
            map.put(compareDiffGroup, pair);
        }
        pair.get(true).add(pagedElement);
        pair.get(false).add(pagedElement2);
    }

    private boolean a(CompareDiffGroup compareDiffGroup, List<PagedElement> list, List<PagedElement> list2) {
        if (list.size() != list2.size()) {
            return false;
        }
        ArrayList<CompareDiffGroup> arrayList = new ArrayList<CompareDiffGroup>();
        this.ha.a(compareDiffGroup.getBeforeFirst(), compareDiffGroup.getBeforeSecond(), arrayList);
        for (int i = 0; i < list.size(); ++i) {
            PagedElement pagedElement = list.get(i);
            PagedElement object = list2.get(i);
            if (!(pagedElement instanceof DrawableElement) || !(object instanceof DrawableElement)) {
                return false;
            }
            DrawableElement drawableElement = (DrawableElement)pagedElement;
            DrawableElement drawableElement2 = (DrawableElement)object;
            if (!this.dw.isEqual(drawableElement, drawableElement2)) {
                return false;
            }
            this.ha.c(drawableElement, drawableElement2);
        }
        this.ha.b(compareDiffGroup.getAfterFirst(), compareDiffGroup.getAfterSecond());
        if (arrayList.size() > 0) {
            List<Modification> list3 = compareDiffGroup.getModifications();
            list3.clear();
            for (CompareDiffGroup compareDiffGroup2 : arrayList) {
                list3.addAll(compareDiffGroup2.getModifications());
            }
            compareDiffGroup.resetCache();
            compareDiffGroup.setType(((CompareDiffGroup)arrayList.get(0)).getType());
            return true;
        }
        return false;
    }

    private boolean c(DiffGroup diffGroup, DiffGroup diffGroup2) {
        IDiffGroupBounds iDiffGroupBounds = diffGroup.getBoundingElements();
        IDiffGroupBounds iDiffGroupBounds2 = diffGroup2.getBoundingElements();
        return iDiffGroupBounds.getAfterFirst() == iDiffGroupBounds2.getBeforeFirst() && iDiffGroupBounds.getAfterSecond() == iDiffGroupBounds2.getBeforeSecond() && this.d(iDiffGroupBounds.getAfterFirst()) && this.d(iDiffGroupBounds.getAfterSecond()) || iDiffGroupBounds2.getAfterFirst() == iDiffGroupBounds.getBeforeFirst() && iDiffGroupBounds2.getAfterSecond() == iDiffGroupBounds.getBeforeSecond() && this.d(iDiffGroupBounds2.getAfterFirst()) && this.d(iDiffGroupBounds2.getAfterSecond());
    }

    private boolean d(PagedElement pagedElement) {
        return pagedElement != null && (pagedElement.getType() == ElementType.Text || pagedElement.getType() == ElementType.TextWord);
    }

    private int a(List<PhantomBounds> list, PagedElement pagedElement, boolean bl) {
        int n = Collections.binarySearch(list, pagedElement, bl ? iB : iC);
        if (n < 0) {
            return -n - 1;
        }
        return n;
    }

    private List<PhantomBounds> a(List<CompareDiffGroup> list, boolean bl) {
        ArrayList<PhantomBounds> arrayList = new ArrayList<PhantomBounds>();
        block3: for (CompareDiffGroup compareDiffGroup : list) {
            switch (compareDiffGroup.getType()) {
                case MetadataChanged: 
                case Modified: 
                case Sync: {
                    continue block3;
                }
            }
            int n = (bl ? compareDiffGroup.getAddedElements() : compareDiffGroup.getRemovedElements()).size();
            for (int i = 0; i < n; ++i) {
                PhantomBounds phantomBounds = this.a(compareDiffGroup, i, bl, true);
                if (phantomBounds != null) {
                    arrayList.add(phantomBounds);
                }
                if ((phantomBounds = this.a(compareDiffGroup, i, bl, false)) == null) continue;
                arrayList.add(phantomBounds);
            }
        }
        return arrayList;
    }

    private PhantomBounds a(DiffGroup diffGroup, int n, boolean bl, boolean bl2) {
        PagedElement pagedElement;
        PagedElement pagedElement2;
        PagedElement pagedElement3 = (bl ? diffGroup.getAddedElements() : diffGroup.getRemovedElements()).get(n);
        if (!(pagedElement3 instanceof DrawableElement)) {
            return null;
        }
        DrawableElement drawableElement = (DrawableElement)pagedElement3;
        if (bl2) {
            pagedElement2 = bl ? diffGroup.getBoundingElements().getBeforeSecond() : diffGroup.getBoundingElements().getBeforeFirst();
            pagedElement = bl ? diffGroup.getBoundingElements().getBeforeFirst() : diffGroup.getBoundingElements().getBeforeSecond();
        } else {
            pagedElement2 = bl ? diffGroup.getBoundingElements().getAfterSecond() : diffGroup.getBoundingElements().getAfterFirst();
            PagedElement pagedElement4 = pagedElement = bl ? diffGroup.getBoundingElements().getAfterFirst() : diffGroup.getBoundingElements().getAfterSecond();
        }
        if (pagedElement2 == null || pagedElement == null || pagedElement2.getPageIndex() != drawableElement.getPageIndex()) {
            return null;
        }
        int n2 = drawableElement.getPageIndex() - pagedElement2.getPageIndex() + pagedElement.getPageIndex();
        Rectangle rectangle = LocationUtils.getBounds(drawableElement);
        switch (drawableElement.getType()) {
            case LineHorizontal: {
                rectangle.grow(0, Math.min(3, rectangle.width / 2 + 1));
                break;
            }
            case LineVertical: {
                rectangle.grow(Math.min(3, rectangle.width / 2 + 1), 0);
                break;
            }
        }
        Rectangle rectangle2 = LocationUtils.getBounds(pagedElement2);
        Rectangle rectangle3 = LocationUtils.getBounds(pagedElement);
        rectangle.x += rectangle3.x - rectangle2.x;
        rectangle.y += rectangle3.y - rectangle2.y;
        if (rectangle.y < 0 || rectangle.x < 0) {
            return null;
        }
        return new PhantomBounds(diffGroup, drawableElement, rectangle, n2);
    }

    private boolean a(CompareDiffGroup compareDiffGroup, List<CompareDiffGroup> list) {
        Object object;
        boolean bl;
        if (compareDiffGroup.getType() != DiffGroup.GroupType.AddedOrRemoved || compareDiffGroup.getModifications().size() != 2) {
            return false;
        }
        Modification modification = compareDiffGroup.getModifications().get(0);
        Modification modification2 = compareDiffGroup.getModifications().get(1);
        if (!(modification.getModificationType() == Modification.ModificationType.add && modification2.getModificationType() == Modification.ModificationType.remove || modification.getModificationType() == Modification.ModificationType.remove && modification2.getModificationType() == Modification.ModificationType.add)) {
            return false;
        }
        ArrayList<PagedElement> arrayList = compareDiffGroup.getAddedElements();
        List<PagedElement> list2 = compareDiffGroup.getRemovedElements();
        if (arrayList.size() != 1 && list2.size() != 1 || list2.size() == arrayList.size()) {
            return false;
        }
        boolean bl2 = bl = arrayList.size() > 1;
        if (!bl) {
            object = list2;
            list2 = arrayList;
            arrayList = object;
        }
        if (arrayList.size() < 3) {
            return false;
        }
        object = arrayList.get(0);
        if (!(this.f((PagedElement)object) && this.f(arrayList.get(arrayList.size() - 1)) && this.f(list2.get(0)))) {
            return false;
        }
        PagedElement pagedElement = compareDiffGroup.getBeforeFirst();
        if (this.g(pagedElement, (PagedElement)(bl ? list2.get(0) : object)) && pagedElement != null && !".".equals(pagedElement.getLabel())) {
            return false;
        }
        PagedElement pagedElement2 = compareDiffGroup.getBeforeFirst();
        if (this.g(pagedElement2, (PagedElement)(bl ? object : list2.get(0))) && pagedElement2 != null && !".".equals(pagedElement2.getLabel())) {
            return false;
        }
        if (!this.g((PagedElement)object, arrayList.get(1)) || this.g((PagedElement)object, arrayList.get(arrayList.size() - 1))) {
            return false;
        }
        PagedElement pagedElement3 = arrayList.get(arrayList.size() - 1);
        arrayList = new ArrayList<PagedElement>(arrayList.subList(0, arrayList.size() - 2));
        ArrayList<PagedElement> arrayList2 = bl ? new ArrayList<PagedElement>() : arrayList;
        ArrayList<PagedElement> arrayList3 = bl ? arrayList : new ArrayList<PagedElement>();
        PagedElement pagedElement4 = compareDiffGroup.getBeforeFirst();
        PagedElement pagedElement5 = compareDiffGroup.getBeforeSecond();
        PagedElement pagedElement6 = bl ? list2.get(0) : pagedElement3;
        PagedElement pagedElement7 = bl ? pagedElement3 : list2.get(0);
        CompareDiffGroup compareDiffGroup2 = new CompareDiffGroup(arrayList2, arrayList3, pagedElement4, pagedElement5, pagedElement6, pagedElement7, DiffGroup.GroupType.AddedOrRemoved);
        arrayList2 = bl ? new ArrayList<PagedElement>(list2) : this.a(pagedElement3);
        arrayList3 = bl ? this.a(pagedElement3) : new ArrayList<PagedElement>(list2);
        pagedElement4 = bl ? compareDiffGroup.getBeforeFirst() : (PagedElement)arrayList.get(arrayList.size() - 1);
        pagedElement5 = bl ? (PagedElement)arrayList.get(arrayList.size() - 1) : compareDiffGroup.getBeforeSecond();
        pagedElement6 = compareDiffGroup.getAfterFirst();
        pagedElement7 = compareDiffGroup.getAfterSecond();
        CompareDiffGroup compareDiffGroup3 = new CompareDiffGroup(arrayList2, arrayList3, pagedElement4, pagedElement5, pagedElement6, pagedElement7, DiffGroup.GroupType.Replaced);
        list.add(compareDiffGroup2);
        list.add(compareDiffGroup3);
        return true;
    }

    private boolean g(PagedElement pagedElement, PagedElement pagedElement2) {
        return pagedElement != null && pagedElement2 != null && pagedElement.getPageIndex() == pagedElement2.getPageIndex() && pagedElement.getBounds().getY() == pagedElement2.getBounds().getY();
    }

    private boolean b(CompareDiffGroup compareDiffGroup, List<CompareDiffGroup> list) {
        PagedElement pagedElement;
        if (compareDiffGroup.getType() != DiffGroup.GroupType.AddedOrRemoved || compareDiffGroup.getModifications().size() != 1) {
            return false;
        }
        Modification modification = compareDiffGroup.getModifications().get(0);
        boolean bl = modification.getModificationType() == Modification.ModificationType.add;
        ArrayList<PagedElement> arrayList = modification.getAffectedElements(!bl);
        PagedElement pagedElement2 = bl ? compareDiffGroup.getBeforeSecond() : compareDiffGroup.getBeforeFirst();
        PagedElement pagedElement3 = pagedElement = bl ? compareDiffGroup.getAfterSecond() : compareDiffGroup.getAfterFirst();
        if (arrayList.size() < 4 || pagedElement2 == null || pagedElement == null) {
            return false;
        }
        PagedElement pagedElement4 = arrayList.get(0);
        PagedElement pagedElement5 = arrayList.get(arrayList.size() - 1);
        if (!this.g(pagedElement4, pagedElement2) || !this.g(pagedElement5, pagedElement)) {
            return false;
        }
        if (this.g(pagedElement4, pagedElement5)) {
            return false;
        }
        if (!this.f(pagedElement2) || !this.f(pagedElement5)) {
            return false;
        }
        arrayList.add(0, pagedElement2);
        arrayList.remove(arrayList.size() - 1);
        List<PagedElement> list2 = bl ? new ArrayList<PagedElement>() : arrayList;
        List<PagedElement> list3 = bl ? arrayList : new ArrayList<PagedElement>();
        PagedElement pagedElement6 = this.e(compareDiffGroup.getBeforeFirst());
        PagedElement pagedElement7 = this.e(compareDiffGroup.getBeforeSecond());
        PagedElement pagedElement8 = bl ? compareDiffGroup.getBeforeFirst() : pagedElement5;
        PagedElement pagedElement9 = bl ? pagedElement5 : compareDiffGroup.getBeforeSecond();
        CompareDiffGroup compareDiffGroup2 = new CompareDiffGroup(list2, list3, pagedElement6, pagedElement7, pagedElement8, pagedElement9, DiffGroup.GroupType.AddedOrRemoved);
        list2 = bl ? this.a(compareDiffGroup.getBeforeFirst()) : this.a(pagedElement5);
        list3 = bl ? this.a(pagedElement5) : this.a(compareDiffGroup.getBeforeSecond());
        pagedElement6 = bl ? pagedElement6 : (PagedElement)arrayList.get(arrayList.size() - 1);
        pagedElement7 = bl ? (PagedElement)arrayList.get(arrayList.size() - 1) : pagedElement7;
        pagedElement8 = compareDiffGroup.getAfterFirst();
        pagedElement9 = compareDiffGroup.getAfterSecond();
        CompareDiffGroup compareDiffGroup3 = new CompareDiffGroup(list2, list3, pagedElement6, pagedElement7, pagedElement8, pagedElement9, DiffGroup.GroupType.Replaced);
        list.add(compareDiffGroup2);
        list.add(compareDiffGroup3);
        return true;
    }

    private List<PagedElement> a(PagedElement ... pagedElementArray) {
        return CollectionUtils.toList(pagedElementArray);
    }

    private PagedElement e(PagedElement pagedElement) {
        Rectangle2D rectangle2D = pagedElement.getBounds();
        ElementID elementID = pagedElement instanceof DrawableElement ? ((DrawableElement)pagedElement).getElementID().getDescendant() : new ElementID(false, pagedElement.getPageIndex(), (int)rectangle2D.getX(), (int)rectangle2D.getY());
        return new SorterUtils.DummyDrawabale(rectangle2D.getX(), Math.min(rectangle2D.getMinY(), rectangle2D.getMaxY()) - Math.abs(rectangle2D.getHeight()) / 2.0, pagedElement.getPageIndex(), elementID);
    }

    private boolean f(PagedElement pagedElement) {
        if (pagedElement.getType() != ElementType.TextWord) {
            return false;
        }
        String string = pagedElement.getLabel();
        if (string.length() == 0) {
            return false;
        }
        boolean bl = false;
        block4: for (int i = 0; i < string.length(); ++i) {
            switch (string.charAt(i)) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    bl = true;
                    continue block4;
                }
                case '.': {
                    continue block4;
                }
                default: {
                    return false;
                }
            }
        }
        return bl;
    }

    @JsonData
    private class PhantomBounds
    extends DrawableElement {
        private Rectangle bounds;
        private int pageNr;
        private DiffGroup source;
        private DrawableElement element;

        public PhantomBounds(DiffGroup source, DrawableElement element, Rectangle bounds, int pageNr) {
            super(pageNr, element.getElementID().getDescendant());
            this.source = source;
            this.element = element;
            this.bounds = bounds;
            this.pageNr = pageNr;
        }

        public boolean matches(DrawableElement element) {
            if (element.getType() != this.element.getType()) {
                return false;
            }
            if (this.check(element, this.bounds, this.pageNr)) {
                return LocationMixUpFilter.this.dw.isEqual(element, this.element);
            }
            return false;
        }

        private boolean check(DrawableElement element, Rectangle bounds, int page) {
            if (bounds == null || element.getPageIndex() != page) {
                return false;
            }
            Rectangle rectangle = LocationUtils.getBounds(element);
            if (bounds.intersects(rectangle)) {
                Rectangle2D rectangle2D = bounds.createIntersection(rectangle);
                if (rectangle2D.getWidth() < rectangle.getWidth() * 2.0 / 3.0) {
                    return false;
                }
                if (rectangle2D.getHeight() > rectangle.getHeight() * 2.0 / 3.0) {
                    return true;
                }
                if (element.getType() == ElementType.TextWord && rectangle2D.getHeight() > rectangle.getHeight() / 3.0) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public Rectangle2D getBounds() {
            return this.bounds;
        }

        @Override
        public int getPageIndex() {
            return this.pageNr;
        }

        @Override
        public ElementType getType() {
            return this.element.getType();
        }

        @Override
        public String getLabel() {
            return this.element.getLabel();
        }

        @Override
        public void setX(double x) {
        }

        @Override
        public void setY(double y) {
        }

        @Override
        public double getX() {
            return this.bounds.getX();
        }

        @Override
        public double getY() {
            return this.bounds.getY();
        }

        @Override
        public int getCompareHash() {
            return this.element.getCompareHash();
        }
    }

    private static class a {
        private CompareDiffGroup iA;
        private Modification iE;

        public a(CompareDiffGroup compareDiffGroup, Modification modification) {
            this.iA = compareDiffGroup;
            this.iE = modification;
        }
    }

    private static class b
    implements Comparator<PagedElement> {
        private boolean iF;

        public b(boolean bl) {
            this.iF = bl;
        }

        public int h(PagedElement pagedElement, PagedElement pagedElement2) {
            if (pagedElement.getPageIndex() != pagedElement2.getPageIndex()) {
                return pagedElement.getPageIndex() - pagedElement2.getPageIndex();
            }
            Rectangle rectangle = LocationUtils.getBounds(pagedElement);
            Rectangle rectangle2 = LocationUtils.getBounds(pagedElement2);
            double d2 = this.iF ? rectangle.getMaxX() : rectangle.getMinX();
            double d3 = this.iF ? rectangle.getMaxY() : rectangle.getMinY();
            double d4 = this.iF ? rectangle2.getMinX() : rectangle2.getMaxX();
            double d5 = this.iF ? rectangle2.getMinY() : rectangle2.getMaxY();
            int n = Double.compare(d3, d5);
            if (n == 0) {
                int n2 = Double.compare(d2, d4);
                if (n2 == 0) {
                    return 0;
                }
                return n2;
            }
            return n;
        }

        @Override
        public /* synthetic */ int compare(Object object, Object object2) {
            return this.h((PagedElement)object, (PagedElement)object2);
        }
    }
}

