/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.generator.filter.line;

import com.inet.annotations.InternalApi;
import com.inet.pdfc.PDFCCore;
import com.inet.pdfc.generator.filter.SortFilterBase;
import com.inet.pdfc.generator.model.CompareDiffGroup;
import com.inet.pdfc.generator.model.forms.LineShape;
import com.inet.pdfc.generator.model.forms.LineShapeSegmented;
import com.inet.pdfc.generator.model.forms.TwoSidedPaint;
import com.inet.pdfc.generator.postcompare.PaintComparator;
import com.inet.pdfc.model.DrawableElement;
import com.inet.pdfc.util.ElementSearch;
import com.inet.pdfc.util.ElementSorter;
import com.inet.pdfc.util.LocationUtils;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

@InternalApi
public class LineCombineSorter
extends SortFilterBase {
    private boolean fA = false;
    private double fB = 0.05;
    private double fC = 0.95;
    private boolean fD = false;
    private boolean fE = false;

    public LineCombineSorter() {
        super("linecombine ");
    }

    public LineCombineSorter setIgnoreStyles(boolean ignoreStyles) {
        this.fA = ignoreStyles;
        return this;
    }

    public LineCombineSorter setNormalizeDirection(boolean normalizeDirection) {
        this.fE = normalizeDirection;
        return this;
    }

    public LineCombineSorter setToleranceDistance(double toleranceDistance) {
        this.fC = toleranceDistance;
        return this;
    }

    public LineCombineSorter setToleranceLateral(double toleranceLateral) {
        this.fB = toleranceLateral;
        return this;
    }

    public LineCombineSorter setCombineFilledShapes(boolean combine) {
        this.fD = combine;
        return this;
    }

    @Override
    public List<@Nonnull DrawableElement> sortOrFilterPage(int pageNr, List<@Nonnull DrawableElement> pageElements, boolean first, List<CompareDiffGroup> diffGroups) {
        List list;
        if (pageElements.size() == 0) {
            return pageElements;
        }
        @Nonnull Rectangle rectangle = this.getAnalyzedPagesCount(first) > pageNr ? new Rectangle(this.getPageSize(pageNr, first)) : ((list = LocationUtils.getJoinedBounds(pageElements)) != null ? ((RectangularShape)((Object)list)).getBounds() : new Rectangle(1000, 1000));
        list = pageElements.stream().filter(drawableElement -> drawableElement instanceof LineShape).map(drawableElement -> (LineShape)drawableElement).filter(LineCombineSorter::b).collect(Collectors.toList());
        if (list.size() == 0) {
            return pageElements;
        }
        Collections.sort(list, ElementSorter.YX_COMPARATOR);
        @Nonnull List<@Nonnull DrawableElement> list2 = this.a(list, rectangle);
        if (list2.equals(list)) {
            return pageElements;
        }
        ArrayList<@Nonnull DrawableElement> arrayList = new ArrayList<DrawableElement>(pageElements.size());
        for (DrawableElement drawableElement2 : pageElements) {
            if (drawableElement2 instanceof LineShape) continue;
            arrayList.add(drawableElement2);
        }
        for (DrawableElement drawableElement2 : list2) {
            if (drawableElement2 instanceof LineShapeSegmented) {
                Object object;
                LineShapeSegmented lineShapeSegmented = (LineShapeSegmented)drawableElement2;
                if (this.fA) {
                    object = new LineShape(lineShapeSegmented.getLine(), lineShapeSegmented.getStrokePaint(), lineShapeSegmented.getFillPaint(), lineShapeSegmented.getStroke(), pageNr, lineShapeSegmented.getSegments().get(0).getSource(), lineShapeSegmented.getElementID());
                    if (this.fD && this.a((LineShape)object)) continue;
                    if (this.fE) {
                        ((LineShape)object).normalizeDirection();
                    }
                    arrayList.add((DrawableElement)object);
                    continue;
                }
                object = lineShapeSegmented.toLines();
                if (this.fD || this.fE) {
                    Iterator<LineShape> iterator = object.iterator();
                    while (iterator.hasNext()) {
                        LineShape lineShape = iterator.next();
                        if (this.fE) {
                            lineShape.normalizeDirection();
                        }
                        if (this.fD && this.a(lineShape)) continue;
                        arrayList.add(lineShape);
                    }
                    continue;
                }
                arrayList.addAll((Collection<DrawableElement>)object);
                continue;
            }
            arrayList.add(drawableElement2);
        }
        Collections.sort(arrayList, ElementSorter.YX_COMPARATOR);
        return arrayList;
    }

    private boolean a(LineShape lineShape) {
        if (lineShape.getStroke() != null && lineShape.getStroke() != null) {
            return false;
        }
        Paint paint = lineShape.getFillPaint();
        if (paint == null) {
            return true;
        }
        if (!(paint instanceof TwoSidedPaint)) {
            return false;
        }
        TwoSidedPaint twoSidedPaint = (TwoSidedPaint)paint;
        Paint paint2 = twoSidedPaint.getPaint(true);
        Paint paint3 = twoSidedPaint.getPaint(false);
        return PaintComparator.DEFAULT.isEqual(paint2, paint3);
    }

    private static boolean b(LineShape lineShape) {
        return lineShape.getLine().getX1() != lineShape.getLine().getX2() || lineShape.getLine().getY1() != lineShape.getLine().getY2();
    }

    @Nonnull
    private @Nonnull List<@Nonnull DrawableElement> a(List<@Nonnull LineShape> list, @Nonnull Rectangle2D rectangle2D) {
        if (list.size() == 0) {
            return new ArrayList<DrawableElement>();
        }
        ElementSearch<@Nonnull LineShape> elementSearch = new ElementSearch<LineShape>(rectangle2D);
        elementSearch.setSearchAreaTolerance(Math.max(this.fC, this.fB));
        boolean bl = false;
        for (LineShape lineShape : list) {
            List<@Nonnull T> list2 = elementSearch.getElementsInArea(LocationUtils.getNormedBounds(lineShape));
            LineShape lineShape2 = null;
            for (LineShape lineShape3 : list2) {
                boolean bl2;
                double d2;
                if (!lineShape3.canMerge(lineShape, d2 = this.a(lineShape, lineShape3), this.fC)) continue;
                boolean bl3 = lineShape3 instanceof LineShapeSegmented;
                if (!elementSearch.remove(lineShape3)) {
                    if (!bl && PDFCCore.LOGGER_CORE.isDebug()) {
                        PDFCCore.LOGGER_CORE.debug((Object)("Inconsistent line merge. Line candidate '" + String.valueOf(lineShape3) + "' is missing in search scope."));
                    }
                    bl = true;
                }
                if (lineShape2 == null) {
                    boolean bl4 = bl2 = lineShape3.getLineLength() >= lineShape.getLineLength();
                    if (bl2 || lineShape3.isParallel(lineShape)) {
                        lineShape2 = bl3 ? (LineShapeSegmented)lineShape3 : lineShape3.toSegmented();
                        ((LineShapeSegmented)lineShape2).add(lineShape);
                        continue;
                    }
                    lineShape2 = lineShape.toSegmented();
                    ((LineShapeSegmented)lineShape2).add(lineShape3);
                    continue;
                }
                boolean bl5 = bl2 = lineShape2.getLineLength() >= lineShape3.getLineLength();
                if (bl2 || lineShape2.isParallel(lineShape3)) {
                    ((LineShapeSegmented)lineShape2).add(lineShape3);
                    continue;
                }
                LineShapeSegmented lineShapeSegmented = bl3 ? (LineShapeSegmented)lineShape3 : lineShape3.toSegmented();
                lineShapeSegmented.add(lineShape2);
            }
            if (lineShape2 != null) {
                elementSearch.add(lineShape2);
                continue;
            }
            elementSearch.add(lineShape);
        }
        return elementSearch.getElementsInAreaAsList(rectangle2D, true);
    }

    private double a(LineShape lineShape, LineShape lineShape2) {
        double d2 = this.fB;
        if (lineShape.getStroke() != null && lineShape.getStrokePaint() != null) {
            d2 = Math.max(d2, (double)(lineShape.getStroke().getLineWidth() / 2.0f) + 0.05);
        }
        if (lineShape2.getStroke() != null && lineShape2.getStrokePaint() != null) {
            d2 = Math.max(d2, (double)(lineShape2.getStroke().getLineWidth() / 2.0f) + 0.05);
        }
        return d2;
    }
}

