/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.generator;

import com.inet.annotations.InternalApi;
import com.inet.logging.Logger;
import com.inet.pdfc.PDFCCore;
import com.inet.pdfc.config.IProfile;
import com.inet.pdfc.config.PDFCProperty;
import com.inet.pdfc.config.PdfSource;
import com.inet.pdfc.config.SettingUtil;
import com.inet.pdfc.config.SourceMetaAccessor;
import com.inet.pdfc.error.ExceptionDataFactory;
import com.inet.pdfc.error.PdfcException;
import com.inet.pdfc.generator.ComparatorProperties;
import com.inet.pdfc.generator.DataGeneratorListener;
import com.inet.pdfc.generator.InvalidLicenseException;
import com.inet.pdfc.generator.PDFParserTask;
import com.inet.pdfc.generator.analysis.DocumentPreAnalyze;
import com.inet.pdfc.generator.analysis.DocumentPreAnalyzeFactory;
import com.inet.pdfc.generator.analysis.FeatureKey;
import com.inet.pdfc.generator.b;
import com.inet.pdfc.generator.d;
import com.inet.pdfc.generator.e;
import com.inet.pdfc.generator.f;
import com.inet.pdfc.generator.message.Chunk;
import com.inet.pdfc.generator.message.ErrorData;
import com.inet.pdfc.generator.message.InfoData;
import com.inet.pdfc.generator.message.ProgressState;
import com.inet.pdfc.generator.message.State;
import com.inet.pdfc.generator.model.CompareDiffGroup;
import com.inet.pdfc.generator.rendercache.PdfcRenderCache;
import com.inet.pdfc.i18n.Msg;
import com.inet.pdfc.model.Document;
import com.inet.pdfc.model.DrawableElement;
import com.inet.pdfc.model.EnumerationProgress;
import com.inet.pdfc.model.Page;
import com.inet.pdfc.plugin.DocumentReader;
import com.inet.pdfc.plugin.PluginManager;
import com.inet.pdfc.plugin.interfaces.DocumentFactory;
import com.inet.pdfc.presenter.BasePresenter;
import com.inet.pdfc.thread.PdfcSession;
import com.inet.pdfc.util.FilterUtils;
import com.inet.thread.RunnableSession;
import com.inet.thread.ThreadPool;
import com.inet.thread.ThreadUtils;
import com.inet.thread.job.StoppableCallable;
import com.inet.thread.job.TerminatedByPausing;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

@InternalApi
public abstract class AbstractComparator {
    static final Logger LOGGER = PDFCCore.LOGGER_COMPARE;
    private final IProfile profile;
    private PDFParserTask bg;
    private PDFParserTask bh;
    private com.inet.pdfc.generator.a bi;
    private ComparatorProperties bj = new ComparatorProperties();
    private Document bk;
    private Document bl;
    private BasePresenter.ERROR_SOURCE bm = BasePresenter.ERROR_SOURCE.PREPARE;
    private PdfcSession bn;
    private long bo;
    private ThreadPool.Work<Void> bp;
    private ThreadPool.Work<Void> bq;
    private DataGeneratorListener br;
    private f bs;
    private PdfcRenderCache bt;
    private b bu;
    private boolean bv = false;
    private Object bw = new Object();
    public static final String NO_CMAP_FILTER_KEY = "NOCMAP";
    private float bx = 0.0f;
    private float by = 0.0f;

    protected AbstractComparator(IProfile profile) {
        this.profile = profile;
    }

    protected IProfile getProfile() {
        return this.profile;
    }

    public void setProperties(ComparatorProperties properties) {
        this.bj = properties != null ? properties : new ComparatorProperties();
    }

    protected abstract b createComparer(DataGeneratorListener var1, e var2, PdfcRenderCache var3);

    protected abstract void reInitComparer(d<Page> var1, DataGeneratorListener var2, e var3, PdfcRenderCache var4) throws ClassNotFoundException, IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void S() throws Exception {
        boolean bl = false;
        try {
            ThreadUtils.checkInterruption();
            try {
                this.bi.U();
            }
            finally {
                this.bm = BasePresenter.ERROR_SOURCE.FIRST_PDF;
                this.bp.get();
                this.bm = BasePresenter.ERROR_SOURCE.SECOND_PDF;
                this.bq.get();
            }
            LOGGER.info((Object)Msg.getMsg("Status.finished", Long.toString(System.currentTimeMillis() - this.bo)));
            this.T();
            bl = true;
            this.br.addData(new ProgressState(State.FINISHED));
        }
        catch (InvalidLicenseException invalidLicenseException) {
            this.br.addData(new ErrorData(ExceptionDataFactory.createExceptionData(invalidLicenseException), this.bm.ordinal(), true));
            throw invalidLicenseException;
        }
        catch (InterruptedException | CancellationException exception) {
            LOGGER.info((Object)Msg.getMsg("Status.canceled"));
            this.T();
            bl = true;
            this.br.addData(new ProgressState(State.CANCELED));
        }
        catch (TerminatedByPausing terminatedByPausing) {
            LOGGER.debug((Object)terminatedByPausing);
            throw terminatedByPausing;
        }
        catch (Error | Exception throwable) {
            this.bs.setState(State.CANCELING);
            this.bs.addData(new ProgressState(State.CANCELING));
            StoppableCallable.CallableState callableState = this.bg.stop();
            PDFCCore.LOGGER_COMPARE.debug((Object)("Parser1 thread ended, state is " + String.valueOf(callableState)));
            StoppableCallable.CallableState callableState2 = this.bh.stop();
            PDFCCore.LOGGER_COMPARE.debug((Object)("Parser2 thread ended, state is  " + String.valueOf(callableState2)));
            throw throwable;
        }
        finally {
            if (!bl) {
                this.T();
            }
            Object object = this.bw;
            synchronized (object) {
                this.bv = true;
                this.bw.notifyAll();
            }
        }
    }

    private void T() {
        try {
            if (this.bk != null) {
                this.bk.close();
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            if (this.bl != null) {
                this.bl.close();
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public BasePresenter.ERROR_SOURCE getErrorSource() {
        return this.bm;
    }

    private void a(final PdfSource pdfSource, PdfSource pdfSource2, DataGeneratorListener dataGeneratorListener) throws IOException, InvalidLicenseException, PdfcException {
        this.bn = PdfcSession.getSession();
        Properties properties = this.bn.getSessionProperties();
        properties.put("First file name", pdfSource.getName());
        properties.put("Second file name", pdfSource2.getName());
        properties.put("document.first.file", pdfSource);
        properties.put("document.second.file", pdfSource2);
        this.bn.setSessionProperties(properties);
        PDFParserTask.checkLicense(true, !b.ae() && !b.af(), false, b.ae());
        this.bt = this.bn.getStoreMap();
        this.bo = System.currentTimeMillis();
        dataGeneratorListener.addData(new ProgressState(State.START, 0.0f, this.bo));
        InfoData infoData = new InfoData(pdfSource, pdfSource2, this.profile);
        dataGeneratorListener.addData(infoData);
        String string = pdfSource.getPath() != null ? pdfSource.getPath() : pdfSource.getName();
        String string2 = pdfSource2.getPath() != null ? pdfSource2.getPath() : pdfSource2.getName();
        LOGGER.info((Object)Msg.getMsg("Status.Scanning", string));
        this.bm = BasePresenter.ERROR_SOURCE.FIRST_PDF;
        boolean bl = this.profile.getString(PDFCProperty.FILTERS).contains(NO_CMAP_FILTER_KEY);
        DocumentFactory.FEATURE[] fEATUREArray = DocumentFactory.FEATURE.values();
        if (!SettingUtil.isParseStructure(this.profile)) {
            fEATUREArray = Arrays.asList(fEATUREArray).stream().filter(fEATURE -> fEATURE != DocumentFactory.FEATURE.structure).collect(Collectors.toList()).toArray(new DocumentFactory.FEATURE[0]);
        }
        if (!bl) {
            fEATUREArray = Arrays.asList(fEATUREArray).stream().filter(fEATURE -> fEATURE != DocumentFactory.FEATURE.textNoCharMapping).collect(Collectors.toList()).toArray(new DocumentFactory.FEATURE[0]);
        }
        this.bk = DocumentReader.getInstance().readDocumentReduced(pdfSource, fEATUREArray);
        this.bk.setProfile(this.profile);
        LOGGER.info((Object)Msg.getMsg("Status.Scanning", string2));
        try {
            this.bm = BasePresenter.ERROR_SOURCE.SECOND_PDF;
            this.bl = DocumentReader.getInstance().readDocumentReduced(pdfSource2, fEATUREArray);
            this.bl.setProfile(this.profile);
        }
        catch (PdfcException pdfcException) {
            this.bk.close();
            throw pdfcException;
        }
        this.bm = BasePresenter.ERROR_SOURCE.PREPARE;
        this.bs = new f(dataGeneratorListener);
        this.bu = this.createComparer(dataGeneratorListener, this.bs, this.bt);
        this.bu.a(this.bj);
        List<DocumentPreAnalyze> list = this.a(this.profile, this.bu.ab());
        if (!list.isEmpty()) {
            PdfcRenderCache pdfcRenderCache = this.bn.getStoreMap();
            this.bn.replaceStoreMap(new PdfcRenderCache());
            this.a(0.5f);
            try {
                ThreadPool.Work work = ThreadPool.DEFAULT.startSubThread((Callable)new Callable<Void>(){

                    public Void U() throws Exception {
                        AbstractComparator.this.a(pdfSource, true, AbstractComparator.this.a(AbstractComparator.this.profile, AbstractComparator.this.bu.ab()));
                        return null;
                    }

                    @Override
                    public /* synthetic */ Object call() throws Exception {
                        return this.U();
                    }
                }, (RunnableSession)this.bn);
                this.a(pdfSource2, false, this.a(this.profile, this.bu.ab()));
                work.get();
                this.a(1.5f);
            }
            catch (Exception exception) {
                throw PdfcException.create(exception);
            }
            finally {
                this.bn.getStoreMap().clear();
                this.bn.replaceStoreMap(pdfcRenderCache);
            }
        }
        this.bm = BasePresenter.ERROR_SOURCE.COMPARE;
        dataGeneratorListener.addData(new ProgressState(State.COMPARING, 3.0f));
        this.bi = new com.inet.pdfc.generator.a(infoData, this.bu, dataGeneratorListener, this.bs);
        LOGGER.info((Object)Msg.getMsg("Status.Start"));
        this.bg = new PDFParserTask(this.bk, string, this.bt, this.bs, this.bi, true, this.bj, this.a(pdfSource), this.profile);
        this.bh = new PDFParserTask(this.bl, string2, this.bt, this.bs, this.bi, false, this.bj, this.a(pdfSource2), this.profile);
    }

    private void a(PdfSource pdfSource, boolean bl, List<DocumentPreAnalyze> list) throws PdfcException {
        LOGGER.info((Object)Msg.getMsg("Status.Setting" + (bl ? "First" : "Second") + "File", pdfSource.getName()));
        ArrayList<DocumentPreAnalyze> arrayList = new ArrayList<DocumentPreAnalyze>();
        if (!list.isEmpty()) {
            Set<DocumentFactory.FEATURE> set;
            HashSet<DocumentFactory.FEATURE> hashSet = new HashSet<DocumentFactory.FEATURE>();
            for (DocumentPreAnalyze documentPreAnalyze : list) {
                set = documentPreAnalyze.getRequiredFeatures();
                if (set != null && hashSet != null) {
                    hashSet.addAll(set);
                    continue;
                }
                hashSet = null;
            }
            DocumentFactory.FEATURE[] fEATUREArray = hashSet != null ? hashSet.toArray(new DocumentFactory.FEATURE[0]) : null;
            boolean bl2 = this.profile.getString(PDFCProperty.FILTERS).contains(NO_CMAP_FILTER_KEY);
            if (bl2) {
                set = fEATUREArray == null ? new HashSet<DocumentFactory.FEATURE>(Arrays.asList(DocumentFactory.FEATURE.values())) : new HashSet(Arrays.asList(fEATUREArray));
                set.add(DocumentFactory.FEATURE.textNoCharMapping);
                fEATUREArray = set.toArray(new DocumentFactory.FEATURE[0]);
            }
            set = DocumentReader.getInstance().readDocumentReduced(pdfSource, fEATUREArray);
            try {
                EnumerationProgress enumerationProgress = com.inet.pdfc.model.a.a(set, FilterUtils.getPageRange(this.profile, bl));
                while (enumerationProgress.hasMoreElements() && !list.isEmpty()) {
                    Page page = enumerationProgress.nextElement();
                    for (DocumentPreAnalyze documentPreAnalyze : list) {
                        documentPreAnalyze.analyze(page, bl, enumerationProgress.hasMoreElements());
                        if (!documentPreAnalyze.isFinished()) continue;
                        arrayList.add(documentPreAnalyze);
                    }
                    if (!arrayList.isEmpty()) {
                        list.removeAll(arrayList);
                        arrayList.clear();
                    }
                    this.a(bl, (float)(enumerationProgress.getProgress() * 1.5));
                }
            }
            finally {
                if (set != null) {
                    set.close();
                }
            }
        }
        pdfSource.setLanguage(this.bn.getSessionProperties().getProperty("document." + (bl ? "first" : "second") + ".language"));
        LOGGER.debug((Object)Msg.getMsg("Status.SettingFirstFile.language", pdfSource.getLanguage()));
        this.a(bl, 1.5f);
    }

    private List<DocumentPreAnalyze> a(IProfile iProfile, List<FeatureKey> list) {
        List list2 = PluginManager.get(DocumentPreAnalyzeFactory.class).stream().map(documentPreAnalyzeFactory -> documentPreAnalyzeFactory.createAnalyzer(iProfile)).filter(documentPreAnalyze -> !documentPreAnalyze.isFinished()).collect(Collectors.toList());
        ArrayList<DocumentPreAnalyze> arrayList = new ArrayList<DocumentPreAnalyze>();
        block0: for (DocumentPreAnalyze documentPreAnalyze2 : list2) {
            for (FeatureKey featureKey : documentPreAnalyze2.getProvidedPreAnalyzeFeatures()) {
                if (!list.contains(featureKey)) continue;
                arrayList.add(documentPreAnalyze2);
                continue block0;
            }
        }
        return arrayList;
    }

    private synchronized void a(boolean bl, float f2) {
        if (bl) {
            this.bx = f2;
        } else {
            this.by = f2;
        }
        this.br.addData(new ProgressState(State.START, this.bx + this.by, this.bo));
    }

    private synchronized void a(float f2) {
        this.bx = f2;
        this.by = f2;
        this.br.addData(new ProgressState(State.START, this.bx + this.by, this.bo));
    }

    private int a(PdfSource pdfSource) {
        String string = SourceMetaAccessor.getMetaProperties(pdfSource).get("LIMIT");
        if (string == null) {
            return Integer.MAX_VALUE;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return Integer.MAX_VALUE;
        }
    }

    public void prepare(PdfSource pdf1, PdfSource pdf2, DataGeneratorListener listener) throws Exception {
        if (pdf1 == null) {
            this.bm = BasePresenter.ERROR_SOURCE.FIRST_PDF;
            throw new IllegalArgumentException("AbstractComparator requires a PDF source as first argument");
        }
        if (pdf2 == null) {
            this.bm = BasePresenter.ERROR_SOURCE.SECOND_PDF;
            throw new IllegalArgumentException("AbstractComparator requires a PDF source as second argument");
        }
        if (listener == null) {
            this.bm = BasePresenter.ERROR_SOURCE.PREPARE;
            throw new IllegalArgumentException("AbstractComparator requires a result listener as third argument");
        }
        this.br = listener;
        if (!this.bj.isCreateHighlightData()) {
            this.br = new a(listener);
        }
        try {
            this.a(pdf1, pdf2, this.br);
        }
        catch (InvalidLicenseException invalidLicenseException) {
            this.T();
            throw invalidLicenseException;
        }
        catch (Error | Exception throwable) {
            this.T();
            throw throwable;
        }
    }

    public static List<CompareDiffGroup> simpleDiff(List<@Nonnull DrawableElement> list1, List<@Nonnull DrawableElement> list2, IProfile profile, boolean usePostCompare) {
        return com.inet.pdfc.generator.continuous.b.simpleDiff(list1, list2, profile, usePostCompare);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopThreads(State transitionState) throws InterruptedException {
        this.bs.setState(transitionState);
        this.bs.addData(new ProgressState(transitionState));
        StoppableCallable.CallableState callableState = this.bg.stop();
        PDFCCore.LOGGER_COMPARE.debug((Object)("Parser1 thread ended, state is " + String.valueOf(callableState)));
        StoppableCallable.CallableState callableState2 = this.bh.stop();
        PDFCCore.LOGGER_COMPARE.debug((Object)("Parser2 thread ended, state is  " + String.valueOf(callableState2)));
        this.bi.sendStopSignal();
        PDFCCore.LOGGER_COMPARE.debug((Object)"Comparer thread terminated");
        Object object = this.bw;
        synchronized (object) {
            if (!this.bv && this.bp != null) {
                this.bw.wait();
            }
        }
    }

    public void writeOnPause(ObjectOutputStream out) throws IOException {
        out.writeObject(this.bs);
        this.bt.swapAll();
        out.writeObject((Object)this.bm);
        out.writeLong(this.bo);
        out.writeObject(this.bu);
        out.writeObject(this.bi);
        out.writeObject(this.bg);
        out.writeObject(this.bh);
    }

    public void runCompare() throws Exception {
        this.bp = ThreadPool.DEFAULT.startSubThread((Callable)this.bg, (RunnableSession)this.bn);
        this.bq = ThreadPool.DEFAULT.startSubThread((Callable)this.bh, (RunnableSession)this.bn);
        this.S();
    }

    public void restore(ObjectInputStream in, PdfSource pdf1, PdfSource pdf2, DataGeneratorListener dgl) throws Exception {
        try {
            this.br = dgl;
            if (!this.bj.isCreateHighlightData()) {
                this.br = new a(this.br);
            }
            this.bn = PdfcSession.getSession();
            this.bs = (f)in.readObject();
            this.bs.a(this.br);
            this.bt = this.bn.getStoreMap();
            this.bm = (BasePresenter.ERROR_SOURCE)((Object)in.readObject());
            this.bo = in.readLong();
            this.bu = (b)in.readObject();
            this.reInitComparer(this.bu, dgl, this.bs, this.bt);
            this.bk = DocumentReader.getInstance().readDocument(pdf1);
            this.bl = DocumentReader.getInstance().readDocument(pdf2);
            this.bi = (com.inet.pdfc.generator.a)in.readObject();
            this.bi.a(new InfoData(pdf1, pdf2, this.profile), this.bu, this.br, this.bs);
            this.bg = (PDFParserTask)in.readObject();
            this.bg.a(this.bk, this.bt, this.bs, this.bi, this.bj);
            this.bg.stopJobDone();
            this.bh = (PDFParserTask)in.readObject();
            this.bh.a(this.bl, this.bt, this.bs, this.bi, this.bj);
            this.bh.stopJobDone();
        }
        catch (Error | Exception throwable) {
            this.br.addData(new ProgressState(State.ERROR));
            this.T();
            throw throwable;
        }
    }

    public void cleanUp() {
        this.T();
    }

    public static class a
    implements DataGeneratorListener {
        private DataGeneratorListener bB;

        public a(DataGeneratorListener dataGeneratorListener) {
            this.bB = dataGeneratorListener;
        }

        @Override
        public void addData(Chunk chunk) {
            this.bB.addData(chunk);
        }
    }
}

