/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.results.painter;

import com.inet.annotations.InternalApi;
import com.inet.cache.PersistenceKey;
import com.inet.pdfc.config.Settings;
import com.inet.pdfc.generator.message.AnnotationHighlight;
import com.inet.pdfc.generator.message.HighlightData;
import com.inet.pdfc.generator.rendercache.PageImageCache;
import com.inet.pdfc.results.painter.Painter;
import com.inet.pdfc.util.LocationUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@InternalApi
public class HighlightPainter {
    private Map<String, Color> rX = new HashMap<String, Color>();
    private Settings settings;

    public HighlightPainter(Settings settings) {
        this.settings = settings;
    }

    public void setSettings(Settings settings) {
        this.settings = settings;
        this.rX.clear();
    }

    public void clear() {
        this.rX.clear();
    }

    public void drawHighlights(Graphics2D g2, double scale, int horizontalOffset, Rectangle pageBounds, List<HighlightData.Highlight> highlights, PageImageCache pageImageCache, boolean export) {
        if (highlights != null && highlights.size() > 0) {
            Shape shape = g2.getClip();
            g2 = (Graphics2D)g2.create();
            Font font = Painter.sF;
            font = font.deriveFont((float)((double)font.getSize2D() * scale));
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            FontMetrics fontMetrics = g2.getFontMetrics(font);
            for (HighlightData.Highlight highlight : highlights) {
                Object object;
                Object object2;
                Rectangle rectangle;
                if (highlight.isAnnotation() && (((AnnotationHighlight)(rectangle = (AnnotationHighlight)highlight)).getIrtID() >= 0 || !((AnnotationHighlight)rectangle).isVisible())) continue;
                rectangle = LocationUtils.scaleRect(scale, highlight);
                Rectangle rectangle2 = new Rectangle(pageBounds.x + rectangle.x + horizontalOffset, pageBounds.y + rectangle.y, rectangle.width, rectangle.height);
                if (shape != null) {
                    object2 = shape.getBounds().intersection(rectangle2);
                    if (((Rectangle)object2).width <= 0 || ((Rectangle)object2).height <= 0) continue;
                    g2.setClip((Shape)object2);
                } else {
                    g2.setClip(rectangle2);
                }
                if (highlight.getRenderCacheKey() != null) {
                    object2 = g2.getTransform();
                    g2.translate(rectangle2.getX(), rectangle2.getY());
                    g2.scale(scale, scale);
                    object = (Graphics2D)g2.create();
                    pageImageCache.renderPage(PersistenceKey.create((String)highlight.getRenderCacheKey()), (Graphics2D)object);
                    ((Graphics)object).dispose();
                    g2.setTransform((AffineTransform)object2);
                    continue;
                }
                object2 = highlight.getAppearance();
                switch (1.rY[((Enum)object2).ordinal()]) {
                    case 1: {
                        g2.setColor(HighlightPainter.a(this.a(highlight), 100));
                        g2.fill(rectangle2);
                    }
                    case 2: {
                        g2.setColor(HighlightPainter.a(this.a(highlight), 160));
                        g2.drawRect(pageBounds.x + rectangle.x + horizontalOffset, pageBounds.y + rectangle.y, rectangle.width - 1, rectangle.height - 1);
                        break;
                    }
                    case 3: {
                        g2.setColor(this.a(highlight));
                        g2.setStroke(new BasicStroke((float)scale));
                        g2.drawLine((int)rectangle2.getX(), (int)rectangle2.getCenterY(), (int)rectangle2.getMaxX(), (int)rectangle2.getCenterY());
                        break;
                    }
                    case 4: {
                        g2.setColor(this.a(highlight));
                        g2.setStroke(new BasicStroke((float)scale));
                        g2.drawLine((int)rectangle2.getX(), (int)rectangle2.getMaxY() - 4, (int)rectangle2.getMaxX(), (int)rectangle2.getMaxY() - 4);
                        break;
                    }
                }
                if (highlight.getCaption() != null && !highlight.isAnnotation()) {
                    g2.setColor(HighlightPainter.a(this.a(highlight), 160));
                    object = (Rectangle2D)hashMap.get(highlight.getCaption());
                    if (object == null) {
                        object = fontMetrics.getStringBounds(highlight.getCaption(), g2);
                        ((Rectangle2D)object).setFrame(0.0, 0.0, ((RectangularShape)object).getWidth(), ((RectangularShape)object).getHeight() - (double)fontMetrics.getDescent());
                        hashMap.put(highlight.getCaption(), object);
                    }
                    double d2 = ((RectangularShape)object).getWidth() + 10.0;
                    double d3 = ((RectangularShape)object).getHeight() + 10.0;
                    if ((double)rectangle2.width < d2 || (double)rectangle2.height < d3) {
                        double d4 = Math.min((double)rectangle2.width / d2, (double)rectangle2.height / d3);
                        double d5 = ((RectangularShape)object).getHeight() * d4;
                        float f2 = (float)((double)font.getSize2D() * d4);
                        if (f2 < 7.0f) {
                            f2 = 7.0f;
                            d5 = ((RectangularShape)object).getHeight() * 7.0 / (double)font.getSize2D();
                        }
                        double d6 = 5.0;
                        if ((double)rectangle2.height < d5 + 5.0) {
                            d6 = Math.max(1.0, (double)rectangle2.height - d5);
                        }
                        g2.setFont(font.deriveFont(f2));
                        g2.drawString(highlight.getCaption(), rectangle2.x + 5, (int)((double)rectangle2.y + d6 + d5));
                        g2.setFont(font);
                    } else {
                        g2.setFont(font);
                        g2.drawString(highlight.getCaption(), rectangle2.x + 5, (int)((double)(rectangle2.y + 5) + ((RectangularShape)object).getHeight()));
                    }
                }
                object = highlight.getImage();
                if (export || object == null) continue;
                g2.setClip(shape);
                g2.drawImage((Image)object, (int)rectangle2.getX(), (int)(rectangle2.getY() - (double)((Image)object).getHeight(null)), null);
            }
            g2.dispose();
        }
    }

    private static Color a(Color color, int n) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), n);
    }

    private Color a(HighlightData.Highlight highlight) {
        if (highlight.getType() == null) {
            return highlight.getColor();
        }
        Color color = this.rX.get(highlight.getType());
        if (color != null) {
            return color;
        }
        color = this.settings.getColor(new Painter.HighlightColorSetting(highlight.getType()));
        if (color == null) {
            color = highlight.getColor();
        }
        this.rX.put(highlight.getType(), color);
        return color;
    }
}

