/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.model;

import com.inet.annotations.InternalApi;
import com.inet.annotations.JsonData;
import com.inet.pdfc.model.DrawableElementXY;
import com.inet.pdfc.model.ElementID;
import com.inet.pdfc.model.ElementType;
import com.inet.pdfc.model.ImageMetaData;
import com.inet.pdfc.model.Visitable;
import com.inet.pdfc.model.Visitor;
import com.inet.pdfc.model.i18n.a;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.annotation.Nonnull;

@JsonData
@InternalApi
public class ImageElement
extends DrawableElementXY
implements Visitable {
    private double width;
    private double height;
    private Dimension dataSize;
    private boolean isType3Glyph;
    private Object cacheKey;
    private AffineTransform renderTransform;
    private transient Shape clip;
    private Rectangle2D.Double bounds;
    private boolean yInverted = false;
    private ImageMetaData imageMetaData = new ImageMetaData();

    public ImageElement(Image image, Object cacheKey, AffineTransform bt, Shape clip, int pageIndex, boolean isType3Glyph, ElementID id) {
        super(pageIndex, id);
        this.renderTransform = new AffineTransform(bt);
        this.clip = clip;
        this.isType3Glyph = isType3Glyph;
        this.cacheKey = cacheKey;
        this.dataSize = new Dimension(image.getWidth(null), image.getHeight(null));
        double[] dArray = new double[]{0.0, 0.0, 1.0, 1.0};
        this.renderTransform.transform(dArray, 0, dArray, 0, 2);
        Rectangle2D.Double double_ = new Rectangle2D.Double(dArray[0], dArray[3], dArray[2] - dArray[0], dArray[1] - dArray[3]);
        double d2 = double_.getX();
        double d3 = double_.getY();
        double d4 = double_.getWidth();
        double d5 = double_.getHeight();
        if (d4 < 0.0) {
            d2 += d4;
            d4 = -d4;
        }
        if (d5 < 0.0) {
            d3 += d5;
            d5 = -d5;
        }
        this.setX(d2);
        this.setY(d3);
        this.width = d4;
        this.height = d5;
    }

    public boolean isyInverted() {
        return this.yInverted;
    }

    public void setyInverted(boolean yInverted) {
        this.yInverted = yInverted;
    }

    public Shape getRenderClip() {
        return this.clip;
    }

    public void setRenderClip(Shape clip) {
        this.clip = clip;
    }

    public void setImageMetaData(@Nonnull ImageMetaData imageMetaData) {
        this.imageMetaData = imageMetaData;
    }

    @Nonnull
    public ImageMetaData getImageMetaData() {
        return this.imageMetaData;
    }

    public AffineTransform getRenderTransform() {
        return this.renderTransform;
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public Dimension getDataSize() {
        return this.dataSize;
    }

    public Object getCacheKey() {
        return this.cacheKey;
    }

    @Override
    public Rectangle2D getBounds() {
        Rectangle rectangle;
        if (this.bounds != null) {
            return this.bounds;
        }
        this.bounds = new Rectangle2D.Double(this.getX(), this.getY(), this.width, this.height);
        if (this.clip != null && !(rectangle = this.clip.getBounds()).contains(this.bounds)) {
            Rectangle2D.intersect(rectangle, this.bounds, this.bounds);
        }
        return this.bounds;
    }

    @Override
    public int getCompareHash() {
        return 2;
    }

    @Override
    public ElementType getType() {
        return ElementType.Image;
    }

    public boolean isType3Glyph() {
        return this.isType3Glyph;
    }

    void setWidth(double width) {
        this.width = width;
    }

    void setHeight(double height) {
        this.height = height;
    }

    @Override
    public double getRotation() {
        AffineTransform affineTransform = this.renderTransform;
        if (affineTransform.getShearX() == -affineTransform.getShearY() && Math.abs(affineTransform.getScaleX()) == Math.abs(affineTransform.getScaleY())) {
            if (affineTransform.getShearX() == 0.0 && affineTransform.getScaleX() > 0.0) {
                return 0.0;
            }
            return Math.atan2(affineTransform.getShearY(), affineTransform.getScaleX());
        }
        double[] dArray = new double[4];
        affineTransform.getMatrix(dArray);
        affineTransform = new AffineTransform(dArray);
        Point2D.Double double_ = new Point2D.Double(1.0, 0.0);
        affineTransform.transform(double_, double_);
        return Math.atan2(double_.getY(), double_.getX());
    }

    @Override
    public String getLabel() {
        Rectangle2D rectangle2D = this.getBounds();
        String string = Long.toString(Math.round(rectangle2D.getWidth()));
        String string2 = Long.toString(Math.round(rectangle2D.getHeight()));
        return a.getMsg("ElementType." + String.valueOf(this.getType()), string, string2);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        return "Image " + (int)this.getWidth() + "x" + (int)this.getHeight() + " at " + (int)this.getX() + ":" + (int)this.getY();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        com.inet.pdfc.generator.model.forms.a.a(this.clip, out);
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        this.clip = com.inet.pdfc.generator.model.forms.a.a(in);
    }
}

