/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.util;

import com.inet.annotations.InternalApi;
import com.inet.pdfc.util.Pair;
import com.inet.pdfc.util.Sample;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;

@InternalApi
public class RattleSort<T> {
    private Sample.ValueFunction<T> uh;

    public RattleSort(Sample.ValueFunction<T> locator) {
        this.uh = locator;
    }

    public List<Sample<T>> sort(List<T> elements, double maxDevitation) {
        return this.a(elements, maxDevitation, 0);
    }

    public List<Sample<T>> sort(List<T> elements, int numberOfClusters) {
        return this.a(elements, Double.MAX_VALUE, numberOfClusters);
    }

    public Pair<Sample<T>> cluster2(List<T> elements, boolean trim) {
        if (elements.size() < 2) {
            return null;
        }
        List<Object> list = new ArrayList<T>(elements);
        Collections.sort(list, (object, object2) -> Double.compare(this.uh.getValue(object), this.uh.getValue(object2)));
        List<c<T>> list2 = this.z(list);
        if (list2.size() < 2) {
            return null;
        }
        if (trim && list2.size() >= 10) {
            int n = Math.round(list.size() / 10);
            int n2 = Math.round(list.size() * 9 / 10) + 1;
            list = list.subList(n, n2);
            list2 = this.z(list);
        }
        if (list2.size() < 2) {
            return null;
        }
        double d2 = Double.MAX_VALUE;
        int n = list2.size() / 2;
        for (int i = 1; i < list2.size(); ++i) {
            double d3 = this.e(list2, i);
            if (!(d3 <= d2)) continue;
            n = i;
            d2 = d3;
        }
        double d4 = this.c(list2, n);
        double d5 = this.c(list2, n + 1);
        double d6 = this.c(list2, n - 1);
        if (d5 > d4 || d6 > d4) {
            boolean bl = d5 > d6;
            int n3 = n + (bl ? 1 : -1);
            double d7 = this.c(list2, n3);
            while (d7 > d4) {
                n = n3;
                d7 = this.c(list2, n3 += bl ? 1 : -1);
            }
        }
        Pair<Sample<T>> pair = this.d(list2, n);
        return pair;
    }

    private List<c<T>> z(List<T> list) {
        ArrayList<c<T>> arrayList = new ArrayList<c<T>>();
        double d2 = Double.NaN;
        c<T> c2 = null;
        for (T t : list) {
            double d3 = this.uh.getValue(t);
            if (d3 != d2 || c2 == null) {
                c2 = new c<T>(t, 0);
                arrayList.add(c2);
                d2 = d3;
            }
            ++c2.un;
        }
        return arrayList;
    }

    private double c(List<c<T>> list, int n) {
        if (n <= 0 || n >= list.size()) {
            return 0.0;
        }
        return this.uh.getValue(list.get((int)n).um) - this.uh.getValue(list.get((int)(n - 1)).um);
    }

    private Pair<Sample<T>> d(List<c<T>> list, int n) {
        Sample<T> sample = new Sample<T>(this.A(list.subList(0, n)), this.uh);
        Sample<T> sample2 = new Sample<T>(this.A(list.subList(n, list.size())), this.uh);
        return new Pair<Sample<T>>(sample, sample2);
    }

    private List<T> A(List<c<T>> list) {
        ArrayList arrayList = new ArrayList(list.size());
        for (c<T> c2 : list) {
            for (int i = 0; i < c2.un; ++i) {
                arrayList.add(c2.um);
            }
        }
        return arrayList;
    }

    private double e(List<c<T>> list, int n) {
        double d2 = this.B(list.subList(0, n));
        double d3 = this.B(list.subList(n, list.size()));
        return d2 + d3;
    }

    private double B(List<c<T>> list) {
        int n = list.stream().mapToInt(c2 -> c2.un).sum();
        double d2 = list.stream().mapToDouble(c2 -> this.uh.getValue(c2.um) * (double)c2.un).sum() / (double)n;
        return list.stream().mapToDouble(c2 -> Math.abs(d2 - this.uh.getValue(c2.um)) * (double)c2.un).sum();
    }

    private List<Sample<T>> a(List<T> list, double d2, int n) {
        Object object22;
        if (list.size() == 0) {
            return new ArrayList<Sample<T>>();
        }
        Collections.sort(list, new b());
        TreeSet<Object> treeSet = new TreeSet<Object>();
        a a2 = null;
        for (Object object22 : list) {
            a a3 = new a(object22, a2);
            treeSet.add(a3);
            a2 = a3;
        }
        while ((object22 = (a)treeSet.pollFirst()) != null) {
            if (((a)object22).dt() > d2) {
                treeSet.add(object22);
                break;
            }
            a2 = ((a)object22).uj;
            if (a2 == null) break;
            treeSet.remove(a2);
            a a4 = ((a)object22).uk;
            if (a4 != null) {
                treeSet.remove(a4);
            }
            ((a)object22).ds();
            treeSet.add(a2);
            if (a4 != null) {
                treeSet.add(a4);
            }
            if (treeSet.size() > n) continue;
            break;
        }
        object22 = new ArrayList(treeSet.size());
        for (a a5 : treeSet) {
            object22.add(a5.du());
        }
        Collections.sort(object22, Sample.SORT_BY_VALUE);
        return object22;
    }

    private static class c<T> {
        private T um;
        private int un;

        public c(T t, int n) {
            this.um = t;
            this.un = n;
        }
    }

    private class b
    implements Comparator<T> {
        private b() {
        }

        @Override
        public int compare(T o1, T o2) {
            return (int)Math.signum(RattleSort.this.uh.getValue(o1) - RattleSort.this.uh.getValue(o2));
        }
    }

    private class a
    implements Comparable<a> {
        private List<T> fo = new ArrayList();
        private double ui;
        private a uj;
        private a uk;

        public a(T t, a a2) {
            this.fo.add(t);
            this.uj = a2;
            if (a2 != null) {
                a2.uk = this;
            }
            this.ui = RattleSort.this.uh.getValue(t);
        }

        public String toString() {
            return "Bucket @" + this.ui + ", dist=" + this.dt() + ", elements=" + this.fo.size() + " = " + String.valueOf(this.fo);
        }

        public void ds() {
            int n = this.fo.size() + this.uj.fo.size();
            this.uj.ui = (this.ui * (double)this.fo.size() + this.uj.ui * (double)this.uj.fo.size()) / (double)n;
            this.uj.fo.addAll(this.fo);
            this.uj.uk = this.uk;
            if (this.uk != null) {
                this.uk.uj = this.uj;
            }
        }

        public double dt() {
            return this.uj != null ? this.ui - this.uj.ui : Double.MAX_VALUE;
        }

        public Sample<T> du() {
            return new Sample(this.fo, RattleSort.this.uh);
        }

        public int a(a a2) {
            double d2 = this.dt() - a2.dt();
            if (d2 != 0.0) {
                return (int)Math.signum(d2);
            }
            return (int)Math.signum(this.ui - a2.ui);
        }

        @Override
        public /* synthetic */ int compareTo(Object object) {
            return this.a((a)object);
        }
    }
}

