/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.structure;

import com.inet.annotations.InternalApi;
import com.inet.config.ConfigKey;
import com.inet.config.ConfigKeyParser;
import com.inet.config.ConfigurationManager;
import com.inet.config.internal.PrivateCloudLicenseTimerTask;
import com.inet.config.structure.core.CoreSystemStructureProvider;
import com.inet.config.structure.core.license.LicenseConfigProperty;
import com.inet.config.structure.model.ConfigCategory;
import com.inet.config.structure.model.ConfigCondition;
import com.inet.config.structure.model.ConfigConditionAction;
import com.inet.config.structure.model.ConfigGroup;
import com.inet.config.structure.model.ConfigProperty;
import com.inet.config.structure.model.ConfigPropertyGroup;
import com.inet.config.structure.model.ConfigValidationMsg;
import com.inet.config.structure.model.LocalizedKey;
import com.inet.config.structure.provider.AbstractStructureProvider;
import com.inet.config.structure.provider.ConditionGenerator;
import com.inet.config.structure.provider.ConfigStructureSettings;
import com.inet.config.structure.provider.ConfigValidator;
import com.inet.http.ClientMessageException;
import com.inet.lib.json.Json;
import com.inet.lib.util.EncodingFunctions;
import com.inet.lib.util.StringFunctions;
import com.inet.pdfc.PDFCLicenseChecker;
import com.inet.pdfc.structure.PdfcLicenseConfigProperty;
import com.inet.plugin.ServerPluginManager;
import com.inet.plugin.website.WellKnownWebsites;
import java.net.InetAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public class PdfcStructureProvider
extends AbstractStructureProvider {
    public static final PdfcStructureProvider INSTANCE = new PdfcStructureProvider();
    public static final String LICENSE_TYPE_SELECT = "license.generateTrial.select";
    public static final String LICENSE_GENERATE_TRIAL_SERVER = "license.generateTrial.server";
    public static final String LICENSE_GENERATE_TRIAL_DOMAIN = "license.generateTrial.domain";
    public static final String LICENSE_GENERATE_TRIAL_PUBLIC_CLOUD = "license.generateTrial.cloud";
    public static final String LICENSE_GENERATE_TRIAL_PRIVATE_CLOUD = "license.generateTrial.privatecloud";
    public static final String MACHINE_ID = "license.generateTrial.machine.id";
    public static final String FQDN = "license.generateTrial.fqdn";
    public static final String DOMAIN_NAME = "license.generateTrial.domain.name";
    public static final String GROUP_PDFC_PARSER = "group.parser";
    public static final String GROUP_PDFC_COMPARISON = "group.comparison";
    public static final ConfigKey KEY_EXPORT_FOOTER = new ConfigKey("pdfc.export.footer", "", String.class);
    public static final ConfigKey KEY_EXPORT_DISCLAIMER = new ConfigKey("pdfc.export.disclaimer", "", String.class);

    public void addGroupsTo(@Nonnull Set<ConfigGroup> groups, boolean advanced, @Nonnull ConfigStructureSettings settings) {
        groups.add(new ConfigGroup(150, GROUP_PDFC_COMPARISON, this.translate(settings, GROUP_PDFC_COMPARISON, new Object[0])));
        groups.add(new ConfigGroup(151, GROUP_PDFC_PARSER, this.translate(settings, GROUP_PDFC_PARSER, new Object[0])));
    }

    public void addCategoriesTo(@Nonnull Set<ConfigCategory> categories, @Nonnull String groupKey, boolean advanced, @Nonnull ConfigStructureSettings settings) {
    }

    public URL getCategoryIcon(@Nonnull String categoryKey) {
        return null;
    }

    public void addPropertyGroupsTo(@Nonnull Set<ConfigPropertyGroup> propertyGroups, @Nonnull String categoryKey, boolean advanced, @Nonnull ConfigStructureSettings settings) {
        switch (categoryKey) {
            case "category.license": {
                propertyGroups.add(new ConfigPropertyGroup(100, "group.license.system", this.translate(settings, "group.license.system", new Object[0])));
                break;
            }
            case "action.generateTrial": {
                propertyGroups.add(new ConfigPropertyGroup(100, "action.generateTrial"));
                break;
            }
            case "license.addactivationkey": {
                propertyGroups.add(new ConfigPropertyGroup(100, "license.addactivationkey"));
                break;
            }
        }
    }

    public void addPropertiesTo(@Nonnull Set<ConfigProperty> configProperties, @Nonnull String propertyGroupKey, boolean advanced, @Nonnull ConfigStructureSettings settings) {
        switch (propertyGroupKey) {
            case "group.license.system": {
                boolean bl = CoreSystemStructureProvider.isDocker();
                Object object = CoreSystemStructureProvider.getPublicDomain();
                if (!bl) {
                    configProperties.add(new ConfigProperty(200, "license.hwid", "KeyLabel", this.translate(settings, "license.hwid", new Object[0]), (Object)PDFCLicenseChecker.getHashedHardwareKey(), null, null));
                } else {
                    object = (String)object + " (" + CoreSystemStructureProvider.getMessageFromIsDockerMethod() + ")";
                }
                configProperties.add(new ConfigProperty(300, "license.domain", "KeyLabel", this.translate(settings, "license.domain", new Object[0]), object, null, null));
                break;
            }
            case "group.license.key": {
                configProperties.add((ConfigProperty)new PdfcLicenseConfigProperty(settings));
                break;
            }
            case "action.generateTrial": {
                String string;
                boolean bl = CoreSystemStructureProvider.isDocker();
                String string2 = CoreSystemStructureProvider.getPublicDomain();
                ArrayList<LocalizedKey> arrayList = new ArrayList<LocalizedKey>();
                if (!bl) {
                    arrayList.add(new LocalizedKey(LICENSE_GENERATE_TRIAL_SERVER, this.translate(settings, LICENSE_GENERATE_TRIAL_SERVER, new Object[0])));
                    string = LICENSE_GENERATE_TRIAL_SERVER;
                } else {
                    string = LICENSE_GENERATE_TRIAL_PUBLIC_CLOUD;
                }
                arrayList.add(new LocalizedKey(LICENSE_GENERATE_TRIAL_DOMAIN, this.translate(settings, LICENSE_GENERATE_TRIAL_DOMAIN, new Object[0])));
                arrayList.add(new LocalizedKey(LICENSE_GENERATE_TRIAL_PUBLIC_CLOUD, this.translate(settings, LICENSE_GENERATE_TRIAL_PUBLIC_CLOUD, new Object[0])));
                arrayList.add(new LocalizedKey(LICENSE_GENERATE_TRIAL_PRIVATE_CLOUD, this.translate(settings, LICENSE_GENERATE_TRIAL_PRIVATE_CLOUD, new Object[0])));
                this.addSelectTo(configProperties, LICENSE_TYPE_SELECT, string, null, settings, arrayList);
                InetAddress[] inetAddressArray = ConfigurationManager.getInstance().getAvailableIPAddresses();
                String string3 = "";
                ArrayList<LocalizedKey> arrayList2 = new ArrayList<LocalizedKey>();
                for (InetAddress inetAddress : inetAddressArray) {
                    String string4 = inetAddress.getHostAddress();
                    if (string3.isEmpty()) {
                        string3 = string4;
                    }
                    arrayList2.add(new LocalizedKey(string4, null));
                }
                arrayList2.add(new LocalizedKey(PDFCLicenseChecker.getHashedHardwareKey(), null));
                this.addSelectTo(configProperties, MACHINE_ID, string3, "SimpleText", settings, arrayList2);
                configProperties.add(new ConfigProperty(200, "license.generateTrial.domain.description", "KeyLabel", null, (Object)this.translate(settings, "license.generateTrial.domain.description", new Object[0]), null, null));
                configProperties.add(new ConfigProperty(300, "license.generateTrial.domain.description2", "KeyLabel", null, (Object)this.translate(settings, "license.generateTrial.domain.description2", new Object[0]), null, null));
                ArrayList arrayList3 = new ArrayList();
                for (String string5 : ConfigKeyParser.getKnownFQDNs()) {
                    arrayList3.add(new LocalizedKey(string5, null));
                }
                this.addSelectTo(configProperties, DOMAIN_NAME, string2, "SimpleText", settings, arrayList3);
                configProperties.add(new ConfigProperty(500, "license.generateTrial.cloud.description", "KeyLabel", null, (Object)this.translate(settings, "license.generateTrial.cloud.description", new Object[0]), null, null));
                configProperties.add(new ConfigProperty(600, FQDN, "SimpleText", this.translate(settings, FQDN, new Object[0]), null, null, null));
                this.addTo(configProperties, ConfigKey.SERVER_URL, settings);
                if (bl) {
                    configProperties.add(new ConfigProperty(850, "", "KeyLabel", null, (Object)CoreSystemStructureProvider.getMessageFromIsDockerMethod(), null, null));
                }
                configProperties.add(new ConfigProperty(1000, "license.generateTrial.support", "Link", null, (Object)"configmanager?method=license_support_info", null, this.translate(settings, "license.generateTrial.support", new Object[0])));
                break;
            }
            case "license.addactivationkey": {
                configProperties.add(new ConfigProperty(0, "currentactivationkey", "MultiLineText", INSTANCE.translate(settings, "license.activationnkey", new Object[0]), null, null, null));
                break;
            }
        }
    }

    public void addConditionsTo(@Nonnull List<ConfigConditionAction> actions, @Nonnull String categoryKey, boolean advanced, @Nonnull ConfigStructureSettings settings) {
        ConditionGenerator conditionGenerator = new ConditionGenerator();
        switch (categoryKey) {
            case "action.generateTrial": {
                ConfigCondition configCondition = conditionGenerator.createCondition().property(LICENSE_TYPE_SELECT).equals().value((Object)LICENSE_GENERATE_TRIAL_SERVER);
                ConfigCondition configCondition2 = conditionGenerator.createCondition().property(LICENSE_TYPE_SELECT).equals().value((Object)LICENSE_GENERATE_TRIAL_DOMAIN);
                ConfigCondition configCondition3 = conditionGenerator.createCondition().property(LICENSE_TYPE_SELECT).equals().value((Object)LICENSE_GENERATE_TRIAL_PUBLIC_CLOUD);
                ConfigCondition configCondition4 = conditionGenerator.createCondition().property(LICENSE_TYPE_SELECT).equals().value((Object)LICENSE_GENERATE_TRIAL_PRIVATE_CLOUD);
                actions.add(conditionGenerator.visibleActionFor(configCondition, MACHINE_ID));
                actions.add(conditionGenerator.visibleActionFor(configCondition2, "license.generateTrial.domain.description"));
                actions.add(conditionGenerator.visibleActionFor(configCondition2, "license.generateTrial.domain.description2"));
                actions.add(conditionGenerator.visibleActionFor(configCondition2, DOMAIN_NAME));
                actions.add(conditionGenerator.visibleActionFor(configCondition3, "license.generateTrial.cloud.description"));
                actions.add(conditionGenerator.visibleActionFor(configCondition3, FQDN));
                actions.add(conditionGenerator.visibleActionFor(configCondition4, ConfigKey.SERVER_URL));
                break;
            }
            case "category.companyinfo": {
                actions.add(conditionGenerator.visibleActionFor(conditionGenerator.alwaysFalse(), ConfigKey.SUPPORT_EMAIL));
                break;
            }
        }
    }

    public void validate(@Nullable String categoryKey, @Nonnull ArrayList<ConfigValidationMsg> messages, @Nonnull ArrayList<ConfigConditionAction> conditions, @Nonnull ConfigStructureSettings settings) {
        String string;
        if ("license.addactivationkey".equals(categoryKey) && ((string = settings.getChangedValue("currentactivationkey")) == null || string.isEmpty())) {
            messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.translate(settings, "license.invalidactivationkey", new Object[0]), "currentactivationkey"));
            return;
        }
    }

    public void action(String actionKey, ArrayList<ConfigValidationMsg> messages, ConfigStructureSettings settings) {
        switch (actionKey) {
            case "action.generateTrial": {
                if (ServerPluginManager.getInstance().getCorePluginId().equals("pdfc.standalone")) {
                    messages.add(0, new ConfigValidationMsg(ConfigValidationMsg.Type.Reload, "", "action.generateTrial.ok"));
                    break;
                }
                messages.add(0, new ConfigValidationMsg(ConfigValidationMsg.Type.Popup, null, "action.generateTrial"));
                break;
            }
            case "action.generateTrial.ok": {
                String string = settings.getValue(LICENSE_TYPE_SELECT);
                if (LICENSE_GENERATE_TRIAL_PUBLIC_CLOUD.equals(string)) {
                    String string2 = settings.getValue(FQDN);
                    if (StringFunctions.isEmpty((String)string2)) {
                        throw new ClientMessageException(this.translate(settings, "license.generateTrial.fqdn.error", new Object[0]));
                    }
                } else if (LICENSE_GENERATE_TRIAL_PRIVATE_CLOUD.equals(string)) {
                    URL uRL;
                    String string3 = settings.getValue(ConfigKey.SERVER_URL);
                    if (StringFunctions.isEmpty((String)string3)) {
                        throw new ClientMessageException(this.translate(settings, "license.generateTrial.serverurl.error", new Object[0]));
                    }
                    ConfigValidator configValidator = new ConfigValidator(messages, settings);
                    configValidator.validateHttpURL(ConfigKey.SERVER_URL);
                    if (messages.size() > 0) {
                        throw new ClientMessageException(messages.get(0).getMsg());
                    }
                    configValidator.validateHttpURL(ConfigKey.SERVER_URL);
                    try {
                        uRL = new URL(string3);
                        PrivateCloudLicenseTimerTask.externalUrlAssignable((URL)uRL);
                        for (int i = 0; i < 1000 && PrivateCloudLicenseTimerTask.externalUrlAssignable((URL)uRL) != null; ++i) {
                            Thread.sleep(1L);
                        }
                    }
                    catch (Exception exception) {
                        throw new ClientMessageException(StringFunctions.getUserFriendlyErrorMessage((Throwable)exception));
                    }
                    String string4 = PrivateCloudLicenseTimerTask.externalUrlAssignable((URL)uRL);
                    if (string4 != null) {
                        throw new ClientMessageException(string4);
                    }
                    settings.save(ConfigKey.SERVER_URL, string3);
                }
                PDFCLicenseChecker.requestAndStoreTrialLicense(settings);
                break;
            }
            case "license.addactivationkey": {
                messages.add(0, new ConfigValidationMsg(ConfigValidationMsg.Type.Popup, null, "license.addactivationkey"));
                break;
            }
            case "license.addactivationkey.ok": {
                String string = settings.getChangedValue("currentactivationkey");
                try {
                    List list = LicenseConfigProperty.getLicenseList((ConfigStructureSettings)settings);
                    String string5 = PDFCLicenseChecker.requestLicenseKeyAndWait(string);
                    if (string5 == null || string5.isEmpty()) {
                        throw new ClientMessageException(this.translate(settings, "license.invalidactivationkey", new Object[0]));
                    }
                    LicenseConfigProperty.addLicensesTo((List)list, (String)string5, (ConfigStructureSettings)settings);
                    settings.setLicenseKey(new Json().toJson((Object)list));
                    break;
                }
                catch (ClientMessageException clientMessageException) {
                    throw clientMessageException;
                }
                catch (Exception exception) {
                    String string6 = PDFCLicenseChecker.getHashedHardwareKey();
                    throw new ClientMessageException(this.translate(settings, "license.errorcontactingserver", new Object[]{"<a target=\"_blank\" href=\"" + WellKnownWebsites.LICENSE_TOOL_BASE_URL + "?product=pdfc&uid=" + EncodingFunctions.encodeUrlParameter((String)(string6 != null ? string6 : "")) + "&key=" + EncodingFunctions.encodeUrlParameter((String)(string != null ? string : "")) + "\">", "</a>"}));
                }
            }
        }
        super.action(actionKey, messages, settings);
    }
}

