/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.presenter;

import com.inet.annotations.PublicApi;
import com.inet.lib.io.FastBufferedOutputStream;
import com.inet.pdfc.PDFCCore;
import com.inet.pdfc.error.ExceptionData;
import com.inet.pdfc.i18n.Msg;
import com.inet.pdfc.plugin.PluginManager;
import com.inet.pdfc.presenter.BasePresenter;
import com.inet.pdfc.presenter.OutputStreamProvider;
import com.inet.pdfc.presenter.ReportPDFPresenterFactory;
import com.inet.pdfc.results.ResultModel;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.SuppressFBWarnings;

@PublicApi
@SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="No files are being read")
public class ReportPresenter
extends BasePresenter {
    public static final String FORMAT_ODS = "ods";
    public static final String FORMAT_PDF = "pdf";
    public static final String FORMAT_RTF = "rtf";
    public static final String FORMAT_XLS = "xls";
    public static final String FORMAT_XLSX = "xlsx";
    private BasePresenter pz;
    private boolean pA;
    private boolean pB;
    private boolean pC;
    private File s;
    private File pn;
    private OutputStream pD = null;
    private String pE;
    private String password = null;
    private boolean pF = false;
    private OutputStreamProvider pG;

    public String getExtensionName() {
        return "Presenter_Report";
    }

    public ReportPresenter(boolean detailed, boolean appendSettings, String exportFormat, File target, boolean isFolder) {
        this(true, detailed, appendSettings, exportFormat, target, isFolder);
    }

    public ReportPresenter(boolean showDiagrams, boolean showDifferences, boolean appendSettings, String exportFormat, File target, boolean isFolder) {
        this.pA = showDiagrams;
        this.pB = showDifferences;
        this.pC = appendSettings;
        this.pE = exportFormat;
        if (isFolder) {
            this.s = target;
        } else {
            this.s = target.getParentFile();
            this.pn = target;
        }
        this.pG = new a();
        try {
            ReportPDFPresenterFactory reportPDFPresenterFactory = PluginManager.getSingleInstance(ReportPDFPresenterFactory.class);
            reportPDFPresenterFactory.createPresenter(showDiagrams, showDifferences, appendSettings, this.pG, exportFormat, this.password);
        }
        catch (RuntimeException runtimeException) {
            PDFCCore.LOGGER_PRESENTER.debug((Object)runtimeException);
            throw new IllegalStateException("Using the ReportPresenter requires an activated 'reporting' plugin.", runtimeException);
        }
    }

    public ReportPresenter(boolean detailed, boolean appendSettings, String exportFormat, OutputStream target) {
        this(true, detailed, appendSettings, exportFormat, target);
    }

    public ReportPresenter(boolean showDiagrams, boolean showDifferences, boolean appendSettings, String exportFormat, OutputStream target) {
        this.pA = showDiagrams;
        this.pB = showDifferences;
        this.pC = appendSettings;
        this.pE = exportFormat;
        this.pD = target;
        this.pG = () -> this.pD;
        try {
            ReportPDFPresenterFactory reportPDFPresenterFactory = PluginManager.getSingleInstance(ReportPDFPresenterFactory.class);
            reportPDFPresenterFactory.createPresenter(showDiagrams, showDifferences, appendSettings, this.pG, exportFormat, this.password);
        }
        catch (RuntimeException runtimeException) {
            PDFCCore.LOGGER_PRESENTER.debug((Object)runtimeException);
            throw new IllegalStateException("Using the ReportPDFPresenter requires an activated 'reporting' plugin.");
        }
    }

    @Override
    public void onComparisonDone() throws Exception {
        this.cE().onComparisonDone();
        if (this.pn != null) {
            LOGGER.info((Object)Msg.getMsg("Export.reportTarget", this.pn.getAbsoluteFile()));
        }
    }

    @Override
    public void executeImmediately(ResultModel model) throws Exception {
        this.cE().executeImmediately(model);
    }

    @Override
    protected ResultModel getModel() {
        return this.cE().getModel();
    }

    @Override
    public void detachFromModel() {
        this.cE().detachFromModel();
    }

    @Override
    public void onClear() throws Exception {
        this.cE().onClear();
    }

    @Override
    public void onDataUpdate() throws Exception {
        this.cE().onDataUpdate();
    }

    @Override
    public void onError(ExceptionData error, boolean interrupted, BasePresenter.ERROR_SOURCE source) {
        this.cE().onError(error, interrupted, source);
    }

    @Override
    public void onFilterChange() throws Exception {
        this.cE().onFilterChange();
    }

    @Override
    public void onFinish() {
        this.cE().onFinish();
    }

    @Override
    public void onInit() throws Exception {
        this.cE().onInit();
    }

    @Override
    public void onProgressUpdate(float progress) {
        this.cE().onProgressUpdate(progress);
    }

    @Override
    public void setModel(ResultModel newModel) {
        this.cE().setModel(newModel);
    }

    @Override
    public BasePresenter spawn(boolean spawnWithParent) {
        ReportPresenter reportPresenter = this.pD == null ? new ReportPresenter(this.pA, this.pB, this.pC, this.pE, this.pn == null ? this.s : this.pn, this.pn == null) : new ReportPresenter(this.pA, this.pB, this.pC, this.pE, this.pD);
        reportPresenter.setPassword(this.password);
        return reportPresenter;
    }

    protected OutputStream getExportStream() throws IOException {
        return this.pD;
    }

    public void setExportFormat(String exportFormat) {
        if (exportFormat == null ? this.pE == null : exportFormat.equals(this.pE)) {
            return;
        }
        this.pE = exportFormat;
        this.pF = true;
    }

    public void setPassword(String password) {
        this.password = password;
        this.pF = true;
    }

    private BasePresenter cE() {
        if (this.pz == null || this.pF) {
            this.pF = false;
            try {
                ReportPDFPresenterFactory reportPDFPresenterFactory = PluginManager.getSingleInstance(ReportPDFPresenterFactory.class);
                this.pz = reportPDFPresenterFactory.createPresenter(this.pA, this.pB, this.pC, new a(), this.pE, this.password);
            }
            catch (RuntimeException runtimeException) {
                PDFCCore.LOGGER_PRESENTER.debug((Object)runtimeException);
                throw new IllegalStateException("Using the ReportPDFPresenter requires an activated 'reporting' plugin.");
            }
        }
        return this.pz;
    }

    private final class a
    implements OutputStreamProvider {
        private a() {
        }

        @Override
        public OutputStream getExportStream() throws IOException {
            OutputStream outputStream = ReportPresenter.this.getExportStream();
            if (outputStream != null) {
                return outputStream;
            }
            if (!(ReportPresenter.this.s.exists() || ReportPresenter.this.s.mkdirs() || ReportPresenter.this.s.isDirectory())) {
                throw new IOException("Could not create output folder '" + ReportPresenter.this.s.getAbsolutePath() + "'");
            }
            if (ReportPresenter.this.pn == null) {
                ReportPresenter.this.pn = new File(ReportPresenter.this.s, ReportPresenter.this.getDefaultExportName(ReportPresenter.this.pB ? "Detailed_Report" : "Report") + "." + ReportPresenter.this.pE);
            }
            return new FastBufferedOutputStream((OutputStream)new FileOutputStream(ReportPresenter.this.pn), 32768);
        }
    }
}

