/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.model;

import com.inet.annotations.InternalApi;
import java.awt.Color;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.util.Arrays;

@InternalApi
public class PaintComparator {
    private int hk;
    private double hl;

    public PaintComparator(double hsvTolerance) {
        this.hl = hsvTolerance;
        this.hk = (int)Math.round(hsvTolerance * 255.0);
    }

    public boolean canCompare(Paint p) {
        if (p == null) {
            return true;
        }
        if (p instanceof Color || p instanceof RadialGradientPaint || p instanceof LinearGradientPaint) {
            return true;
        }
        try {
            return p.getClass().getDeclaredMethod("equals", Object.class) != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isEqual(Paint p1, Paint p2) {
        if (p1 == null) {
            return p2 == null;
        }
        if (p2 == null) {
            return false;
        }
        if (p1 instanceof RadialGradientPaint && p2 instanceof RadialGradientPaint) {
            RadialGradientPaint radialGradientPaint = (RadialGradientPaint)p1;
            RadialGradientPaint radialGradientPaint2 = (RadialGradientPaint)p2;
            if (!this.a(radialGradientPaint.getColors(), radialGradientPaint2.getColors())) {
                return false;
            }
            if (radialGradientPaint.getCycleMethod() != radialGradientPaint2.getCycleMethod()) {
                return false;
            }
            if (!radialGradientPaint.getFocusPoint().equals(radialGradientPaint2.getFocusPoint())) {
                return false;
            }
            if (!Arrays.equals(radialGradientPaint.getFractions(), radialGradientPaint2.getFractions())) {
                return false;
            }
            return !(radialGradientPaint.getRadius() - radialGradientPaint2.getRadius() > 1.0f);
        }
        if (p1 instanceof LinearGradientPaint && p2 instanceof LinearGradientPaint) {
            LinearGradientPaint linearGradientPaint = (LinearGradientPaint)p1;
            LinearGradientPaint linearGradientPaint2 = (LinearGradientPaint)p2;
            if (!this.a(linearGradientPaint.getColors(), linearGradientPaint2.getColors())) {
                return false;
            }
            if (linearGradientPaint.getCycleMethod() != linearGradientPaint2.getCycleMethod()) {
                return false;
            }
            if (!Arrays.equals(linearGradientPaint.getFractions(), linearGradientPaint2.getFractions())) {
                return false;
            }
            if (!linearGradientPaint.getStartPoint().equals(linearGradientPaint2.getStartPoint())) {
                return false;
            }
            return linearGradientPaint.getEndPoint().equals(linearGradientPaint2.getEndPoint());
        }
        if (p1 instanceof Color && p2 instanceof Color) {
            return this.a((Color)p1, (Color)p2);
        }
        return p1.equals(p2) || p2.equals(p1);
    }

    private boolean a(Color[] colorArray, Color[] colorArray2) {
        if (colorArray == null) {
            return colorArray2 == null;
        }
        if (colorArray2 == null) {
            return false;
        }
        if (colorArray.length != colorArray2.length) {
            return false;
        }
        for (int i = 0; i < colorArray.length; ++i) {
            if (this.a(colorArray[i], colorArray2[i])) continue;
            return false;
        }
        return true;
    }

    private boolean a(Color color, Color color2) {
        if (Math.abs(color.getRed() - color2.getRed()) <= this.hk && Math.abs(color.getGreen() - color2.getGreen()) <= this.hk && Math.abs(color.getBlue() - color2.getBlue()) <= this.hk && Math.abs(color.getAlpha() - color2.getAlpha()) <= this.hk) {
            return true;
        }
        float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), new float[3]);
        float[] fArray2 = Color.RGBtoHSB(color2.getRed(), color2.getGreen(), color2.getBlue(), new float[3]);
        return PaintComparator.a(fArray, fArray2, this.hl);
    }

    private static boolean a(float[] fArray, float[] fArray2, double d2) {
        if (!PaintComparator.a(fArray[2], fArray2[2], d2)) {
            return false;
        }
        if (!(fArray[2] + fArray2[2] > 0.0f)) {
            return true;
        }
        if (!PaintComparator.a(fArray[1], fArray2[1], d2 /= (double)((fArray[2] + fArray2[2]) / 2.0f))) {
            return false;
        }
        if (!(fArray[1] + fArray2[1] > 0.0f)) {
            return true;
        }
        if (!PaintComparator.a(fArray[0], fArray2[0], d2 /= (double)((fArray[1] + fArray2[1]) / 2.0f))) {
            float f2;
            float f3 = f2 = fArray2[0] < fArray[0] ? fArray2[0] + 1.0f : fArray2[0] - 1.0f;
            if (!PaintComparator.a(fArray[0], f2, d2)) {
                return false;
            }
        }
        return true;
    }

    private static boolean a(double d2, double d3, double d4) {
        return !(Math.abs(d3 - d2) > d4);
    }
}

