/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.generator.model;

import com.inet.annotations.JsonData;
import com.inet.pdfc.generator.model.MinifiedElement;
import com.inet.pdfc.model.DrawableElement;
import com.inet.pdfc.model.ElementID;
import com.inet.pdfc.model.ElementType;
import java.awt.geom.Rectangle2D;

@JsonData
public class MinifiedDrawableElement
extends DrawableElement {
    private ElementType type = null;
    private Rectangle2D.Float bounds = null;

    private MinifiedDrawableElement() {
        super(0, ElementID.DUMMY);
    }

    public MinifiedDrawableElement(Rectangle2D.Float bounds, ElementType type, int pageIndex, ElementID id) {
        super(pageIndex, id);
        this.bounds = bounds;
        this.type = type;
    }

    public MinifiedDrawableElement(DrawableElement source) {
        super(source.getPageIndex(), source.getElementID());
        this.type = source.getType();
        this.bounds = MinifiedElement.getBoundsFloat(source.getBounds());
    }

    @Override
    public ElementType getType() {
        return this.type;
    }

    @Override
    public void setX(double x) {
    }

    @Override
    public void setY(double y) {
    }

    @Override
    public double getX() {
        return this.bounds.getX();
    }

    @Override
    public double getY() {
        return this.bounds.getY();
    }

    @Override
    public Rectangle2D getBounds() {
        return this.bounds;
    }

    @Override
    public int getCompareHash() {
        return 0;
    }

    @Override
    public String getLabel() {
        return this.getType().name();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MinifiedDrawableElement)) {
            return false;
        }
        MinifiedDrawableElement minifiedDrawableElement = (MinifiedDrawableElement)obj;
        if (minifiedDrawableElement.type != this.type || minifiedDrawableElement.getPageIndex() != this.getPageIndex()) {
            return false;
        }
        if (minifiedDrawableElement.bounds == null || this.bounds == null) {
            return false;
        }
        return minifiedDrawableElement.bounds.equals(this.bounds);
    }

    public String toString() {
        return "Minified, Page " + this.getPageIndex() + ", " + String.valueOf(this.getType()) + ", " + (String)(this.bounds != null ? "[" + this.bounds.getX() + ", " + this.bounds.getY() + ", " + this.bounds.getWidth() + ", " + this.bounds.getHeight() + "]" : "nobounds");
    }
}

