/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.generator.filter;

import com.inet.annotations.InternalApi;
import com.inet.pdfc.generator.message.AnnotationHighlight;
import com.inet.pdfc.generator.message.HighlightData;
import com.inet.pdfc.model.AnnotationElement;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

@InternalApi
public class AnnotationTreeEntry
implements Comparable<AnnotationTreeEntry> {
    private AnnotationHighlight eq;
    private int pageIndex;
    private boolean er;
    private int es;
    private int et;
    private AnnotationHighlight eu;
    private AnnotationHighlight ev;
    private AnnotationTreeEntry ew;
    private List<AnnotationTreeEntry> children;

    public static List<AnnotationTreeEntry> convertHighlights(List<HighlightData.Highlight> annotations, int pageIndex, boolean first) {
        int n = 0;
        HashMap<Integer, AnnotationTreeEntry> hashMap = new HashMap<Integer, AnnotationTreeEntry>();
        ArrayList<AnnotationTreeEntry> arrayList = new ArrayList<AnnotationTreeEntry>();
        ArrayList<AnnotationTreeEntry> cloneable = new ArrayList<AnnotationTreeEntry>(annotations.size());
        for (HighlightData.Highlight cloneable2 : annotations) {
            AnnotationHighlight annotationHighlight = (AnnotationHighlight)cloneable2;
            AnnotationTreeEntry annotationTreeEntry = new AnnotationTreeEntry(annotationHighlight, pageIndex, first, n++);
            if (annotationHighlight.getId() >= 0) {
                hashMap.put(annotationHighlight.getId(), annotationTreeEntry);
            }
            cloneable.add(annotationTreeEntry);
        }
        Collections.sort(cloneable);
        int n2 = -1;
        while (cloneable.size() > 0 && n2 != cloneable.size()) {
            n2 = cloneable.size();
            ArrayList<AnnotationTreeEntry> arrayList2 = new ArrayList<AnnotationTreeEntry>();
            for (AnnotationTreeEntry annotationTreeEntry : cloneable) {
                AnnotationHighlight annotationHighlight = annotationTreeEntry.eq;
                if (annotationHighlight.getIrtID() >= 0) {
                    AnnotationTreeEntry annotationTreeEntry2 = (AnnotationTreeEntry)hashMap.get(annotationHighlight.getIrtID());
                    if (annotationTreeEntry2 != null) {
                        annotationTreeEntry2.addChild(annotationTreeEntry);
                        continue;
                    }
                    arrayList2.add(annotationTreeEntry);
                    continue;
                }
                arrayList.add(annotationTreeEntry);
            }
            cloneable = arrayList2;
        }
        if (cloneable.size() > 0) {
            arrayList.addAll(cloneable);
        }
        return arrayList;
    }

    public AnnotationTreeEntry(AnnotationHighlight highlight, int pageIndex, boolean leftSide, int originalIndex) {
        if (highlight == null) {
            throw new IllegalArgumentException("Cannot create and empty annoation data");
        }
        this.eq = highlight;
        this.pageIndex = pageIndex;
        this.er = leftSide;
        this.es = originalIndex;
    }

    public AnnotationHighlight getHighlight() {
        return this.eq;
    }

    public AnnotationElement.STATE getStateReviewed() {
        return this.ev != null ? this.ev.getState() : null;
    }

    public AnnotationElement.STATE getStateMarked() {
        return this.eu != null ? this.eu.getState() : null;
    }

    public Date getReviewDate() {
        return this.ev != null ? this.ev.getCreationDate() : null;
    }

    public String getCaption() {
        return this.eq.getCaption();
    }

    public String getAuthor() {
        return this.eq.getAuthor();
    }

    public Color getColor() {
        return this.eq.getColor();
    }

    public String getReviewAuthor() {
        return this.ev != null ? this.ev.getAuthor() : null;
    }

    public int getPageIndex() {
        return this.pageIndex;
    }

    public boolean isLeftSide() {
        return this.er;
    }

    public AnnotationTreeEntry getParent() {
        return this.ew;
    }

    public int getIndent() {
        return this.et;
    }

    public List<AnnotationTreeEntry> getChildren() {
        return this.children;
    }

    public void addChild(AnnotationTreeEntry child) {
        child.ew = this;
        child.et = this.et + 1;
        AnnotationHighlight annotationHighlight = child.eq;
        AnnotationTreeEntry annotationTreeEntry = this.getParentToUpdate();
        if (this.ew != null && annotationHighlight.getStateModel() == AnnotationElement.STATE_MODEL.Marked) {
            annotationTreeEntry.eu = annotationHighlight;
        } else if (this.ew != null && annotationHighlight.getStateModel() == AnnotationElement.STATE_MODEL.Review) {
            annotationTreeEntry.ev = annotationHighlight;
        } else {
            if (this.children == null) {
                this.children = new ArrayList<AnnotationTreeEntry>();
            }
            this.children.add(child);
        }
    }

    public void setVisible(boolean visible) {
        this.eq.setVisible(visible);
        if (this.children != null) {
            for (AnnotationTreeEntry annotationTreeEntry : this.children) {
                annotationTreeEntry.setVisible(visible);
            }
        }
    }

    public AnnotationTreeEntry getParentToUpdate() {
        AnnotationTreeEntry annotationTreeEntry = this;
        while (annotationTreeEntry != null && annotationTreeEntry.eq != null && annotationTreeEntry.eq.getStateModel() != null) {
            annotationTreeEntry = annotationTreeEntry.ew;
        }
        return annotationTreeEntry != null ? annotationTreeEntry : this;
    }

    public List<AnnotationTreeEntry> getAncestors() {
        if (this.children == null || this.children.isEmpty()) {
            return null;
        }
        ArrayList<AnnotationTreeEntry> arrayList = new ArrayList<AnnotationTreeEntry>();
        for (AnnotationTreeEntry annotationTreeEntry : this.children) {
            arrayList.add(annotationTreeEntry);
            List<AnnotationTreeEntry> list = annotationTreeEntry.getAncestors();
            if (list == null) continue;
            arrayList.addAll(list);
        }
        return arrayList;
    }

    @Override
    public int compareTo(AnnotationTreeEntry o) {
        int n = (int)(this.eq.getCenterY() - o.eq.getCenterY());
        if (n != 0) {
            return n;
        }
        int n2 = this.eq.x - o.eq.x;
        if (n2 != 0) {
            return n2;
        }
        return this.es - o.es;
    }
}

