/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.presenter;

import com.inet.annotations.PublicApi;
import com.inet.error.ErrorCode;
import com.inet.pdfc.error.PdfcErrorCode;
import com.inet.pdfc.error.PdfcException;
import com.inet.pdfc.i18n.Msg;
import com.inet.pdfc.presenter.BasePresenter;
import com.inet.pdfc.presenter.ExportPresenter;
import com.inet.pdfc.print.PrintPainter;
import com.inet.pdfc.print.PrintToPrinter;
import com.inet.pdfc.print.PrintToX;
import java.awt.print.PrinterJob;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.print.PrintService;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;

@PublicApi
public class DifferencesPrintPresenter
extends ExportPresenter {
    private PrintService pi;
    private PrintRequestAttributeSet pj;

    public String getExtensionName() {
        return "Presenter_Print";
    }

    public DifferencesPrintPresenter(@Nonnull PrintService service, PrintRequestAttributeSet attributes) {
        this.pi = service;
        this.pj = attributes;
        Objects.requireNonNull(service, "Service cannot be null");
    }

    @Override
    public void onComparisonDone() throws Exception {
        if (this.getModel().getDifferencesCount(true) == 0) {
            LOGGER.info((Object)Msg.getMsg("Export.doNothingNoDiffs", this.getModel().getComparisonParameters().getFirstFile().getName(), this.getModel().getComparisonParameters().getSecondFile().getName()));
            return;
        }
        PrintPainter printPainter = this.createAndSetupPrintPainter();
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        printerJob.setPrintService(this.pi);
        PrintToPrinter printToPrinter = new PrintToPrinter(printPainter, printerJob, new HashPrintRequestAttributeSet(this.pj));
        try {
            ((PrintToX)printToPrinter).export();
        }
        catch (Exception exception) {
            throw PdfcException.create((ErrorCode)PdfcErrorCode.errorWhilePresenting, exception, new Object[0]);
        }
    }

    @Override
    public BasePresenter spawn(boolean spawnWithParent) {
        DifferencesPrintPresenter differencesPrintPresenter = (DifferencesPrintPresenter)super.spawn(spawnWithParent);
        return differencesPrintPresenter;
    }
}

