/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.plugin.persistence;

import com.inet.annotations.InternalApi;
import com.inet.id.GUID;
import com.inet.pdfc.config.DefaultProfile;
import com.inet.pdfc.plugin.persistence.ComparePersistence;
import com.inet.pdfc.plugin.persistence.ProfilePersistence;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;

@InternalApi
public interface ProfilePersistenceManager {
    public void reindex();

    public ProfilePersistence create(@Nonnull GUID var1, @Nonnull DefaultProfile var2) throws IOException;

    public ProfilePersistence getUserProfile(GUID var1, String var2) throws IOException;

    public List<ProfilePersistence> getAllProfiles(GUID var1) throws IOException;

    public boolean isPublishedForUser(GUID var1, GUID var2);

    public ProfilePersistence getProfile(GUID var1, GUID var2) throws IOException;

    public boolean remove(GUID var1, GUID var2) throws IOException;

    public boolean save(ProfilePersistence var1, GUID var2) throws IOException;

    public boolean update(GUID var1, DefaultProfile var2, GUID var3) throws IOException;

    public boolean rename(GUID var1, GUID var2, String var3) throws IOException;

    public boolean publish(GUID var1, GUID var2, Set<ComparePersistence.UserOrGroup> var3) throws IOException;

    public String duplicate(String var1, GUID var2, String var3) throws IOException;

    public boolean checkProfileName(GUID var1, String var2) throws IOException;

    public void addChangeListener(ProfilePersistenceChangeListener var1);

    public void removeChangeListener(ProfilePersistenceChangeListener var1);

    @InternalApi
    public static final class ChangeType
    extends Enum<ChangeType> {
        public static final /* enum */ ChangeType REMOVED = new ChangeType();
        public static final /* enum */ ChangeType ADDED = new ChangeType();
        public static final /* enum */ ChangeType CHANGED = new ChangeType();
        public static final /* enum */ ChangeType PUBLISHED = new ChangeType();
        public static final /* enum */ ChangeType UNPUBLISHED = new ChangeType();
        private static final /* synthetic */ ChangeType[] nH;

        public static ChangeType[] values() {
            return (ChangeType[])nH.clone();
        }

        public static ChangeType valueOf(String name) {
            return Enum.valueOf(ChangeType.class, name);
        }

        private static /* synthetic */ ChangeType[] bZ() {
            return new ChangeType[]{REMOVED, ADDED, CHANGED, PUBLISHED, UNPUBLISHED};
        }

        static {
            nH = ChangeType.bZ();
        }
    }

    @InternalApi
    public static interface ProfilePersistenceChangeListener {
        public void profileChanged(ProfilePersistence var1, ChangeType var2, boolean var3);
    }
}

