/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.i18n;

import com.inet.annotations.InternalApi;
import com.inet.classloader.I18nMessages;
import com.inet.http.servlet.ClientLocale;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;

@InternalApi
public class Msg {
    public static final String CONSOLE_HELP = "ConsoleTool.Help";
    public static final String CONSOLE_HELP_COMMAND = "ConsoleTool.Help.Command";
    public static final String NOT_EXIST = "Error.DoesNotExist";
    public static final String NOT_READABLE = "Error.CannotRead";
    public static final String NOT_DIRECTORY = "Error.NotDiretory";
    public static final String NAME_IS_NULL = "Error.NameIsNull";
    public static final String CONTENT_IS_NULL = "Error.ContentIsNull";
    public static final String IS_DIRECTORY = "Error.IsDiretory";
    public static final String MUST_BE_EQUAL_TYPES = "Error.ParametersMustBeEqualTypes";
    public static final String NO_DIFFERENCES_FOUND = "Status.NoDifferencesFound";
    public static final String DIFFERENCES_FOUND = "Status.DifferencesFound";
    public static final String MORE_DIFFERENCES = "Status.MoreDifferences";
    public static final String TOTAL_DIFFERENCES = "Status.TotalDifferences";
    public static final String WRONG_IMAGE_SIZE = "module.image.diff.WrongImageSize";
    public static final String RESULT_SUMMARY = "Status.ResultSummary";
    public static final String RESULT_SUMMARY_HEADER1 = "Status.ResultSummaryH1";
    public static final String RESULT_SUMMARY_HEADER2 = "Status.ResultSummaryH2";
    public static final String RESULT_SUMMARY_REMOVED = "Status.ResultSummaryRemoved";
    public static final String RESULT_SUMMARY_ADDED = "Status.ResultSummaryAdded";
    public static final String LICENSE_EXPIRED = "License.Expired";
    public static final String LICENSE_IS_TRIAL = "License.IsTrial";
    public static final String LICENSE_BETA_EXPIRED = "License.BetaExpired";
    public static final String LICENSE_NO_CONN_CONSOLE = "License.NoConnConsole";
    public static final String LICENSE_ACTIVATION_KEY = "License.ActivationKey";
    public static final String LICENSE_UID = "License.UID";
    public static final String LICENSE_INVALID = "License.Invalid";
    public static final String LICENSE_ACTIVATION_KEY_INVALID = "License.ActivationKeyInvalid";
    public static final String LICENSE_ACTIVATED = "License.Activated";
    public static final String LICENSE_NOT_SERVER = "License.NotServer";
    public static final String LICENSE_NOT_API = "License.NotAPI";
    public static final String LICENSE_NOT_COMMANDLINE = "License.NotCommandline";
    public static final String LICENSE_NOT_GUI = "License.NotGUI";
    private static Map<String, ResourceBundleProvider> jd = new ConcurrentHashMap<String, ResourceBundleProvider>();

    private static I18nMessages t(String string) {
        ResourceBundleProvider resourceBundleProvider;
        if (string != null && (resourceBundleProvider = jd.get(string)) != null) {
            return resourceBundleProvider.getBundle();
        }
        return new I18nMessages("com.inet.pdfc.i18n.LanguageResources", Msg.class);
    }

    public static String getMsg(String msgID) {
        return Msg.getMsg(msgID, null);
    }

    public static boolean hasMsg(@Nonnull String msgID, @Nonnull Locale locale) {
        String string = null;
        int n = msgID.indexOf(58);
        if (n > 0) {
            string = msgID.substring(0, n);
            msgID = msgID.substring(n + 1);
        }
        I18nMessages i18nMessages = Msg.t(string);
        return i18nMessages.hasMsg(msgID, locale);
    }

    public static boolean hasMsg(@Nonnull String msgID) {
        return Msg.hasMsg(msgID, ClientLocale.getThreadLocale());
    }

    @Nonnull
    public static String getMsg(String msgID, Object ... msgParameter) {
        String string = null;
        int n = msgID.indexOf(58);
        if (n > 0) {
            string = msgID.substring(0, n);
            msgID = msgID.substring(n + 1);
        }
        I18nMessages i18nMessages = Msg.t(string);
        if (msgParameter == null) {
            return i18nMessages.getMsg(msgID, new Object[0]);
        }
        Locale locale = ClientLocale.getThreadLocale();
        if (msgParameter.length > 0 && msgParameter[0] instanceof Locale) {
            locale = (Locale)msgParameter[0];
            i18nMessages = Msg.t(string);
            Object[] objectArray = new Object[msgParameter.length - 1];
            System.arraycopy(msgParameter, 1, objectArray, 0, objectArray.length);
            msgParameter = objectArray;
        }
        return i18nMessages.getMsg(locale, msgID, msgParameter);
    }

    public static void addPluginBundle(String pluginID, ResourceBundleProvider bundleProvider) {
        jd.put(pluginID, bundleProvider);
    }

    @InternalApi
    public static interface ResourceBundleProvider {
        public I18nMessages getBundle();
    }
}

